/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.net.InetAddress;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.dr.DrReceiverMBean;
import org.gridgain.grid.dr.DrReceiverOutMetrics;
import org.gridgain.grid.internal.processors.dr.DrMetricsManager;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrReceiverInMetricsHolder;

public class DrReceiverMBeanImpl
implements DrReceiverMBean {
    private final DrReceiverConfiguration cfg;
    private final String locHost;
    private final DrProcessor proc;

    public DrReceiverMBeanImpl(DrProcessor proc, DrReceiverConfiguration cfg, InetAddress locHost) {
        this.proc = proc;
        this.cfg = cfg;
        this.locHost = locHost.toString();
    }

    @Override
    public String getLocalInboundHost() {
        return this.locHost;
    }

    @Override
    public int getLocalInboundPort() {
        return this.cfg.getLocalInboundPort();
    }

    @Override
    public int getSelectorCount() {
        return this.cfg.getSelectorCount();
    }

    @Override
    public int getWorkerThreads() {
        return this.cfg.getWorkerThreads();
    }

    @Override
    public int getMessageQueueLimit() {
        return this.cfg.getMessageQueueLimit();
    }

    @Override
    public boolean isTcpNodelay() {
        return this.cfg.isTcpNodelay();
    }

    @Override
    public boolean isDirectBuffer() {
        return this.cfg.isDirectBuffer();
    }

    @Override
    public long getIdleTimeout() {
        return this.cfg.getIdleTimeout();
    }

    @Override
    public long getWriteTimeout() {
        return this.cfg.getWriteTimeout();
    }

    @Override
    public long getFlushFrequency() {
        return this.cfg.getFlushFrequency();
    }

    @Override
    public int getPerNodeBufferSize() {
        return this.cfg.getPerNodeBufferSize();
    }

    @Override
    public int getPerNodeParallelLoadOperations() {
        return this.cfg.getPerNodeParallelLoadOperations();
    }

    @Override
    public String metricsFormatted() {
        DrMetricsManager m = this.proc.metrics();
        DrReceiverInMetricsHolder in = m.receiverHubInMetrics();
        DrReceiverOutMetrics out = m.receiverHubOutMetrics();
        assert (in != null);
        assert (out != null);
        return "Metrics [" + in + ", " + out + ']';
    }
}

