/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.gridgain.grid.internal.processors.cache.dr.ist.messages.DrStateRecord;

public class DrPartitionStatesMessage
implements Message {
    private static final long serialVersionUID = 0L;
    public static final int TYPE_CODE = 177;
    private AffinityTopologyVersion topVer;
    @GridDirectCollection(value=DrStateRecord.class)
    private List<DrStateRecord> partStates;

    public DrPartitionStatesMessage() {
    }

    public DrPartitionStatesMessage(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public List<DrStateRecord> partStates() {
        return this.partStates;
    }

    public AffinityTopologyVersion topVer() {
        return this.topVer;
    }

    public void topVer(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public void addPartSate(DrStateRecord state) {
        if (this.partStates == null) {
            this.partStates = new ArrayList<DrStateRecord>();
        }
        this.partStates.add(state);
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("partStates", this.partStates, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.partStates = (List)reader.readCollection("partStates", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(DrPartitionStatesMessage.class);
    }

    public short directType() {
        return 177;
    }

    public byte fieldsCount() {
        return 2;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(DrPartitionStatesMessage.class, (Object)this);
    }
}

