/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoEssential;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoExtended;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.jetbrains.annotations.Nullable;

public interface GridSnapshotManager {
    public static Set<String> getAllCachesForSnapshot(Collection<DynamicCacheDescriptor> cacheDescs) {
        return cacheDescs.stream().filter(desc -> (desc.cacheType().userCache() || desc.cacheType() == CacheType.DATA_STRUCTURES && CU.cacheId((String)"default-volatile-ds-group") != desc.groupId()) && desc.groupDescriptor().persistenceEnabled() && desc.cacheConfiguration().getCacheMode() != CacheMode.LOCAL && desc.cacheConfiguration().getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT).map(DynamicCacheDescriptor::cacheName).collect(Collectors.toSet());
    }

    public GridSnapshot dbApi();

    public SnapshotFuture<Void> startGlobalSnapshotCreation(Set<String> var1, @Nullable File var2, boolean var3, @Nullable Map<String, Serializable> var4, @Nullable String var5, @Nullable IgniteUuid var6, SnapshotCreateParameters var7);

    public SnapshotFuture<Void> startGlobalSnapshotCreation(Set<String> var1, @Nullable File var2, boolean var3, @Nullable Map<String, Serializable> var4, @Nullable String var5, @Nullable IgniteUuid var6, SnapshotCommonParameters var7, SnapshotCreateParameters var8);

    public SnapshotFuture<Void> startGlobalSnapshotRestore(long var1, @Nullable Set<String> var3, boolean var4, @Nullable Collection<SnapshotPath> var5, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> var6, @Nullable String var7, SnapshotCommonParameters var8, @Nullable Map<String, Serializable> var9) throws IgniteCheckedException;

    public SnapshotFuture<Void> startGlobalSnapshotRestore(long var1, @Nullable Set<String> var3, @Nullable Set<String> var4, boolean var5, @Nullable Collection<SnapshotPath> var6, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> var7, @Nullable String var8, SnapshotCommonParameters var9, @Nullable Map<String, Serializable> var10) throws IgniteCheckedException;

    public List<SnapshotInfoEssential> getSnapshotList(@Nullable Collection<SnapshotPath> var1) throws IgniteCheckedException;

    public SnapshotFuture<Void> startGlobalSnapshotDeletion(long var1, SnapshotUpdateOperationParameters var3, @Nullable String var4) throws IgniteCheckedException;

    public SnapshotFuture<List<SnapshotIssue>> startGlobalSnapshotCheck(long var1, SnapshotOperationType var3, Set<String> var4, boolean var5, Collection<SnapshotPath> var6, boolean var7, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> var8, @Nullable String var9, SnapshotCommonParameters var10) throws IgniteCheckedException;

    public SnapshotFuture<List<SnapshotIssue>> startGlobalSnapshotCheck(long var1, SnapshotOperationType var3, @Nullable Set<String> var4, @Nullable Set<String> var5, boolean var6, Collection<SnapshotPath> var7, boolean var8, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> var9, @Nullable String var10, SnapshotCommonParameters var11) throws IgniteCheckedException;

    public SnapshotFuture<Void> startGlobalSnapshotMoving(long var1, SnapshotPath var3, boolean var4, SnapshotUpdateOperationParameters var5, @Nullable String var6) throws IgniteCheckedException;

    public SnapshotFuture<Void> startGlobalSnapshotCopying(long var1, SnapshotPath var3, boolean var4, SnapshotUpdateOperationParameters var5, String var6) throws IgniteCheckedException;

    public SnapshotFuture<Void> startGlobalCustomSnapshotOperation(CustomStagesConfiguration var1, @Nullable String var2);

    public SnapshotStatus getOngoingOperation() throws IgniteCheckedException;

    public IgniteFuture getOngoingOperationFuture();

    public IgniteInternalFuture<Boolean> cancelSnapshotOperation(IgniteUuid var1, boolean var2, String var3) throws IgniteCheckedException;

    @Nullable
    public SnapshotInfoExtended getSnapshotInfo(long var1, @Nullable Collection<SnapshotPath> var3) throws IgniteCheckedException;

    public SnapshotFuture<Void> startGlobalRecoveryToPointInTime(long var1, @Nullable Collection<SnapshotPath> var3, @Nullable Set<String> var4, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> var5, @Nullable String var6) throws IgniteCheckedException;

    public SnapshotFuture<Void> startGlobalConsistentCut();

    public SnapshotFuture<Void> startGlobalConsistentCut(@Nullable Map<String, Serializable> var1);

    public void applyConsistentCut(long var1, long var3, boolean var5, IgniteInClosure<WALPointer> var6) throws IgniteCheckedException;

    public SnapshotFuture<Long> startGlobalReplicationRecovery(Set<UUID> var1, long var2, String var4) throws IgniteCheckedException;

    public void updateSnapshotSecurityLevel(SnapshotSecurityLevel var1) throws IgniteCheckedException;

    public SnapshotSecurityLevel getSnapshotSecurityLevel();

    public SnapshotMetadata snapshotMetadata(long var1, Collection<SnapshotRemotePath> var3) throws IgniteCheckedException;

    public boolean pointInTimeRecoveryEnabled();
}

