/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.interop.persistentstore;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformAsyncResult;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.gridgain.grid.persistentstore.SnapshotStatus;

public class InteropSnapshot
extends PlatformAbstractTarget {
    private static final int OP_CREATE_FULL_SNAPSHOT = 1;
    private static final int OP_CREATE_SNAPSHOT = 2;
    private static final int OP_GET_SNAPSHOTS = 3;
    private static final int OP_GET_SNAPSHOT = 4;
    private static final int OP_RESTORE_SNAPSHOT = 5;
    private static final int OP_DELETE_SNAPSHOT = 6;
    private static final int OP_FORCE_DELETE_SNAPSHOT = 7;
    private static final int OP_CHECK_SNAPSHOT = 8;
    private static final int OP_MOVE_SNAPSHOT = 9;
    private static final int OP_FORCE_MOVE_SNAPSHOT = 10;
    private static final int OP_GET_SNAPSHOT_STATUS = 11;
    private static final int OP_CANCEL_SNAPSHOT = 12;
    private static final int OP_FUT = 14;
    private static final int OP_CHECK_FUT = 15;
    private final GridSnapshot snap;
    private static final ThreadLocal<SnapshotFuture> curFut = new ThreadLocal();

    public InteropSnapshot(PlatformContext platformCtx) {
        super(platformCtx);
        GridGain gg = (GridGain)platformCtx.kernalContext().grid().plugin("GridGain");
        this.snap = gg.snapshot();
    }

    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 4: {
                SnapshotInfoEx gridSnap = this.snap.snapshot(reader.readLong(), InteropSnapshot.readFileCollection((BinaryRawReader)reader));
                InteropSnapshot.writeSnapshotInfo((BinaryRawWriter)writer, gridSnap);
                return;
            }
            case 3: {
                List<SnapshotInfo> gridSnaps = this.snap.listSnapshots(InteropSnapshot.readFileCollection((BinaryRawReader)reader));
                if (gridSnaps != null) {
                    writer.writeInt(gridSnaps.size());
                    for (SnapshotInfo si : gridSnaps) {
                        InteropSnapshot.writeSnapshotInfo((BinaryRawWriter)writer, si);
                    }
                } else {
                    writer.writeInt(-1);
                }
                return;
            }
        }
        super.processInStreamOutStream(type, reader, writer);
    }

    public PlatformAsyncResult processInStreamAsync(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 1: 
            case 2: {
                Set<String> cacheNames = InteropSnapshot.readStringSet((BinaryRawReader)reader);
                String message = reader.readString();
                SnapshotFuture<Void> fut = type == 1 ? this.snap.createFullSnapshot(cacheNames, message) : this.snap.createSnapshot(cacheNames, message);
                return this.getInitAsyncResult(fut);
            }
            case 5: {
                long snapshotId = reader.readLong();
                Collection<File> files = InteropSnapshot.readFileCollection((BinaryRawReader)reader);
                Set<String> cacheNames = InteropSnapshot.readStringSet((BinaryRawReader)reader);
                String message = reader.readString();
                SnapshotFuture<Void> fut = this.snap.restoreSnapshot(snapshotId, files, cacheNames, message);
                return this.getInitAsyncResult(fut);
            }
            case 8: {
                long snapshotId = reader.readLong();
                Collection<File> files = InteropSnapshot.readFileCollection((BinaryRawReader)reader);
                String message = reader.readString();
                boolean skipCrc = reader.readBoolean();
                SnapshotFuture<List<SnapshotIssue>> fut = this.snap.checkSnapshot(snapshotId, files, skipCrc, message);
                return this.getInitAsyncResult(fut);
            }
            case 6: 
            case 7: {
                long snapshotId = reader.readLong();
                String message = reader.readString();
                SnapshotFuture<Void> fut = type == 7 ? this.snap.forceDeleteSnapshot(snapshotId, message) : this.snap.deleteSnapshot(snapshotId, (SnapshotUpdateOperationParameters)null, message);
                return this.getInitAsyncResult(fut);
            }
            case 9: 
            case 10: {
                long snapshotId = reader.readLong();
                String destPath = reader.readString();
                String message = reader.readString();
                SnapshotFuture<Void> fut = type == 10 ? this.snap.forceMoveSnapshot(snapshotId, new File(destPath), message) : this.snap.moveSnapshot(snapshotId, new File(destPath), message);
                return this.getInitAsyncResult(fut);
            }
            case 12: {
                IgniteUuid opId = new IgniteUuid(reader.readUuid(), reader.readLong());
                String message = reader.readString();
                IgniteFuture<Boolean> fut = this.snap.cancelSnapshotOperation(opId, message);
                return this.getObjectAsyncResult(fut);
            }
            case 14: {
                SnapshotFuture fut = curFut.get();
                assert (fut != null);
                curFut.remove();
                return this.getObjectAsyncResult(fut);
            }
            case 15: {
                final SnapshotFuture fut = curFut.get();
                assert (fut != null);
                curFut.remove();
                return new PlatformAsyncResult(){

                    public IgniteFuture future() {
                        return fut;
                    }

                    public void write(BinaryRawWriterEx writer, Object result) {
                        Collection res = (Collection)result;
                        if (res != null) {
                            writer.writeInt(res.size());
                            for (SnapshotIssue si : res) {
                                writer.writeString(si.getCacheName());
                                writer.writeInt(si.getPartitionId());
                                writer.writeString(si.getIssue());
                            }
                        } else {
                            writer.writeInt(-1);
                        }
                    }
                };
            }
        }
        return super.processInStreamAsync(type, reader);
    }

    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 11) {
            SnapshotStatus op = this.snap.ongoingSnapshotOperation();
            if (op == null) {
                writer.writeBoolean(false);
                return;
            }
            writer.writeBoolean(true);
            InteropSnapshot.writeIgniteUuid((BinaryRawWriter)writer, op.operationId());
            InteropSnapshot.writeSnapshotOperation((BinaryRawWriter)writer, op.operation());
            Map<UUID, SnapshotProgress> prog = op.progress();
            if (prog != null) {
                writer.writeInt(prog.size());
                for (Map.Entry<UUID, SnapshotProgress> e : prog.entrySet()) {
                    writer.writeUuid(e.getKey());
                    writer.writeLong(e.getValue().getProcessed());
                    writer.writeLong(e.getValue().getTotal());
                }
            } else {
                writer.writeInt(-1);
            }
            return;
        }
        super.processOutStream(type, writer);
    }

    private static Set<String> readStringSet(BinaryRawReader reader) {
        int cnt = reader.readInt();
        if (cnt < 0) {
            return null;
        }
        HashSet<String> res = new HashSet<String>(cnt);
        for (int i = 0; i < cnt; ++i) {
            res.add(reader.readString());
        }
        return res;
    }

    private static Collection<File> readFileCollection(BinaryRawReader reader) {
        int cnt = reader.readInt();
        if (cnt < 0) {
            return null;
        }
        ArrayList<File> res = new ArrayList<File>(cnt);
        for (int i = 0; i < cnt; ++i) {
            res.add(new File(reader.readString()));
        }
        return res;
    }

    private PlatformAsyncResult getInitAsyncResult(final SnapshotFuture fut) {
        assert (curFut.get() == null);
        curFut.set(fut);
        return new PlatformAsyncResult(){

            public IgniteFuture future() {
                return fut.initFuture();
            }

            public void write(BinaryRawWriterEx writer, Object result) {
                InteropSnapshot.writeIgniteUuid((BinaryRawWriter)writer, fut.operationId());
                InteropSnapshot.writeSnapshotOperation((BinaryRawWriter)writer, fut.snapshotOperation());
            }
        };
    }

    private PlatformAsyncResult getObjectAsyncResult(final IgniteFuture fut) {
        return new PlatformAsyncResult(){

            public IgniteFuture future() {
                return fut;
            }

            public void write(BinaryRawWriterEx writer, Object result) {
                writer.writeObject(result);
            }
        };
    }

    private static void writeSnapshotInfo(BinaryRawWriter w, SnapshotInfo si) {
        w.writeLong(si.snapshotId());
        w.writeBoolean(si.fullSnapshot());
        w.writeUuid(si.initiatorNode());
        InteropSnapshot.writeStrings(w, si.cacheNames());
        w.writeString(si.message());
    }

    private static void writeSnapshotOperation(BinaryRawWriter w, SnapshotOperationInfo op) {
        InteropSnapshot.writeIgniteUuid(w, op.operationId());
        w.writeLong(op.snapshotId());
        w.writeInt(op.operationType().ordinal());
        w.writeString(op.message());
        InteropSnapshot.writeStrings(w, op.cacheNames());
        w.writeUuid(op.initiatorNodeId());
        Collection<ClusterNode> nodes = op.clusterNodes();
        if (nodes != null) {
            w.writeInt(nodes.size());
            for (ClusterNode n : nodes) {
                w.writeUuid(n.id());
            }
        } else {
            w.writeInt(-1);
        }
        Map<Object, Map<String, String>> attrs = op.snapshotAttributes();
        if (attrs != null) {
            w.writeInt(attrs.size());
            for (Map.Entry<Object, Map<String, String>> e : attrs.entrySet()) {
                w.writeObject(e.getKey());
                Map<String, String> val = e.getValue();
                if (val != null) {
                    w.writeInt(val.size());
                    for (Map.Entry<String, String> en : val.entrySet()) {
                        w.writeString(en.getKey());
                        w.writeString(en.getValue());
                    }
                    continue;
                }
                w.writeInt(-1);
            }
        } else {
            w.writeInt(-1);
        }
    }

    private static void writeIgniteUuid(BinaryRawWriter w, IgniteUuid id) {
        if (id != null) {
            w.writeBoolean(true);
            w.writeUuid(id.globalId());
            w.writeLong(id.localId());
        } else {
            w.writeBoolean(false);
        }
    }

    private static void writeStrings(BinaryRawWriter w, Collection<String> strings) {
        if (strings != null) {
            w.writeInt(strings.size());
            for (String s : strings) {
                w.writeString(s);
            }
        } else {
            w.writeInt(-1);
        }
    }
}

