/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.cache.dr.ClientCacheDrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainClientCacheConfiguration;
import org.gridgain.grid.dr.DrSenderLoadBalancingMode;

public class GridGainClientCacheConfigurationSerializer {
    private static final int DR_BATCH_SEND_FREQ = 1;
    private static final int DR_LOAD_BALANCING_MODE = 2;
    private static final int DR_MAX_BATCHES = 3;
    private static final int DR_PREFER_LOC_SND = 4;
    private static final int DR_MAX_BACKUP_QUEUE_SIZE = 5;
    private static final int DR_SENDER_GROUP = 6;

    public static void write(BinaryRawWriterEx writer, GridGainClientCacheConfiguration cfg) {
        int countPos = writer.reserveInt();
        int count = 0;
        ClientCacheDrSenderConfiguration senderCfg = cfg.getDrSenderConfiguration();
        if (senderCfg != null) {
            writer.writeInt(1);
            writer.writeLong(senderCfg.getBatchSendFrequency());
            ++count;
            writer.writeInt(2);
            writer.writeInt(senderCfg.getLoadBalancingMode().ordinal());
            ++count;
            writer.writeInt(3);
            writer.writeInt(senderCfg.getMaxBatches());
            ++count;
            writer.writeInt(4);
            writer.writeBoolean(senderCfg.isPreferLocalSender());
            ++count;
            writer.writeInt(5);
            writer.writeInt(senderCfg.getMaxBackupQueueSize());
            ++count;
            if (senderCfg.getSenderGroup() != null) {
                writer.writeInt(6);
                writer.writeString(senderCfg.getSenderGroup());
                ++count;
            }
        }
        writer.writeInt(countPos, count);
    }

    public static GridGainCacheConfiguration read(BinaryRawReader reader) {
        int count = reader.readInt();
        if (count == 0) {
            return new GridGainCacheConfiguration();
        }
        CacheDrSenderConfiguration senderCfg = new CacheDrSenderConfiguration();
        block8: for (int i = 0; i < count; ++i) {
            int code = reader.readInt();
            switch (code) {
                case 1: {
                    senderCfg.setBatchSendFrequency(reader.readLong());
                    continue block8;
                }
                case 2: {
                    senderCfg.setLoadBalancingMode(DrSenderLoadBalancingMode.fromOrdinal(reader.readInt()));
                    continue block8;
                }
                case 3: {
                    senderCfg.setMaxBatches(reader.readInt());
                    continue block8;
                }
                case 4: {
                    senderCfg.setPreferLocalSender(reader.readBoolean());
                    continue block8;
                }
                case 5: {
                    senderCfg.setMaxBackupQueueSize(reader.readInt());
                    continue block8;
                }
                case 6: {
                    senderCfg.setSenderGroup(reader.readString());
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid GridGainCacheConfiguration code from client: " + code);
                }
            }
        }
        return new GridGainCacheConfiguration().setDrSenderConfiguration(senderCfg);
    }
}

