/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.configuration;

import java.util.EnumSet;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.configuration.SftpConfiguration;
import org.gridgain.grid.configuration.SnapshotsCatalogConnectorConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;

public class SnapshotConfiguration {
    public static final String DFLT_SNAPSHOTS_PATH = "snapshot";
    public static final long DEFAULT_SNAPSHOT_PROGRESS_THROTTLING_TIME = 1000L;
    public static final CompressionOption DEFAULT_COMPRESSION = CompressionOption.NONE;
    public static final int DEFAULT_SNAPSHOT_OPERATION_PARALLELISM = 2;
    public static final int DEFAULT_RESTORE_OPERATION_PARALLELISM = 4;
    public static final int DEFAULT_COMPRESSION_LEVEL_PARAMETER = -1;
    public static final int DEFAULT_COMPRESSION_LEVEL = 1;
    public static final boolean DEFAULT_EXCHANGELESS_SNAPSHOT = true;
    private static final EnumSet<CompressionOption> DEFAULT_AVAILABLE_COMPRESSION_CODECS = EnumSet.of(CompressionOption.NONE, CompressionOption.ZIP);
    private String snapshotsPath = "snapshot";
    public static final boolean DFLT_PITR_ENABLED = false;
    private SnapshotsCatalogConnectorConfiguration catalogCfg;
    private long snapshotProgressThrottlingInterval = 1000L;
    @Deprecated
    private boolean pointInTimeRecoveryEnabled = false;
    private CompressionOption compressionOption = DEFAULT_COMPRESSION;
    private int snapshotOperationParallelism = 2;
    private int restoreOperationParallelism = 4;
    private int compressionLevel = -1;
    private MessageDigestFactory msgDigestFactory;
    private SnapshotRegistryTransformer snapshotRegistryTransformer;
    private SftpConfiguration sftpConfiguration;
    private EnumSet<CompressionOption> supportedCompressionCodecs = DEFAULT_AVAILABLE_COMPRESSION_CODECS;

    public SnapshotConfiguration() {
    }

    public SnapshotConfiguration(SnapshotConfiguration other) {
        assert (other != null);
        this.snapshotsPath = other.snapshotsPath;
        this.catalogCfg = other.catalogCfg;
        this.snapshotProgressThrottlingInterval = other.snapshotProgressThrottlingInterval;
        this.pointInTimeRecoveryEnabled = other.pointInTimeRecoveryEnabled;
        this.compressionOption = other.compressionOption;
        this.snapshotOperationParallelism = other.snapshotOperationParallelism;
        this.restoreOperationParallelism = other.restoreOperationParallelism;
        this.compressionLevel = other.compressionLevel;
        this.msgDigestFactory = other.msgDigestFactory;
        this.snapshotRegistryTransformer = other.snapshotRegistryTransformer;
        this.sftpConfiguration = other.sftpConfiguration;
    }

    public String getSnapshotsPath() {
        return this.snapshotsPath;
    }

    public SnapshotConfiguration setSnapshotsPath(String snapshotsPath) {
        this.snapshotsPath = snapshotsPath;
        return this;
    }

    @Deprecated
    public SnapshotsCatalogConnectorConfiguration getSnapshotsCatalogConnectorConfiguration() {
        return this.catalogCfg;
    }

    @Deprecated
    public SnapshotConfiguration setSnapshotsCatalogConnectorConfiguration(SnapshotsCatalogConnectorConfiguration catalogCfg) {
        this.catalogCfg = catalogCfg;
        return this;
    }

    public long getSnapshotProgressThrottlingInterval() {
        return this.snapshotProgressThrottlingInterval;
    }

    public SnapshotConfiguration setSnapshotProgressThrottlingInterval(long snapshotProgressThrottlingInterval) {
        this.snapshotProgressThrottlingInterval = snapshotProgressThrottlingInterval;
        return this;
    }

    @Deprecated
    public boolean isPointInTimeRecoveryEnabled() {
        return this.pointInTimeRecoveryEnabled;
    }

    @Deprecated
    public SnapshotConfiguration setPointInTimeRecoveryEnabled(boolean pointInTimeRecoveryEnabled) {
        this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
        return this;
    }

    public CompressionOption getCompressionOption() {
        return this.compressionOption;
    }

    public SnapshotConfiguration setCompressionOption(CompressionOption compressionOption) {
        this.compressionOption = compressionOption;
        return this;
    }

    public int getSnapshotOperationParallelism() {
        return this.snapshotOperationParallelism;
    }

    public SnapshotConfiguration setSnapshotOperationParallelism(int snapshotOperationParallelism) {
        this.snapshotOperationParallelism = snapshotOperationParallelism;
        return this;
    }

    public int getRestoreOperationParallelism() {
        return this.restoreOperationParallelism;
    }

    public SnapshotConfiguration setRestoreOperationParallelism(int restoreOperationParallelism) {
        this.restoreOperationParallelism = restoreOperationParallelism;
        return this;
    }

    public int getCompressionLevel() {
        if (this.compressionLevel == -1 && this.compressionOption == CompressionOption.ZIP) {
            return 1;
        }
        return this.compressionLevel;
    }

    public SnapshotConfiguration setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public SnapshotConfiguration setMessageDigestFactory(MessageDigestFactory msgDigestFactory) {
        this.msgDigestFactory = msgDigestFactory;
        return this;
    }

    public MessageDigestFactory getMessageDigestFactory() {
        return this.msgDigestFactory;
    }

    public SnapshotConfiguration setRegistryTransformer(SnapshotRegistryTransformer snapshotRegistryTransformer) {
        this.snapshotRegistryTransformer = snapshotRegistryTransformer;
        return this;
    }

    public SnapshotRegistryTransformer getRegistryTransformer() {
        return this.snapshotRegistryTransformer;
    }

    public SnapshotConfiguration setSftpConfiguration(SftpConfiguration sftpConfiguration) {
        this.sftpConfiguration = sftpConfiguration;
        return this;
    }

    public SftpConfiguration getSftpConfiguration() {
        return this.sftpConfiguration;
    }

    public void setSupportedCompressionCodecs(EnumSet<CompressionOption> supportedCompressionCodecs) {
        this.supportedCompressionCodecs = supportedCompressionCodecs;
    }

    public boolean isCompressionCodecSupported(CompressionOption compressionCodec) {
        return compressionCodec == CompressionOption.NONE || this.supportedCompressionCodecs.contains((Object)compressionCodec);
    }

    public String toString() {
        return S.toString(SnapshotConfiguration.class, (Object)this);
    }

    static {
        if ((U.isWindows() || U.isLinux()) && (U.isX86() || U.isAmd64())) {
            DEFAULT_AVAILABLE_COMPRESSION_CODECS.add(CompressionOption.ZSTD);
            DEFAULT_AVAILABLE_COMPRESSION_CODECS.add(CompressionOption.LZ4);
            DEFAULT_AVAILABLE_COMPRESSION_CODECS.add(CompressionOption.SNAPPY);
        }
    }
}

