/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.dr;

import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.dr.DrSenderLoadBalancingMode;

public class ClientCacheDrSenderConfiguration {
    private long batchSndFreq = 2000L;
    private DrSenderLoadBalancingMode loadBalancingMode = CacheDrSenderConfiguration.DFLT_SND_HUB_LOAD_BALANCING_MODE;
    private int maxBatches = 32;
    private boolean preferLocSnd = true;
    private int maxBackupQueueSize;
    private String senderGroup;

    public ClientCacheDrSenderConfiguration() {
    }

    public ClientCacheDrSenderConfiguration(ClientCacheDrSenderConfiguration cfg) {
        A.notNull((Object)cfg, (String)"cfg");
        this.batchSndFreq = cfg.getBatchSendFrequency();
        this.maxBatches = cfg.getMaxBatches();
        this.loadBalancingMode = cfg.getLoadBalancingMode();
        this.preferLocSnd = cfg.isPreferLocalSender();
        this.senderGroup = cfg.getSenderGroup();
        this.maxBackupQueueSize = cfg.getMaxBackupQueueSize();
    }

    public long getBatchSendFrequency() {
        return this.batchSndFreq;
    }

    public ClientCacheDrSenderConfiguration setBatchSendFrequency(long batchSndFreq) {
        this.batchSndFreq = batchSndFreq;
        return this;
    }

    public int getMaxBatches() {
        return this.maxBatches;
    }

    public ClientCacheDrSenderConfiguration setMaxBatches(int maxBatches) {
        this.maxBatches = maxBatches;
        return this;
    }

    public DrSenderLoadBalancingMode getLoadBalancingMode() {
        return this.loadBalancingMode;
    }

    public ClientCacheDrSenderConfiguration setLoadBalancingMode(DrSenderLoadBalancingMode loadBalancingMode) {
        this.loadBalancingMode = loadBalancingMode;
        return this;
    }

    public boolean isPreferLocalSender() {
        return this.preferLocSnd;
    }

    public ClientCacheDrSenderConfiguration setPreferLocalSender(boolean preferLocSnd) {
        this.preferLocSnd = preferLocSnd;
        return this;
    }

    public int getMaxBackupQueueSize() {
        return this.maxBackupQueueSize;
    }

    public ClientCacheDrSenderConfiguration setMaxBackupQueueSize(int maxBackupSize) {
        this.maxBackupQueueSize = maxBackupSize;
        return this;
    }

    public String getSenderGroup() {
        return this.senderGroup;
    }

    public ClientCacheDrSenderConfiguration setSenderGroup(String senderGroup) {
        this.senderGroup = senderGroup;
        return this;
    }

    public String toString() {
        return S.toString(ClientCacheDrSenderConfiguration.class, (Object)this);
    }
}

