/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.segmentation.sharedfs;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.segmentation.SegmentationResolver;
import org.apache.ignite.spi.IgniteSpiException;

public class SharedFsSegmentationResolver
implements SegmentationResolver {
    private static final long serialVersionUID = 2261115758861687494L;
    private String path;
    private File folder;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public boolean isValidSegment() throws IgniteCheckedException {
        this.init();
        return this.folder.canRead() && this.folder.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IgniteCheckedException {
        if (this.initGuard.compareAndSet(false, true)) {
            try {
                File tmp;
                if (this.path == null) {
                    throw new IgniteSpiException("Shared file system path is null (it should be configured via setPath(..) configuration property).");
                }
                URL folderUrl = U.resolveIgniteUrl((String)this.path);
                if (folderUrl == null) {
                    throw new IgniteCheckedException("Failed to resolve path: " + this.path);
                }
                try {
                    tmp = new File(folderUrl.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IgniteCheckedException("Failed to resolve path: " + this.path, (Throwable)e);
                }
                this.folder = tmp;
            }
            finally {
                this.initLatch.countDown();
            }
        }
        U.await((CountDownLatch)this.initLatch);
        if (this.folder == null) {
            throw new IgniteCheckedException("Segmentation resolver was not properly initialized.");
        }
    }

    public SharedFsSegmentationResolver setPath(String path) {
        this.path = path;
        return this;
    }

    public String toString() {
        return S.toString(SharedFsSegmentationResolver.class, (Object)this);
    }
}

