/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.util.dr;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.TombstoneCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepairPartitionCounters
implements IgniteRunnable {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    IgniteEx ignite;
    @LoggerResource
    IgniteLogger log;
    private String groupName;
    private int part;
    private Metrics metrics;
    private boolean keepBinary;

    public static List<IgniteFuture> runTask(Ignite ignite, String ... cacheNames) {
        List contexts;
        HashSet groups = new HashSet();
        if (cacheNames.length == 0) {
            Set allCacheNames = ((IgniteEx)ignite).context().cache().cacheDescriptors().keySet();
            allCacheNames.stream().forEach(arg_0 -> ((Ignite)ignite).cache(arg_0));
            contexts = allCacheNames.stream().map(name -> ((IgniteEx)ignite).context().cache().cache(name).context()).filter(cctx -> groups.add(cctx.groupId())).collect(Collectors.toList());
        } else {
            Arrays.stream(cacheNames).forEach(arg_0 -> ((Ignite)ignite).cache(arg_0));
            contexts = Arrays.stream(cacheNames).map(name -> ((IgniteEx)ignite).context().cache().cache(name).context()).filter(cctx -> groups.add(cctx.groupId())).collect(Collectors.toList());
        }
        ArrayList<IgniteFuture> futs = new ArrayList<IgniteFuture>();
        for (GridCacheContext cctx2 : contexts) {
            int parts = cctx2.affinity().partitions();
            for (int p = 0; p < parts; ++p) {
                futs.add(ignite.compute().affinityRunAsync(cctx2.name(), (Object)p, (IgniteRunnable)new RepairPartitionCounters(cctx2.group().cacheOrGroupName(), p)));
            }
        }
        return futs;
    }

    public RepairPartitionCounters(String groupName, int part) {
        this(groupName, part, true);
    }

    public RepairPartitionCounters(String groupName, int part, boolean keepBinary) {
        this.groupName = groupName;
        this.part = part;
        this.keepBinary = keepBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long startTime;
        this.ignite.cache(this.groupName);
        this.log = this.ignite.log();
        CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(CU.cacheId((String)this.groupName));
        GridDhtLocalPartition locPart = this.reservePartition(grpCtx);
        long updTime = startTime = System.currentTimeMillis();
        this.metrics = new Metrics(this.part, locPart.fullSize());
        try {
            try {
                HashSet<Long> counters = new HashSet<Long>();
                ArrayList<GridCacheEntryInfo> batch = new ArrayList<GridCacheEntryInfo>(100);
                GridIterator iter = grpCtx.offheap().partitionIterator(this.part, 3);
                while (iter.hasNext()) {
                    this.fillBatch(grpCtx.shared(), (GridIterator<CacheDataRow>)iter, batch, counters);
                    this.repairEntries(grpCtx, batch);
                    if (System.currentTimeMillis() - 30000L > updTime) {
                        updTime = System.currentTimeMillis();
                        this.log.info("Partition repair in progress: " + this.getDetails());
                    }
                    batch.clear();
                }
            }
            finally {
                locPart.release();
                this.metrics.duration = System.currentTimeMillis() - startTime;
            }
            this.log.info("Partition repair finished: " + this.getDetails());
        }
        catch (IgniteCheckedException e) {
            this.log.error("Partition repair failed: " + this.getDetails(), (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    private String getDetails() {
        return "cacheGroup=" + this.groupName + ", details=" + this.metrics.toString();
    }

    private GridDhtLocalPartition reservePartition(@Nullable CacheGroupContext grpCtx) {
        if (grpCtx == null) {
            throw new IllegalArgumentException("Cache group not found: " + this.groupName);
        }
        GridDhtLocalPartition locPart = grpCtx.topology().localPartition(this.part);
        if (locPart == null || !locPart.reserve()) {
            throw new IllegalArgumentException("failed to reserve partition for group: groupName=" + this.groupName + ", part=" + this.part);
        }
        if (locPart.state() != GridDhtPartitionState.OWNING || grpCtx.topology().stopping()) {
            locPart.release();
            throw new IllegalArgumentException("failed to reserve non-owned partition for group: groupName=" + this.groupName + ", part=" + this.part);
        }
        return locPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBatch(GridCacheSharedContext ctx, GridIterator<CacheDataRow> iter, ArrayList<GridCacheEntryInfo> batch, Set<Long> counters) {
        while (iter.hasNext() && batch.size() < 100) {
            ctx.database().checkpointReadLock();
            try {
                int cnt = 100;
                while (iter.hasNext() && cnt-- > 0) {
                    CacheDataRow row = (CacheDataRow)iter.next();
                    this.metrics.entriesProcessed++;
                    if (counters.add(row.version().updateCounter())) continue;
                    this.metrics.brokenEntriesFound++;
                    batch.add(this.extractEntryInfo(row));
                }
            }
            finally {
                ctx.database().checkpointReadUnlock();
            }
        }
    }

    private GridCacheEntryInfo extractEntryInfo(CacheDataRow row) {
        GridCacheEntryInfo info = new GridCacheEntryInfo();
        info.key(row.key());
        info.cacheId(row.cacheId());
        info.setDeleted(row.value() == TombstoneCacheObject.INSTANCE);
        info.value(row.value());
        info.version(row.version());
        info.expireTime(row.expireTime());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repairEntries(CacheGroupContext grp, List<GridCacheEntryInfo> infos) throws IgniteCheckedException {
        if (infos.isEmpty()) {
            return;
        }
        grp.shared().database().checkpointReadLock();
        try {
            GridCacheAdapter cache = grp.sharedGroup() ? null : grp.shared().cache().context().cacheContext(grp.groupId()).cache();
            for (GridCacheEntryInfo info : infos) {
                GridDhtCacheEntry entry;
                if (cache == null || grp.sharedGroup() && cache.context().cacheId() != info.cacheId()) {
                    GridCacheContext cctx = grp.shared().cacheContext(info.cacheId());
                    if (cctx == null) {
                        this.log.warning("Failed to fix entry (cache has gone?): cacheId=" + info.cacheId() + ", part=" + this.part + ", key=" + info.key());
                        continue;
                    }
                    cache = cctx.cache();
                }
                if ((entry = (GridDhtCacheEntry)cache.entryEx(info.key())) == null) {
                    this.log.warning("Failed to fix entry (concurrently removed?): cacheName=" + cache.name() + ", part=" + this.part + ", key=" + info.key());
                    continue;
                }
                if (info.isDeleted()) {
                    if (entry.clearInternal(info.version())) {
                        this.metrics.tombstoneCleared++;
                        continue;
                    }
                    this.log.warning("Failed to cleanup tombstone (concurrently removed?): cacheName=" + cache.name() + ", part=" + this.part + ", key=" + info.key());
                    continue;
                }
                KeyCacheObject key = entry.key();
                Object val = this.keepBinaryIfNeeded((GridCacheAdapter<Object, Object>)cache).get((Object)key);
                if (val == null) {
                    this.log.warning("Failed to fix entry (concurrently removed?): cacheName=" + cache.name() + ", part=" + this.part + ", key=" + info.key());
                    continue;
                }
                this.keepBinaryIfNeeded((GridCacheAdapter<Object, Object>)cache).replace((Object)key, val, val);
                this.metrics.entriesFixed++;
            }
        }
        finally {
            grp.shared().database().checkpointReadUnlock();
        }
    }

    @NotNull
    private IgniteInternalCache<Object, Object> keepBinaryIfNeeded(GridCacheAdapter<Object, Object> cache) {
        return this.keepBinary ? cache.keepBinary() : cache;
    }

    private static class Metrics
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final int part;
        private final long size;
        private long entriesProcessed;
        private long brokenEntriesFound;
        private long entriesFixed;
        private long tombstoneCleared;
        private long duration;

        public Metrics(int part, long size) {
            this.part = part;
            this.size = size;
        }

        public String toString() {
            return "[partition=" + this.part + "partitionSize=" + this.size + ", entriesProcessed=" + this.entriesProcessed + ", brokenEntriesFound=" + this.brokenEntriesFound + ", entriesFixed=" + this.entriesFixed + ", tombstoneCleared=" + this.tombstoneCleared + ", duration=" + Duration.ofMillis(this.duration) + ']';
        }
    }
}

