/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;

@GridInternal
public class RemoteAuthTask
extends ComputeTaskAdapter<AuthenticationContext, SecurityContext> {
    private static final long serialVersionUID = 0L;

    public Map<RemoteAuthJob, ClusterNode> map(List<ClusterNode> subgrid, AuthenticationContext arg) throws IgniteException {
        return Collections.singletonMap(new RemoteAuthJob(arg), subgrid.get(ThreadLocalRandom.current().nextInt(subgrid.size())));
    }

    public SecurityContext reduce(List<ComputeJobResult> results) throws IgniteException {
        return (SecurityContext)results.get(0).getData();
    }

    private static class RemoteAuthJob
    implements ComputeJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private transient IgniteEx ignite;
        @LoggerResource
        private transient IgniteLogger log;
        private final AuthenticationContext authCtx;

        private RemoteAuthJob(AuthenticationContext authCtx) {
            this.authCtx = authCtx;
        }

        public void cancel() {
        }

        public Object execute() throws IgniteException {
            assert (this.ignite.context().security().enabled()) : "Security is disabled.";
            try {
                return this.ignite.context().security().authenticate(this.authCtx);
            }
            catch (IgniteCheckedException e) {
                this.log.error("Authentication failed.", (Throwable)e);
                return null;
            }
        }
    }
}

