/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.license;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.gridgain.grid.internal.processors.license.LicenseField;

public class LicenseViolationInfoHolder
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Collection<String> errMsgs = new LinkedList<String>();
    private final Collection<String> shortMsgs = new LinkedList<String>();
    private final Collection<LicenseField> violatedFields = new LinkedList<LicenseField>();

    public LicenseViolationInfoHolder addErrMsg(String errMsg) {
        this.errMsgs.add(errMsg);
        return this;
    }

    public LicenseViolationInfoHolder addShortMsg(String shortMsg) {
        this.shortMsgs.add(shortMsg);
        return this;
    }

    public LicenseViolationInfoHolder addViolatedField(LicenseField field) {
        this.violatedFields.add(field);
        return this;
    }

    public String formatViolationMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("License violation detected:\n");
        int cnt = 0;
        for (String msg : this.errMsgs) {
            sb.append("  ^-- ").append(msg);
            if (++cnt >= this.errMsgs.size()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String formatShortViolationMessage() {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (String msg : this.shortMsgs) {
            sb.append(msg);
            if (++cnt >= this.shortMsgs.size()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public Collection<String> getErrMsgs() {
        return this.errMsgs;
    }

    public Collection<String> getShortMsgs() {
        return this.shortMsgs;
    }

    public Collection<LicenseField> getViolatedFields() {
        return this.violatedFields;
    }
}

