/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.store;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.dr.store.DrAbstractSenderStore;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.DrSenderStoreCorruptedException;
import org.gridgain.grid.dr.store.DrSenderStoreCursor;
import org.gridgain.grid.dr.store.DrSenderStoreEntry;
import org.gridgain.grid.dr.store.DrSenderStoreOverflowException;
import org.gridgain.grid.dr.store.fs.DrSenderFsStore;
import org.gridgain.grid.events.DrStoreEvent;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.store.DrFullStateTransferBuffer;
import org.gridgain.grid.internal.processors.dr.store.DrMetadataAwareStore;
import org.gridgain.grid.internal.processors.dr.store.StoreListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DrStoreManager {
    protected final GridKernalContext ctx;
    protected final IgniteLogger log;
    protected final DrProcessor proc;
    protected DrFullStateTransferBuffer fstBuffer;
    protected final StoreListener[] storeListeners = new StoreListener[32];

    DrStoreManager(GridKernalContext ctx, DrProcessor proc, long fstBufferSize) {
        this.ctx = ctx;
        this.proc = proc;
        this.fstBuffer = new DrFullStateTransferBuffer(fstBufferSize);
        this.log = proc.context().log(this.getClass());
    }

    public void start() throws IgniteCheckedException {
        this.ctx.resource().injectGeneric((Object)this.fstBuffer);
        U.startLifecycleAware(Collections.singleton(this.fstBuffer));
    }

    public abstract void onKernalStart() throws IgniteCheckedException;

    public void onKernalStop() {
        Arrays.fill(this.storeListeners, null);
    }

    public void stop() {
        U.stopLifecycleAware((IgniteLogger)this.log, Collections.singleton(this.fstBuffer));
    }

    public abstract boolean isGlobalStore();

    public void clearFullStateTransferBuffer() {
        this.fstBuffer.clear();
    }

    public abstract void clearGlobalStore() throws IgniteCheckedException;

    public abstract DrMetadataAwareStore getStore(byte var1);

    public final DrSenderStoreCursor createCursor(byte dataCenterID) throws IgniteCheckedException {
        DrSenderStoreCursor storeCursor = this.getStore(dataCenterID).createCursor(dataCenterID);
        DrSenderStoreCursor fstBufferCursor = this.fstBuffer.cursor(dataCenterID);
        return new CursorWrapper(storeCursor, fstBufferCursor);
    }

    public long storeSizeBytes(byte dcID) {
        return this.getStore(dcID).getStore().sizeBytes();
    }

    public long fstBufferSizeBytes() {
        return this.fstBuffer.sizeBytes();
    }

    public long fstBufferMaxSizeBytes() {
        return this.fstBuffer.maxSizeBytes();
    }

    public abstract void storeRegularBatch(byte[] var1, byte[] var2, int var3) throws IgniteCheckedException;

    public final void storeFSTBatch(byte[] dataCenterIds, byte[] data, int cnt, @NotNull IgniteUuid fstId, GridFutureAdapter<Void> reqFut) throws IgniteCheckedException {
        if (!this.fstBuffer.store(dataCenterIds, data, cnt, fstId, reqFut)) {
            throw new DrSenderStoreOverflowException("Full state transfer is overflowed.");
        }
        for (byte id : dataCenterIds) {
            if (this.storeListeners[id] == null) continue;
            this.storeListeners[id].onBatchAdded();
        }
    }

    protected void initStoreDefaults(DrSenderStore store, @Nullable Byte dstDcId) {
        if (store instanceof DrAbstractSenderStore) {
            DrSenderFsStore fsStore;
            ((DrAbstractSenderStore)store).setOverflowCallback((IgniteRunnable & Serializable)() -> this.recordStoreOverflowEvt(dstDcId));
            if (store instanceof DrSenderFsStore && (fsStore = (DrSenderFsStore)store).getDirectoryPath() == null) {
                String storeName = dstDcId == null ? "global" : "dc_" + dstDcId;
                String dfltStoreDir = Paths.get(this.ctx.config().getWorkDirectory(), "dr_fs_store", storeName).toString();
                fsStore.setDirectoryPath(dfltStoreDir);
                this.log.warning("DrSenderFsStore directory was not configured for " + storeName + " store. Default directory will be used: " + dfltStoreDir);
            }
        }
    }

    private void recordStoreOverflowEvt(Byte dataCenterId) {
        ClusterNode node = this.ctx.discovery().localNode();
        if (this.ctx.event().isUserRecordable(1028)) {
            this.ctx.event().record((Event)new DrStoreEvent(node, "Store overflowed.", 1028, dataCenterId));
        }
    }

    public void subscribeToDcUpdates(byte dcID, StoreListener listener) {
        assert (this.storeListeners[dcID] == null);
        this.storeListeners[dcID] = listener;
    }

    public void unsubscribeFromDcUpdates(byte dcID, StoreListener listener) {
        A.ensure((this.storeListeners[dcID] == null || this.storeListeners[dcID] == listener ? 1 : 0) != 0, (String)"Listener is not subscribed to DR Store updates.");
        this.storeListeners[dcID] = null;
    }

    private static class CursorWrapper
    implements DrSenderStoreCursor {
        private final DrSenderStoreCursor storeCursor;
        private final DrSenderStoreCursor fstBufferCursor;

        CursorWrapper(DrSenderStoreCursor storeCursor, DrSenderStoreCursor fstBufferCursor) {
            this.storeCursor = storeCursor;
            this.fstBufferCursor = fstBufferCursor;
        }

        @Override
        public DrSenderStoreEntry next() throws IgniteCheckedException, DrSenderStoreCorruptedException {
            DrSenderStoreEntry next = this.storeCursor.next();
            if (next == null) {
                return this.fstBufferCursor.next();
            }
            return next;
        }

        @Override
        public void close() {
            U.closeQuiet((AutoCloseable)this.storeCursor);
            U.closeQuiet((AutoCloseable)this.fstBufferCursor);
        }
    }
}

