/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.messages;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMessage;
import org.jetbrains.annotations.Nullable;

public class DrExternalBatchRequest
extends DrExternalMessage {
    private IgniteUuid reqId;
    private String cacheName;
    private byte dataCenterId;
    private int entryCnt;
    private Collection<GridCacheRawVersionedEntry> data;
    private byte[] dataBytes;
    private int dataSize;

    public DrExternalBatchRequest(IgniteUuid reqId, String cacheName, byte dataCenterId, int entryCnt, byte[] dataBytes, int dataSize) {
        assert (reqId != null);
        assert (entryCnt > 0);
        assert (dataBytes != null && dataBytes.length > 0);
        this.reqId = reqId;
        this.cacheName = cacheName;
        this.dataCenterId = dataCenterId;
        this.entryCnt = entryCnt;
        this.dataBytes = dataBytes;
        this.dataSize = dataSize;
    }

    public IgniteUuid requestId() {
        return this.reqId;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public byte dataCenterId() {
        return this.dataCenterId;
    }

    public int entryCount() {
        return this.entryCnt;
    }

    @Nullable
    public byte[] dataBytes() {
        return this.dataBytes;
    }

    public int dataSize() {
        return this.dataSize;
    }

    public Collection<GridCacheRawVersionedEntry> data() throws IgniteCheckedException {
        if (this.data == null) {
            assert (this.dataBytes != null);
            this.data = new ArrayList<GridCacheRawVersionedEntry>(this.entryCnt);
            try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.dataBytes, 0, this.dataSize));){
                for (int i = 0; i < this.entryCnt; ++i) {
                    this.data.add(DrUtils.readDrEntry(in, this.dataCenterId));
                }
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to unmarshal external data center replication batch request.", (Throwable)e);
            }
            finally {
                this.dataBytes = null;
            }
        }
        return this.data;
    }

    public String toString() {
        return S.toString(DrExternalBatchRequest.class, (Object)this, (String)"size", (Object)(this.dataBytes != null ? Integer.valueOf(this.dataBytes.length) : "N/A"));
    }
}

