/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.dr.GridCacheReplicationManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.io.GridUnsafeDataInput;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;
import org.apache.ignite.internal.util.lang.GridTuple4;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrManager;
import org.gridgain.grid.internal.processors.cache.dr.ist.DrStateIO;
import org.gridgain.grid.internal.processors.cache.dr.ist.messages.DrStateRecord;
import org.gridgain.grid.internal.processors.dr.DrSenderMetadataHolder;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalBatchRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalBatchResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalHandshakeRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalHandshakeResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMetadataRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalMetadataResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalPingRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrExternalPingResponse;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrUtils {
    public static final IgniteUuid FAKE_FST_ID = IgniteUuid.fromString((String)"FFFF-FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFF");
    public static final byte RESCHEDULE = 1;
    public static final byte CONFIRMED = 2;
    public static final String DFLT_SENDER_GROUP_NAME = "<default>";
    public static final String[] DFLT_SENDER_GROUPS = new String[]{"<default>"};
    public static final String DFLT_GLOBAL_STORE_NAME = "global";
    public static final ByteOrder DR_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final boolean DR_SND_DIRECT_BUF = true;
    public static final int MAX_DATA_CENTERS = 32;
    public static final byte TYP_HND_REQ = 0;
    public static final byte TYP_HND_RESP = 1;
    public static final byte TYP_PING_REQ = 2;
    public static final byte TYP_PING_RESP = 3;
    public static final byte TYP_BATCH_REQ = 4;
    public static final byte TYP_BATCH_RESP = 5;
    public static final byte TYP_META_REQ = 6;
    public static final byte TYP_META_RESP = 7;
    public static final DrExternalPingRequest PING_REQ = new DrExternalPingRequest();
    public static final DrExternalPingResponse PING_RESP = new DrExternalPingResponse();
    public static final byte[] PING_REQ_BYTES;
    public static final byte[] PING_RESP_BYTES;
    private static final DrStateIO DR_STATE_IO;

    public static GridCacheRawVersionedEntry readDrEntry(DataInput in, byte dataCenterId) throws IOException {
        long expireTime;
        long ttl;
        byte[] keyBytes = U.readByteArray((DataInput)in);
        byte[] valBytes = U.readByteArray((DataInput)in);
        if (in.readBoolean()) {
            ttl = in.readLong();
            expireTime = in.readLong();
        } else {
            ttl = 0L;
            expireTime = 0L;
        }
        GridCacheVersion ver = new GridCacheVersion(in.readInt(), in.readLong(), in.readInt(), (int)dataCenterId);
        return new GridCacheRawVersionedEntry(keyBytes, valBytes, ttl, expireTime, ver);
    }

    public static void writeDrEntry(DataOutput out, GridCacheRawVersionedEntry entry) throws IOException {
        assert (entry.keyBytes() != null);
        U.writeByteArray((DataOutput)out, (byte[])entry.keyBytes());
        U.writeByteArray((DataOutput)out, (byte[])entry.valueBytes());
        if (entry.ttl() > 0L) {
            out.writeBoolean(true);
            out.writeLong(entry.ttl());
            out.writeLong(entry.expireTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(entry.version().topologyVersion());
        out.writeLong(entry.version().order());
        out.writeInt(entry.version().nodeOrder());
    }

    public static <K, V> int drEntrySize(GridCacheRawVersionedEntry<K, V> entry) {
        assert (entry.keyBytes() != null);
        int size = 17;
        size += 4 + entry.keyBytes().length;
        size += 4 + (entry.valueBytes() == null ? 0 : entry.valueBytes().length);
        if (entry.ttl() > 0L) {
            size += 16;
        }
        return size;
    }

    public static byte[] marshal(DrExternalHandshakeResponse resp) throws IgniteCheckedException {
        int size = 2;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(1);
            U.writeString((DataOutput)out, (String)resp.errorMessage());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR handshake response.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalBatchRequest req) throws IgniteCheckedException {
        assert (req.dataBytes() != null) : "DR batch request is not prepared: " + req;
        int size = 40 + req.dataSize();
        String cacheName = req.cacheName();
        if (cacheName != null) {
            size += 4 + cacheName.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(4);
            U.writeGridUuid((DataOutput)out, (IgniteUuid)req.requestId());
            U.writeString((DataOutput)out, (String)cacheName);
            out.writeInt(req.entryCount());
            out.writeInt(req.dataSize());
            out.writeByte((int)req.dataCenterId());
            U.writeByteArray((DataOutput)out, (byte[])req.dataBytes(), (int)req.dataSize());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR batch request.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalHandshakeRequest req) throws IgniteCheckedException {
        int size = 21 + req.protocolVersion().length() + req.marshallerClassName().length();
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(0);
            out.writeByte((int)req.dataCenterId());
            U.writeString((DataOutput)out, (String)req.protocolVersion());
            U.writeString((DataOutput)out, (String)req.marshallerClassName());
            out.writeBoolean(req.awaitAcknowledge());
            out.writeLong(req.getTombstoneTtl());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR handshake request.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalBatchResponse resp) throws IgniteCheckedException {
        int size = 27;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(5);
            U.writeGridUuid((DataOutput)out, (IgniteUuid)resp.requestId());
            U.writeString((DataOutput)out, (String)resp.errorMessage());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR batch response.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalMetadataRequest req, boolean usingBinaryMarshaller) throws IgniteCheckedException {
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(128);
        try {
            out.writeByte(6);
            out.writeLong(req.version());
            for (Map.Entry<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> entry : req.metadata().entrySet()) {
                out.writeBoolean(true);
                out.writeUTF(entry.getKey());
                IgniteBiTuple<Byte, Integer> tup = entry.getValue().value();
                out.writeByte((int)((Byte)tup.get1()).byteValue());
                out.writeInt(((Integer)tup.get2()).intValue());
            }
            out.writeBoolean(false);
            if (usingBinaryMarshaller) {
                for (DrSenderMetadataHolder.Versioned versioned : req.binaryMetadata()) {
                    out.writeBoolean(true);
                    ((BinaryMetadata)versioned.value()).writeTo((DataOutput)out);
                }
                out.writeBoolean(false);
            }
            return out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR metadata request.", (Throwable)e);
        }
    }

    public static byte[] marshal(DrExternalMetadataResponse resp) throws IgniteCheckedException {
        int size = 10;
        String errMsg = resp.errorMessage();
        if (errMsg != null) {
            size += 4 + errMsg.length();
        }
        GridUnsafeDataOutput out = new GridUnsafeDataOutput(size);
        try {
            out.writeByte(7);
            out.writeLong(resp.version());
            U.writeString((DataOutput)out, (String)resp.errorMessage());
            return out.offset() == size ? out.internalArray() : out.array();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to marshal DR metadata response.", (Throwable)e);
        }
    }

    public static Object unmarshal(byte[] data, boolean usingBinaryMarshaller) throws IgniteCheckedException {
        assert (data != null);
        return DrUtils.unmarshal(data, data.length, usingBinaryMarshaller);
    }

    public static Object unmarshal(byte[] data, int size, boolean usingBinaryMarshaller) throws IgniteCheckedException {
        GridUnsafeDataInput in = new GridUnsafeDataInput();
        in.bytes(data, size);
        try {
            byte typ = in.readByte();
            switch (typ) {
                case 0: {
                    byte dcId = in.readByte();
                    String protoVer = U.readString((DataInput)in);
                    String marshClsName = U.readString((DataInput)in);
                    boolean awaitAck = in.readBoolean();
                    long tombstoneTtl = 0L;
                    try {
                        tombstoneTtl = in.readLong();
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    return new DrExternalHandshakeRequest(dcId, protoVer, marshClsName, awaitAck, tombstoneTtl).size(data.length);
                }
                case 1: {
                    return new DrExternalHandshakeResponse(U.readString((DataInput)in)).size(data.length);
                }
                case 2: {
                    return PING_REQ;
                }
                case 3: {
                    return PING_RESP;
                }
                case 4: {
                    IgniteUuid reqId = U.readGridUuid((DataInput)in);
                    String cacheName = U.readString((DataInput)in);
                    int entryCnt = in.readInt();
                    in.readInt();
                    byte dataCenterId = in.readByte();
                    byte[] dataBytes = U.readByteArray((DataInput)in);
                    return new DrExternalBatchRequest(reqId, cacheName, dataCenterId, entryCnt, dataBytes, dataBytes.length).size(data.length);
                }
                case 5: {
                    return new DrExternalBatchResponse(U.readGridUuid((DataInput)in), U.readString((DataInput)in)).size(data.length);
                }
                case 6: {
                    long ver = in.readLong();
                    HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>> meta = new HashMap<String, DrSenderMetadataHolder.Versioned<IgniteBiTuple<Byte, Integer>>>();
                    while (in.readBoolean()) {
                        String cls = in.readUTF();
                        byte platformId = in.readByte();
                        int typeId = in.readInt();
                        meta.put(cls, new DrSenderMetadataHolder.Versioned<IgniteBiTuple>(0L, F.t((Object)platformId, (Object)typeId)));
                    }
                    ArrayList<DrSenderMetadataHolder.Versioned<BinaryMetadata>> binaryMeta = new ArrayList<DrSenderMetadataHolder.Versioned<BinaryMetadata>>();
                    if (usingBinaryMarshaller) {
                        while (in.readBoolean()) {
                            BinaryMetadata binaryMetadataEntry = new BinaryMetadata();
                            binaryMetadataEntry.readFrom((DataInput)in);
                            binaryMeta.add(new DrSenderMetadataHolder.Versioned<BinaryMetadata>(0L, binaryMetadataEntry));
                        }
                    }
                    return new DrExternalMetadataRequest(ver, meta, binaryMeta).size(data.length);
                }
                case 7: {
                    return new DrExternalMetadataResponse(in.readLong(), U.readString((DataInput)in)).size(data.length);
                }
            }
            throw new IgniteCheckedException("Unknown DR message type: " + typ);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to unmarshal DR message.", (Throwable)e);
        }
    }

    @NotNull
    public static String effectiveSenderGroup(CacheDrSenderConfiguration cfg) {
        return cfg.getSenderGroup() == null ? DFLT_SENDER_GROUP_NAME : cfg.getSenderGroup();
    }

    @NotNull
    public static String[] effectiveSenderGroups(DrSenderConfiguration cfg) {
        return F.isEmpty((Object[])cfg.getSenderGroups()) ? DFLT_SENDER_GROUPS : cfg.getSenderGroups();
    }

    public static GridTuple4<IgniteUuid, String, Integer, Integer> batchRequestHeader(byte[] data) throws IgniteCheckedException {
        GridUnsafeDataInput in = new GridUnsafeDataInput();
        in.bytes(data, data.length);
        try {
            if (DrUtils.isNioMarshallerEnabled()) {
                in.skipBytes(4);
            }
            in.skipBytes(1);
            return F.t((Object)U.readGridUuid((DataInput)in), (Object)U.readString((DataInput)in), (Object)in.readInt(), (Object)in.readInt());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to read DR batch request header.", (Throwable)e);
        }
    }

    public static CacheDrManager drManagerSafe(GridCacheReplicationManager mgr, @Nullable String cacheName) {
        if (mgr instanceof CacheDrManager) {
            return (CacheDrManager)mgr;
        }
        throw new IgniteException("Data center replication is not configured for cache: " + cacheName);
    }

    public static boolean isDrSenderEnabled(CacheConfiguration ccfg) {
        GridGainCacheConfiguration ggCfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)ccfg, GridGainCacheConfiguration.class);
        return ggCfg != null && ggCfg.getDrSenderConfiguration() != null;
    }

    public static boolean isDrEnabled(GridGainConfiguration ggCcfg) {
        return ggCcfg != null && ggCcfg.getDataCenterId() > 0;
    }

    public static boolean isDrEnabled(GridGainCacheConfiguration ggCcfg) {
        return ggCcfg != null && (ggCcfg.getDrSenderConfiguration() != null || ggCcfg.isDrReceiverEnabled());
    }

    public static boolean isIncrementalDrEnabled() {
        return IgniteSystemProperties.getBoolean((String)"GG_INCREMENTAL_STATE_TRANSFER", (boolean)true);
    }

    public static boolean isNioMarshallerEnabled() {
        return DrUtils.isIncrementalDrEnabled();
    }

    public static int size(DrInternalRequest req) {
        int res = req.cacheName().getBytes().length;
        res += 4 + req.dataCenterIds().size();
        res += 4 + req.entries().stream().mapToInt(e -> 11 + e.dataBytes().length).sum();
        return res += 14;
    }

    private DrUtils() {
    }

    public static Collection<DrStateRecord> readDrState(IgniteCacheDatabaseSharedManager database, String metaKey) throws IgniteCheckedException {
        byte[] rawData;
        database.checkpointReadLock();
        try {
            rawData = database.metaStorage().readRaw(metaKey);
        }
        finally {
            database.checkpointReadUnlock();
        }
        return rawData == null ? Collections.emptyList() : DrUtils.deserialize(rawData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDrState(IgniteCacheDatabaseSharedManager database, String metaKey, Map<Integer, Long> partCountersMap) throws IgniteCheckedException {
        List<DrStateRecord> drStateRecords = partCountersMap.entrySet().stream().map(e -> new DrStateRecord((Integer)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
        byte[] serializedState = DrUtils.serialize(drStateRecords);
        database.checkpointReadLock();
        try {
            database.metaStorage().writeRaw(metaKey, serializedState);
        }
        finally {
            database.checkpointReadUnlock();
        }
    }

    public static void resetDrState(IgniteCacheDatabaseSharedManager database, String metaKey) throws IgniteCheckedException {
        database.checkpointReadLock();
        try {
            database.metaStorage().remove(metaKey);
        }
        finally {
            database.checkpointReadUnlock();
        }
    }

    private static List<DrStateRecord> deserialize(byte[] data) {
        if (F.isEmpty((byte[])data)) {
            return Collections.emptyList();
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        int ver = buf.getInt();
        assert (ver == DR_STATE_IO.version()) : "Unsupported version.";
        return DR_STATE_IO.read(buf);
    }

    private static byte[] serialize(Collection<DrStateRecord> partStates) {
        if (F.isEmpty(partStates)) {
            return U.EMPTY_BYTES;
        }
        ByteBuffer buf = ByteBuffer.allocate(4 + DR_STATE_IO.size(partStates));
        buf.putInt(DR_STATE_IO.version());
        DR_STATE_IO.write(buf, partStates);
        return buf.array();
    }

    public static String drStateMetastorageKey(String name) {
        return name + "-DrState";
    }

    public static CacheDrManager dr(GridKernalContext ctx, GridCacheProcessor cacheProc, String cacheName) throws IgniteCheckedException {
        CU.validateCacheName((String)cacheName);
        GridCacheAdapter cache = cacheProc.internalCache(cacheName);
        if (cache == null) {
            DynamicCacheDescriptor desc = cacheProc.cacheDescriptor(cacheName);
            if (desc == null) {
                throw new IllegalArgumentException("Cache is not configured: " + cacheName);
            }
            if (!desc.cacheType().userCache()) {
                throw new IllegalStateException("Failed to get cache because it is a system cache: " + cacheName);
            }
            assert (ctx.clientNode());
            cache = cacheProc.getOrStartCache(cacheName);
        }
        return DrUtils.drManagerSafe(cache.context().dr(), cacheName);
    }

    public static IgniteUuid generateFstId() {
        IgniteUuid fstUid = IgniteUuid.randomUuid();
        while (fstUid.equals((Object)FAKE_FST_ID)) {
            fstUid = IgniteUuid.randomUuid();
        }
        return fstUid;
    }

    static {
        DR_STATE_IO = new DrStateIO();
        PING_REQ_BYTES = new byte[]{2};
        PING_RESP_BYTES = new byte[]{3};
    }
}

