/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.jetbrains.annotations.Nullable;

class FstCacheRowFilter {
    private final int ignoredDC;
    private final long minUpdCntr;
    private final long maxUpdCntr;

    public FstCacheRowFilter(long minUpdCntr, long maxUpdateCntr, @Nullable Collection<Byte> ignoredDCs) {
        this.minUpdCntr = minUpdCntr;
        this.maxUpdCntr = maxUpdateCntr;
        int ignored = 0;
        if (ignoredDCs != null) {
            for (Byte dc : ignoredDCs) {
                ignored |= 1 << dc;
            }
        }
        this.ignoredDC = ignored;
    }

    public boolean apply(CacheDataRow row) throws IgniteCheckedException {
        if (row.key().internal()) {
            return false;
        }
        GridCacheVersion drVer = row.version();
        assert (drVer.conflictVersion() != null);
        if (this.ignoredDC != 0 && (this.ignoredDC & 1 << drVer.conflictVersion().dataCenterId()) != 0) {
            return false;
        }
        long updCntr = drVer.updateCounter();
        if (updCntr == 0L) {
            return true;
        }
        return updCntr > this.minUpdCntr && updCntr <= this.maxUpdCntr;
    }
}

