/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr.ist;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.dr.ist.PartitionCounterInfo;
import org.gridgain.grid.internal.processors.dr.DrUtils;

public class DrCollectReservedCountersJob
implements IgniteCallable<Collection<PartitionCounterInfo>> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private IgniteEx ignite;
    private String cacheName;

    public DrCollectReservedCountersJob(String cacheName) {
        this.cacheName = cacheName;
    }

    public Collection<PartitionCounterInfo> call() throws Exception {
        assert (DrUtils.isIncrementalDrEnabled());
        IgniteInternalCache cache = this.ignite.cachex(this.cacheName);
        assert (cache != null);
        CacheGroupContext grpCtx = cache.context().group();
        assert (grpCtx != null);
        List locParts = grpCtx.topology().localPartitions();
        return locParts.stream().filter(part -> part.state() == GridDhtPartitionState.MOVING || part.state() == GridDhtPartitionState.OWNING).map(part -> new PartitionCounterInfo(part.id(), part.reservedCounter())).collect(Collectors.toList());
    }
}

