/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.dr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.cache.dr.CacheDrPauseReason;
import org.gridgain.grid.cache.dr.CacheDrReceiverMetrics;
import org.gridgain.grid.cache.dr.CacheDrSenderMetrics;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrReceiverMetricsAdapter;
import org.gridgain.grid.internal.processors.cache.dr.CacheDrSenderMetricsAdapter;
import org.jetbrains.annotations.Nullable;

public class CacheDrMetrics
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private CacheDrSenderMetricsAdapter drSndMetrics;
    private CacheDrReceiverMetricsAdapter drRcvMetrics;
    @GridToStringExclude
    private transient CacheDrMetrics delegate;

    public CacheDrMetrics() {
    }

    public CacheDrMetrics(CacheDrMetrics m) {
        this.drSndMetrics = m.drSndMetrics;
        this.drRcvMetrics = m.drRcvMetrics;
    }

    public CacheDrMetrics(boolean isDrSndCache, boolean isDrRcvCache) {
        if (isDrSndCache) {
            this.drSndMetrics = new CacheDrSenderMetricsAdapter();
        }
        if (isDrRcvCache) {
            this.drRcvMetrics = new CacheDrReceiverMetricsAdapter();
        }
    }

    public void delegate(CacheDrMetrics delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public static CacheDrMetrics copyOf(@Nullable CacheDrMetrics m) {
        if (m == null) {
            return null;
        }
        return new CacheDrMetrics(m);
    }

    public CacheDrSenderMetrics drSendMetrics() {
        if (this.drSndMetrics == null) {
            throw new IllegalStateException("Data center replication is not configured.");
        }
        return this.drSndMetrics;
    }

    @Nullable
    public CacheDrSenderMetricsAdapter drSendMetrics0() {
        return this.drSndMetrics;
    }

    public CacheDrReceiverMetrics drReceiveMetrics() {
        if (this.drRcvMetrics == null) {
            throw new IllegalStateException("Data center replication is not configured.");
        }
        return this.drRcvMetrics;
    }

    @Nullable
    CacheDrReceiverMetricsAdapter drReceiveMetrics0() {
        return this.drRcvMetrics;
    }

    public void onSenderCacheBatchAcknowledged(int entriesCnt) {
        this.drSndMetrics.onBatchAcked(entriesCnt);
        if (this.delegate != null) {
            this.delegate.onSenderCacheBatchAcknowledged(entriesCnt);
        }
    }

    public void onSenderCacheBatchRejected(int entriesCnt) {
        this.drSndMetrics.onBatchRejected(entriesCnt);
        if (this.delegate != null) {
            this.delegate.onSenderCacheBatchRejected(entriesCnt);
        }
    }

    public void onSenderCacheBatchFailed(int entriesCnt) {
        this.drSndMetrics.onBatchFailed(entriesCnt);
        if (this.delegate != null) {
            this.delegate.onSenderCacheBatchFailed(entriesCnt);
        }
    }

    public void onSenderCacheBatchSent(int entriesCnt) {
        this.drSndMetrics.onBatchSent(entriesCnt);
        if (this.delegate != null) {
            this.delegate.onSenderCacheBatchSent(entriesCnt);
        }
    }

    public void onSenderCacheEntryFiltered() {
        this.drSndMetrics.onEntryFiltered();
        if (this.delegate != null) {
            this.delegate.onSenderCacheEntryFiltered();
        }
    }

    public void onFstThrottling(long millis) {
        this.drSndMetrics.onFstThrottling(millis);
        if (this.delegate != null) {
            this.delegate.onFstThrottling(millis);
        }
    }

    public void onStopStateChanged(@Nullable CacheDrPauseReason stopReason, @Nullable String errMsg) {
        this.drSndMetrics.onStopStateChanged(stopReason, errMsg);
        if (this.delegate != null) {
            this.delegate.onStopStateChanged(stopReason, errMsg);
        }
    }

    public void onReceiveCacheConflictResolved(boolean usedNew, boolean usedOld, boolean usedMerge) {
        if (this.drRcvMetrics != null) {
            this.drRcvMetrics.onReceiveCacheConflictResolved(usedNew, usedOld, usedMerge);
        }
        if (this.delegate != null) {
            this.delegate.onReceiveCacheConflictResolved(usedNew, usedOld, usedMerge);
        }
    }

    public void onReceiveCacheEntriesReceived(int entriesCnt) {
        if (this.drRcvMetrics != null) {
            this.drRcvMetrics.onReceiveCacheEntriesReceived(entriesCnt);
        }
        if (this.delegate != null) {
            this.delegate.onReceiveCacheEntriesReceived(entriesCnt);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.drSndMetrics);
        out.writeObject(this.drRcvMetrics);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.drSndMetrics = (CacheDrSenderMetricsAdapter)in.readObject();
        this.drRcvMetrics = (CacheDrReceiverMetricsAdapter)in.readObject();
    }

    public String toString() {
        return S.toString(CacheDrMetrics.class, (Object)this);
    }
}

