/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStageNodeLeftListener;
import org.jetbrains.annotations.Nullable;

public class CustomStagesConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final List<CustomStage> stages = new ArrayList<CustomStage>();
    private CustomStage finalStage;
    @Nullable
    private CustomStageNodeLeftListener onNodeLeftCb;
    @Nullable
    private IgniteInClosure<Boolean> onCancelCompleteCb;

    public CustomStage stage(int num) {
        return this.stages.get(num);
    }

    public CustomStagesConfiguration addStage(CustomStage stage) {
        this.stages.add(Objects.requireNonNull(stage, "Custom stage can't be null."));
        return this;
    }

    public int stagesNum() {
        return this.stages.size();
    }

    @Nullable
    public CustomStage finalStage() {
        return this.finalStage;
    }

    public CustomStagesConfiguration finalStage(CustomStage stage) {
        this.finalStage = Objects.requireNonNull(stage, "Custom stage can't be null.");
        return this;
    }

    @Nullable
    public CustomStageNodeLeftListener onNodeLeftCallback() {
        return this.onNodeLeftCb;
    }

    public CustomStagesConfiguration onNodeLeftCallback(CustomStageNodeLeftListener onNodeLeftCallback) {
        this.onNodeLeftCb = onNodeLeftCallback;
        return this;
    }

    @Nullable
    public IgniteInClosure<Boolean> onCancelCompleteCallback() {
        return this.onCancelCompleteCb;
    }

    public CustomStagesConfiguration onCancelCompleteCallback(IgniteInClosure<Boolean> cancelCompleteCallback) {
        this.onCancelCompleteCb = cancelCompleteCallback;
        return this;
    }

    public String toString() {
        return S.toString(CustomStagesConfiguration.class, (Object)this);
    }
}

