/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.UserCommandExceptions;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.RecoveryParams;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ClusterNoCachesException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoExtended;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.gridgain.grid.persistentstore.CheckSnapshotParams;
import org.gridgain.grid.persistentstore.CopySnapshotParams;
import org.gridgain.grid.persistentstore.ListSnapshotParams;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotCommonParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotInfoParams;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.Nullable;

public class GridSnapshotImpl
implements GridSnapshotEx {
    public static final String INCLUDE_EXCLUDE_PASSED_AT_THE_SAME_TIME_ERROR_MSG = "Pass either include caches or exclude caches parameter.";
    public static final String CACHES_OR_GROUPS_FROM_COMMAND_PARAMETERS_NOT_FOUND = "Caches or groups from command parameters not found: ";
    private final GridCacheSharedContext ctx;
    private final GridSnapshotManager snapshotMgr;
    private final SnapshotConfiguration snapCfg;

    public GridSnapshotImpl(GridCacheSharedContext ctx, GridSnapshotManager snapshotMgr, SnapshotConfiguration snapCfg) {
        this.ctx = ctx;
        this.snapshotMgr = snapshotMgr;
        this.snapCfg = snapCfg;
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(@Nullable Set<String> cacheNames, @Nullable String msg) {
        SnapshotCreateParameters snapshotCreateParameters = new SnapshotCreateParameters(this.snapCfg.getCompressionOption(), this.snapCfg.getCompressionLevel(), 0);
        snapshotCreateParameters.allCaches(F.isEmpty(cacheNames));
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames, null), null, true, null, msg, null, new SnapshotCommonParameters(this.snapCfg.getSnapshotOperationParallelism()), snapshotCreateParameters);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        snapshotCreateParameters.allCaches(F.isEmpty(cacheNames));
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(cacheNames, null), storePath, true, null, msg, null, new SnapshotCommonParameters(), snapshotCreateParameters);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, SnapshotCreateParams snapshotCreateParams, @Nullable String msg) {
        return this.createFullSnapshot(cacheNames, storePath, SnapshotCreateParameters.convertSnapshotCreateParams(snapshotCreateParams), msg);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, @Nullable SnapshotCommonParameters snapshotCommonParameters, @Nullable SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, null, storePath, snapshotCommonParameters, snapshotCreateParameters, msg, true);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, @Nullable SnapshotCommonParams snapshotCommonParams, @Nullable SnapshotCreateParams snapshotCreateParams, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, null, storePath, SnapshotCommonParameters.convertToSnapshotCommonParameters(snapshotCommonParams), SnapshotCreateParameters.convertSnapshotCreateParams(snapshotCreateParams), msg, true);
    }

    @Override
    public SnapshotFuture<Void> createFullSnapshot(@Nullable Set<String> cacheNames, @Nullable Set<String> excludeCacheNames, @Nullable File storePath, @Nullable SnapshotCommonParams snapshotCommonParams, @Nullable SnapshotCreateParams snapshotCreateParams, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, excludeCacheNames, storePath, SnapshotCommonParameters.convertToSnapshotCommonParameters(snapshotCommonParams), SnapshotCreateParameters.convertSnapshotCreateParams(snapshotCreateParams), msg, true);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(@Nullable Set<String> cacheNames, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, null, null, null, null, msg, false);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, null, storePath, new SnapshotCommonParameters(), snapshotCreateParameters, msg, false);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, SnapshotCreateParams snapshotCreateParams, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, null, storePath, null, SnapshotCreateParameters.convertSnapshotCreateParams(snapshotCreateParams), msg, false);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, @Nullable SnapshotCommonParameters snapshotCommonParameters, @Nullable SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, null, storePath, snapshotCommonParameters, snapshotCreateParameters, msg, false);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(@Nullable Set<String> cacheNames, @Nullable File storePath, @Nullable SnapshotCommonParams snapshotCommonParams, @Nullable SnapshotCreateParams snapshotCreateParams, @Nullable String msg) {
        return this.createSnapshot0(cacheNames, null, storePath, SnapshotCommonParameters.convertToSnapshotCommonParameters(snapshotCommonParams), SnapshotCreateParameters.convertSnapshotCreateParams(snapshotCreateParams), msg, false);
    }

    @Override
    public SnapshotFuture<Void> createSnapshot(@Nullable Set<String> includeCacheOrGroups, @Nullable Set<String> excludeCachesOrGroups, @Nullable File storePath, @Nullable SnapshotCommonParams snapshotCommonParams, @Nullable SnapshotCreateParams snapshotCreateParams, @Nullable String msg) {
        return this.createSnapshot0(includeCacheOrGroups, excludeCachesOrGroups, storePath, SnapshotCommonParameters.convertToSnapshotCommonParameters(snapshotCommonParams), SnapshotCreateParameters.convertSnapshotCreateParams(snapshotCreateParams), msg, false);
    }

    private SnapshotFuture<Void> createSnapshot0(@Nullable Set<String> includeCacheOrGroups, @Nullable Set<String> excludeCachesOrGroups, @Nullable File storePath, @Nullable SnapshotCommonParameters snapshotCommonParameters, @Nullable SnapshotCreateParameters snapshotCreateParameters, @Nullable String msg, boolean isFull) {
        snapshotCommonParameters = snapshotCommonParameters == null ? new SnapshotCommonParameters(this.snapCfg.getSnapshotOperationParallelism()) : snapshotCommonParameters;
        snapshotCreateParameters = snapshotCreateParameters == null ? new SnapshotCreateParameters(this.snapCfg.getCompressionOption(), this.snapCfg.getCompressionLevel(), 0) : snapshotCreateParameters;
        snapshotCreateParameters.allCaches(F.isEmpty(includeCacheOrGroups));
        return this.snapshotMgr.startGlobalSnapshotCreation(this.cacheNames(includeCacheOrGroups, excludeCachesOrGroups), storePath, isFull, null, msg, null, snapshotCommonParameters, snapshotCreateParameters);
    }

    private Set<String> cacheNames(@Nullable Set<String> includedCachesOrGroups, @Nullable Set<String> excludedCachesOrGroups) {
        Set<String> res;
        if (this.snapshotMgr.pointInTimeRecoveryEnabled() && (includedCachesOrGroups != null || excludedCachesOrGroups != null)) {
            throw new IgniteException("If point in time recovery is enabled then snapshot with explicit cache is not possible!");
        }
        if (!F.isEmpty(includedCachesOrGroups) && !F.isEmpty(excludedCachesOrGroups)) {
            throw new IgniteException(INCLUDE_EXCLUDE_PASSED_AT_THE_SAME_TIME_ERROR_MSG);
        }
        Set<String> set = res = F.isEmpty(includedCachesOrGroups) ? GridSnapshotManager.getAllCachesForSnapshot(this.ctx.cache().cacheDescriptors().values()) : this.transformToCacheNames(includedCachesOrGroups);
        if (!F.isEmpty(excludedCachesOrGroups)) {
            res.removeAll(this.transformToCacheNames(excludedCachesOrGroups));
        }
        if (res.isEmpty()) {
            throw new ClusterNoCachesException("Snapshot creation with empty list of caches is requested with filter [included caches or groups=" + includedCachesOrGroups + ", excluded caches or groups=" + excludedCachesOrGroups + "]");
        }
        return res;
    }

    private Set<String> transformToCacheNames(Set<String> cachesOrGroups) {
        Map allCaches = this.ctx.cache().cacheDescriptors();
        Map allGroups = this.ctx.cache().cacheGroupDescriptors();
        HashSet<String> res = new HashSet<String>();
        HashSet<String> wrongCachesOrGroups = new HashSet<String>();
        for (String cacheOrGroup : cachesOrGroups) {
            DynamicCacheDescriptor cacheDsc = (DynamicCacheDescriptor)allCaches.get(cacheOrGroup);
            if (cacheDsc != null) {
                this.validateCacheForSnapshot(cacheDsc);
                res.add(cacheOrGroup);
                continue;
            }
            CacheGroupDescriptor grpDsc = (CacheGroupDescriptor)allGroups.get(CU.cacheId((String)cacheOrGroup));
            if (grpDsc != null) {
                for (String cacheName : grpDsc.caches().keySet()) {
                    cacheDsc = (DynamicCacheDescriptor)allCaches.get(cacheName);
                    this.validateCacheForSnapshot(cacheDsc);
                    res.add(cacheName);
                }
                continue;
            }
            wrongCachesOrGroups.add(cacheOrGroup);
        }
        if (!wrongCachesOrGroups.isEmpty()) {
            throw new IgniteException(CACHES_OR_GROUPS_FROM_COMMAND_PARAMETERS_NOT_FOUND + wrongCachesOrGroups);
        }
        return res;
    }

    private void validateCacheForSnapshot(DynamicCacheDescriptor desc) {
        if (!desc.groupDescriptor().persistenceEnabled()) {
            throw new IgniteException("Can't create snapshot of cache '" + desc.cacheName() + "': cache resides in non-persistent data region");
        }
        if (GridCacheUtils.isReservedCacheName((String)desc.cacheName())) {
            throw new IgniteException("Can't create snapshot of cache '" + desc.cacheName() + "': cache is for internal purpose.");
        }
        if (!(desc.cacheType().userCache() || desc.cacheType() == CacheType.DATA_STRUCTURES && CU.cacheId((String)"default-volatile-ds-group") != desc.groupId())) {
            throw new IgniteException("Can't create snapshot of cache '" + desc.cacheName() + "': not user cache and not data structure cache, cacheType=" + desc.cacheType() + ".");
        }
        if (desc.cacheConfiguration().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            throw new IgniteException("Snapshot creation is not supported for caches with " + CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT + " atomicity mode [cacheName=\"" + desc.cacheName() + "\"]");
        }
    }

    @Override
    public List<SnapshotInfo> listSnapshots(Collection<File> optSearchPaths) {
        return this.list0(GridSnapshotImpl.convertToSnapshotPath(optSearchPaths));
    }

    @Override
    public List<SnapshotInfo> list() {
        return this.list0(null);
    }

    @Override
    public List<SnapshotInfo> list(@Nullable ListSnapshotParams params) {
        return this.list0(params == null ? null : params.optionalSearchPaths());
    }

    private List<SnapshotInfo> list0(@Nullable Collection<SnapshotPath> optSearchPaths) {
        GridSnapshotImpl.checkPaths(optSearchPaths);
        try {
            return new ArrayList<SnapshotInfo>(this.snapshotMgr.getSnapshotList(optSearchPaths));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotInfoEx snapshot(long snapshotId, @Nullable Collection<File> optSearchPaths) {
        return this.snapshot0(snapshotId, GridSnapshotImpl.convertToSnapshotPath(optSearchPaths));
    }

    @Override
    public SnapshotInfoEx snapshot(SnapshotInfoParams params) {
        return this.snapshot0(params.snapshotId(), params.optionalSearchPaths());
    }

    private SnapshotInfoEx snapshot0(long snapshotId, @Nullable Collection<SnapshotPath> optSearchPaths) {
        try {
            SnapshotInfoExtended res = this.snapshotMgr.getSnapshotInfo(snapshotId, optSearchPaths);
            if (res == null) {
                throw UserCommandExceptions.invalidUserCommandException((String)("Snapshot does not exist [id=" + snapshotId + ']'), (GridKernalContext)this.ctx.kernalContext());
            }
            return res;
        }
        catch (IgniteException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Failed to merge snapshot metadata [oldMeta=")) {
                return null;
            }
            throw new IgniteException((Throwable)e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, Set<String> cacheNames, String msg) {
        return this.restoreSnapshot(snapshotId, optSearchPaths, cacheNames, null, msg);
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, Set<String> cacheNames, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, String msg) {
        return this.restoreSnapshot(snapshotId, optSearchPaths, cacheNames, false, c, msg);
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> cacheNames, boolean forceRestore, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg) {
        return this.restoreSnapshot0(snapshotId, GridSnapshotImpl.convertToSnapshotPath(optSearchPaths), cacheNames, null, forceRestore, c, null, msg);
    }

    @Override
    public SnapshotFuture<Void> restore(RestoreSnapshotParams params) {
        return this.restoreSnapshot0(params.snapshotId(), params.optionalSearchPaths(), params.cacheNames(), params.excludedCacheNames(), params.forceRestore(), params.conversionClosure(), params.parallelism(), params.message());
    }

    @Override
    public SnapshotFuture<Void> restoreSnapshot(long snapshotId, Set<String> cacheNames, String msg) {
        return this.restoreSnapshot(snapshotId, null, cacheNames, msg);
    }

    private SnapshotFuture<Void> restoreSnapshot0(long snapshotId, @Nullable Collection<SnapshotPath> optSearchPaths, @Nullable Set<String> includedCacheNames, @Nullable Set<String> excludedCachesOrGroups, boolean forceRestore, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable Integer parallelism, @Nullable String msg) {
        GridSnapshotImpl.checkPaths(optSearchPaths);
        try {
            parallelism = parallelism != null ? parallelism.intValue() : this.snapCfg.getRestoreOperationParallelism();
            return this.snapshotMgr.startGlobalSnapshotRestore(snapshotId, includedCacheNames, excludedCachesOrGroups, forceRestore, optSearchPaths, c, msg, new SnapshotCommonParameters(parallelism), null);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> deleteSnapshot(long snapshotId, @Nullable String msg) {
        try {
            return this.snapshotMgr.startGlobalSnapshotDeletion(snapshotId, new SnapshotUpdateOperationParameters(), msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> deleteSnapshot(long snapshotId, SnapshotUpdateOperationParameters operationParameters, String msg) {
        try {
            return this.snapshotMgr.startGlobalSnapshotDeletion(snapshotId, operationParameters, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> deleteSnapshot(long snapshotId, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.deleteSnapshot(snapshotId, this.convertSnapshotUpdateOperationParams(operationParams), msg);
    }

    @Override
    public SnapshotFuture<Void> forceDeleteSnapshot(long snapshotId, String msg) {
        try {
            return this.snapshotMgr.startGlobalSnapshotDeletion(snapshotId, new SnapshotUpdateOperationParameters(SnapshotChainMode.FROM_CURRENT_TO_LAST, false, false, null), msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, Collection<File> optSearchPaths, boolean skipCrc, String msg) {
        return this.checkSnapshot0(snapshotId, SnapshotOperationType.RESTORE, null, null, false, GridSnapshotImpl.convertToSnapshotPath(optSearchPaths), skipCrc, null, msg, null);
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> cacheNames, boolean forceRestore, boolean skipCrc, @Nullable String msg) {
        return this.checkSnapshot0(snapshotId, SnapshotOperationType.RESTORE, cacheNames, null, forceRestore, GridSnapshotImpl.convertToSnapshotPath(optSearchPaths), skipCrc, null, msg, null);
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, SnapshotOperationType type, Collection<File> optSearchPaths, boolean skipCrc, String msg) {
        return this.checkSnapshot0(snapshotId, type, null, null, false, GridSnapshotImpl.convertToSnapshotPath(optSearchPaths), skipCrc, null, msg, null);
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> checkSnapshot(long snapshotId, SnapshotOperationType type, @Nullable Set<String> cacheNames, boolean forceRestore, Collection<File> optSearchPaths, boolean skipCrc, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, String msg) {
        return this.checkSnapshot0(snapshotId, type, cacheNames, null, forceRestore, GridSnapshotImpl.convertToSnapshotPath(optSearchPaths), skipCrc, c, msg, null);
    }

    @Override
    public SnapshotFuture<List<SnapshotIssue>> check(CheckSnapshotParams params) {
        return this.checkSnapshot0(params.snapshotId(), params.operationType(), params.cacheNames(), params.excludedCacheNames(), params.forceRestore(), params.optionalSearchPaths(), params.skipCrc(), params.conversionClosure(), params.message(), params.parallelism());
    }

    private SnapshotFuture<List<SnapshotIssue>> checkSnapshot0(long snapshotId, SnapshotOperationType type, @Nullable Set<String> includedCacheOrGroups, @Nullable Set<String> excludedCachesOrGroups, boolean forceRestore, Collection<SnapshotPath> optSearchPaths, boolean skipCrc, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, String msg, @Nullable Integer parallelism) {
        GridSnapshotImpl.checkPaths(optSearchPaths);
        try {
            parallelism = parallelism != null ? parallelism : 4;
            return this.snapshotMgr.startGlobalSnapshotCheck(snapshotId, type, includedCacheOrGroups, excludedCachesOrGroups, forceRestore, optSearchPaths, skipCrc, c, msg, new SnapshotCommonParameters(parallelism));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, String msg) {
        return this.moveSnapshot(snapshotId, destPath, false, (SnapshotUpdateOperationParameters)null, msg);
    }

    @Override
    public SnapshotFuture<Void> forceMoveSnapshot(long snapshotId, File destPath, String msg) {
        return this.moveSnapshot(snapshotId, destPath, false, new SnapshotUpdateOperationParameters(SnapshotChainMode.FROM_CURRENT_TO_LAST, true, false, null), msg);
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, boolean skipWalMove, String msg) {
        return this.moveSnapshot(snapshotId, destPath, skipWalMove, (SnapshotUpdateOperationParameters)null, msg);
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParameters, String msg) {
        return this.moveSnapshot0(snapshotId, SnapshotPath.file().path(destPath).build(), skipWalMove, operationParameters, msg);
    }

    @Override
    public SnapshotFuture<Void> moveSnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.moveSnapshot(snapshotId, destPath, skipWalMove, this.convertSnapshotUpdateOperationParams(operationParams), msg);
    }

    @Override
    public SnapshotFuture<Void> move(MoveSnapshotParams params) {
        return this.moveSnapshot0(params.snapshotId(), params.destinationPath(), params.skipWalMove(), new SnapshotUpdateOperationParameters(params.chainMode(), params.deleteSources(), params.singleFileCopy(), params.parallelismLevel()), params.message());
    }

    private SnapshotFuture<Void> moveSnapshot0(long snapshotId, SnapshotPath destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParameters, String msg) {
        A.notNull((Object)destPath, (String)"destPath");
        try {
            return this.snapshotMgr.startGlobalSnapshotMoving(snapshotId, destPath, skipWalMove, operationParameters, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, SnapshotUpdateOperationParameters operationParameters, String msg) {
        return this.copySnapshot(snapshotId, destPath, false, operationParameters, msg);
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.copySnapshot(snapshotId, destPath, false, operationParams, msg);
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParameters, String msg) {
        return this.copy0(snapshotId, SnapshotPath.file().path(destPath).build(), skipWalMove, operationParameters, msg);
    }

    @Override
    public SnapshotFuture<Void> copySnapshot(long snapshotId, File destPath, boolean skipWalMove, SnapshotUpdateOperationParams operationParams, String msg) {
        return this.copySnapshot(snapshotId, destPath, skipWalMove, this.convertSnapshotUpdateOperationParams(operationParams), msg);
    }

    @Override
    public SnapshotFuture<Void> copy(CopySnapshotParams params) {
        return this.copy0(params.snapshotId(), params.destinationPath(), params.skipWalMove(), new SnapshotUpdateOperationParameters(params.chainMode(), params.deleteSources(), params.singleFileCopy(), params.parallelismLevel()), params.message());
    }

    private SnapshotFuture<Void> copy0(long snapshotId, SnapshotPath destPath, boolean skipWalMove, SnapshotUpdateOperationParameters operationParameters, String msg) {
        A.notNull((Object)destPath, (String)"destPath");
        try {
            return this.snapshotMgr.startGlobalSnapshotCopying(snapshotId, destPath, skipWalMove, operationParameters, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public SnapshotStatus ongoingSnapshotOperation() {
        try {
            return this.snapshotMgr.getOngoingOperation();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    @Nullable
    public IgniteFuture ongoingSnapshotOperationFuture() {
        return this.snapshotMgr.getOngoingOperationFuture();
    }

    private static void checkPaths(Collection<SnapshotPath> optSearchPaths) {
        if (!F.isEmpty(optSearchPaths)) {
            for (SnapshotPath path : optSearchPaths) {
                A.ensure((path != null ? 1 : 0) != 0, (String)"optSearchPaths contains null value");
            }
        }
    }

    @Override
    public IgniteFuture<Boolean> cancelSnapshotOperation(IgniteUuid operationId, String msg) {
        A.notNull((Object)operationId, (String)"operationId");
        try {
            return new IgniteFutureImpl(this.snapshotMgr.cancelSnapshotOperation(operationId, false, msg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    @Override
    public IgniteFuture<Boolean> forceCancelSnapshotOperation(IgniteUuid operationId, String msg) {
        A.notNull((Object)operationId, (String)"operationId");
        try {
            return new IgniteFutureImpl(this.snapshotMgr.cancelSnapshotOperation(operationId, true, msg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable String msg) {
        return this.recoveryTo(time, null, null, null, msg);
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable Set<String> caches, @Nullable String msg) {
        return this.recoveryTo(time, null, caches, null, msg);
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> caches, @Nullable String msg) {
        return this.recoveryTo(time, optSearchPaths, caches, null, msg);
    }

    public SnapshotFuture<Void> recoveryTo(long time, @Nullable Collection<File> optSearchPaths, @Nullable Set<String> caches, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg) {
        return this.recoveryTo0(time, GridSnapshotImpl.convertToSnapshotPath(optSearchPaths), caches, c, msg);
    }

    private SnapshotFuture<Void> recoveryTo0(long time, @Nullable Collection<SnapshotPath> optSearchPaths, @Nullable Set<String> caches, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable String msg) {
        GridSnapshotImpl.checkPaths(optSearchPaths);
        if (!F.isEmpty(caches)) {
            throw new UnsupportedOperationException("Recovery to a specific point in time is not supported for cache subset, please, don't specify caches to recover.");
        }
        try {
            return this.snapshotMgr.startGlobalRecoveryToPointInTime(time, optSearchPaths, caches, c, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    public SnapshotFuture<Void> recoveryTo(RecoveryParams params) {
        return this.recoveryTo0(params.time(), params.optionalSearchPaths(), null, params.conversionClosure(), params.message());
    }

    @Override
    public void updateSecurityLevel(SnapshotSecurityLevel level) throws IgniteCheckedException {
        this.snapshotMgr.updateSnapshotSecurityLevel(level);
    }

    @Override
    public SnapshotSecurityLevel getSecurityLevel() {
        return this.snapshotMgr.getSnapshotSecurityLevel();
    }

    @Nullable
    private static SnapshotPath convertToSnapshotPath(@Nullable File path) {
        return path == null ? null : SnapshotPath.file().path(path).build();
    }

    @Nullable
    private static Collection<SnapshotPath> convertToSnapshotPath(@Nullable Collection<File> paths) {
        return paths == null ? null : (Collection)paths.stream().map(GridSnapshotImpl::convertToSnapshotPath).collect(Collectors.toList());
    }

    @Override
    public SnapshotMetadata snapshotMetadata(long snapshot, Collection<SnapshotRemotePath> optSearchPaths) throws IgniteCheckedException {
        return this.snapshotMgr.snapshotMetadata(snapshot, optSearchPaths);
    }

    @Override
    public SnapshotFuture<Void> customSnapshotOperation(CustomStagesConfiguration customStagesConfiguration, @Nullable String msg) {
        return this.snapshotMgr.startGlobalCustomSnapshotOperation(customStagesConfiguration, msg);
    }

    @Nullable
    private SnapshotUpdateOperationParameters convertSnapshotUpdateOperationParams(@Nullable SnapshotUpdateOperationParams updateOperationParams) {
        return updateOperationParams == null ? null : new SnapshotUpdateOperationParameters(updateOperationParams.chainMode(), updateOperationParams.removeSources(), updateOperationParams.singleFileCopy(), updateOperationParams.parallelismLevel());
    }
}

