/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.conflict;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.version.CacheVersionConflictResolver;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;

public class CacheVersionConflictResolverImpl
implements CacheVersionConflictResolver {
    public <K, V> GridCacheVersionConflictContext<K, V> resolve(CacheObjectValueContext coctx, GridCacheVersionedEntryEx<K, V> oldEntry, GridCacheVersionedEntryEx<K, V> newEntry, boolean atomicVerComparator) throws IgniteCheckedException {
        GridCacheVersionConflictContext ctx = new GridCacheVersionConflictContext(coctx, oldEntry, newEntry);
        this.resolve0(ctx, oldEntry, newEntry, atomicVerComparator);
        return ctx;
    }

    protected <K, V> void resolve0(GridCacheVersionConflictContext<K, V> ctx, GridCacheVersionedEntryEx<K, V> oldEntry, GridCacheVersionedEntryEx<K, V> newEntry, boolean atomicVerComp) throws IgniteCheckedException {
        if (newEntry.dataCenterId() != oldEntry.dataCenterId()) {
            ctx.useNew();
        } else if (oldEntry.isStartVersion()) {
            ctx.useNew();
        } else if (atomicVerComp) {
            if (GridCacheMapEntry.ATOMIC_VER_COMPARATOR.compare(oldEntry.version(), newEntry.version()) >= 0) {
                ctx.useOld();
            } else {
                ctx.useNew();
            }
        } else {
            long topVerDiff = newEntry.topologyVersion() - oldEntry.topologyVersion();
            if (topVerDiff > 0L) {
                ctx.useNew();
            } else if (topVerDiff < 0L) {
                ctx.useOld();
            } else if (newEntry.order() > oldEntry.order()) {
                ctx.useNew();
            } else {
                ctx.useOld();
            }
        }
    }
}

