/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal;

import java.nio.file.Paths;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.node.VisorGridConfiguration;
import org.apache.ignite.plugin.PluginConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.GridPluginCacheAttributes;
import org.gridgain.grid.internal.visor.node.VisorGridGainNodeConfiguration;
import org.jetbrains.annotations.Nullable;

public class GridPluginUtils {
    public static GridPluginCacheAttributes[] cacheAttributes(ClusterNode n) {
        return (GridPluginCacheAttributes[])n.attribute("plugins.gg.cache");
    }

    @Nullable
    public static GridPluginCacheAttributes cacheAttributes(ClusterNode n, @Nullable String cacheName) {
        Object[] pluginAttrs = GridPluginUtils.cacheAttributes(n);
        if (F.isEmpty((Object[])pluginAttrs)) {
            return null;
        }
        for (Object a : pluginAttrs) {
            if (!F.eq((Object)((GridPluginCacheAttributes)a).cacheName(), (Object)cacheName)) continue;
            return a;
        }
        return null;
    }

    public static String gridGainLicenseUrl(IgniteConfiguration cfg) {
        if (cfg == null || cfg.getPluginConfigurations() == null) {
            return null;
        }
        for (PluginConfiguration pluginCfg : cfg.getPluginConfigurations()) {
            if (!(pluginCfg instanceof GridGainConfiguration)) continue;
            return ((GridGainConfiguration)pluginCfg).getLicenseUrl();
        }
        return null;
    }

    public static String gridGainLicenseUrl(VisorGridConfiguration cfg) {
        if (!(cfg instanceof VisorGridGainNodeConfiguration)) {
            return null;
        }
        return ((VisorGridGainNodeConfiguration)cfg).getLicenseUrl();
    }

    public static void setGridGainLicenseUrl(IgniteConfiguration cfg, String licUrl) {
        if (cfg == null || cfg.getPluginConfigurations() == null) {
            return;
        }
        for (PluginConfiguration pluginCfg : cfg.getPluginConfigurations()) {
            if (!(pluginCfg instanceof GridGainConfiguration)) continue;
            ((GridGainConfiguration)pluginCfg).setLicenseUrl(licUrl);
            return;
        }
    }

    public static void assertParameter(boolean cond, String condDesc) throws IgniteException {
        if (!cond) {
            throw new IgniteException("Check parameter failed condition check: " + condDesc);
        }
    }

    @Nullable
    public static GridGainConfiguration gridPluginConfiguration(IgniteConfiguration cfg) throws IgniteException {
        PluginConfiguration[] pluginsCfgs = cfg.getPluginConfigurations();
        if (pluginsCfgs == null) {
            return null;
        }
        for (PluginConfiguration pluginsCfg : pluginsCfgs) {
            if (!(pluginsCfg instanceof GridGainConfiguration)) continue;
            return (GridGainConfiguration)pluginsCfg;
        }
        return null;
    }

    public static void addGridPluginConfiguration(IgniteConfiguration cfg, GridGainConfiguration ggCfg) throws IgniteException {
        PluginConfiguration[] pluginsCfgs = cfg.getPluginConfigurations();
        if (pluginsCfgs == null) {
            cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
            return;
        }
        assert (GridPluginUtils.gridPluginConfiguration(cfg) == null);
        PluginConfiguration[] pluginCfgs0 = new PluginConfiguration[pluginsCfgs.length + 1];
        System.arraycopy(pluginsCfgs, 0, pluginCfgs0, 0, pluginsCfgs.length);
        pluginCfgs0[pluginCfgs0.length - 1] = ggCfg;
        cfg.setPluginConfigurations(pluginCfgs0);
    }

    public static String home() {
        return IgniteSystemProperties.getString((String)"GRIDGAIN_HOME", (String)(U.getIgniteHome() + "/../ggprivate"));
    }

    public static String homePath(String path) {
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return path;
        }
        return Paths.get(GridPluginUtils.home(), path).toString();
    }
}

