/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategy;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategySupplier;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cluster.IGridClusterStateProcessor;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.io.BulkLoadCommandProcessor;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.platform.PlatformPluginExtension;
import org.apache.ignite.internal.processors.query.h2.extension.SqlPluginExtension;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.IgniteSecurityProcessor;
import org.apache.ignite.internal.processors.security.NoOpIgniteSecurityProcessor;
import org.apache.ignite.internal.processors.segmentation.GridSegmentationProcessor;
import org.apache.ignite.internal.processors.txdr.TransactionalDrProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.apache.ignite.plugin.Extension;
import org.apache.ignite.plugin.ExtensionRegistry;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.PluginValidationException;
import org.apache.ignite.plugin.extensions.communication.IoPool;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridGainClientCacheConfigurationSerializer;
import org.gridgain.grid.internal.GridGainComponentType;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.GridPluginProcessor;
import org.gridgain.grid.internal.cache.GridCachePluginProvider;
import org.gridgain.grid.internal.communication.RollingUpgradeMessageFormatter;
import org.gridgain.grid.internal.interop.InteropPlatformPluginExtension;
import org.gridgain.grid.internal.processors.cache.conflict.CacheEntConflictResolutionManager;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridRecovery;
import org.gridgain.grid.internal.processors.cache.dr.ist.messages.DrPartitionStatesMessage;
import org.gridgain.grid.internal.processors.cache.dr.ist.messages.DrStateRecord;
import org.gridgain.grid.internal.processors.dr.DrProcessor;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalRequest;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalRequestEntry;
import org.gridgain.grid.internal.processors.dr.messages.DrInternalResponse;
import org.gridgain.grid.internal.processors.license.ClientEntLicenseProcessor;
import org.gridgain.grid.internal.processors.license.GridEntLicenseProcessor;
import org.gridgain.grid.internal.processors.license.GridLicenseFeature;
import org.gridgain.grid.internal.processors.license.LicenseProcessor;
import org.gridgain.grid.internal.processors.nodevalidation.GridEntDiscoveryNodeValidationProcessor;
import org.gridgain.grid.internal.processors.security.GridEntSecurityProcessor;
import org.gridgain.grid.internal.processors.segmentation.GridEntSegmentationProcessor;
import org.gridgain.grid.internal.ru.GridGainRollingUpgradeFacade;
import org.gridgain.grid.internal.txdr.GridGainTxDrConfiguration;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.internal.util.GridGainProperties;
import org.gridgain.grid.product.ProductLicense;
import org.gridgain.grid.ru.GridGainRollingUpgrade;
import org.jetbrains.annotations.Nullable;

public class GridPluginProvider
implements PluginProvider<GridGainConfiguration>,
IgniteChangeGlobalStateSupport,
EntryCompressionStrategySupplier {
    public static final byte DR_POOL_EXTENSION_ID = 33;
    public static final byte DR_STREAMER_POOL_EXTENSION_ID = 34;
    public static final byte SECURITY_POOL_EXTENSION_ID = 35;
    private static final String SNAPSHOTS_CATALOG_CLS = "org.gridgain.grid.internal.processors.cache.database.snapshot.catalog.SnapshotsCatalogProcessor";
    private static final String SNAPSHOTS_SCHEDULE_CLS = "org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor";
    private static final String RECOVERY_PROCESSOR_CLS = "org.gridgain.grid.internal.processors.cache.database.recovery.GridRecoveryProcessor";
    private static final String SNAPSHOT_MANAGER_CLS = "org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager";
    private static final String SNAPSHOT_STATE_PROCESSOR_CLS = "org.gridgain.grid.internal.processors.cache.database.GridSnapshotAwareClusterStateProcessorImpl";
    private static final String TRANSACTIONAL_DR_PROCESSOR_CLS = "org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl";
    private static final String ULTIMATE_MISSING_SUFFIX = "gridgain-ultimate is missing from classpath. To download it go to https://www.gridgain.com/resources/download#ultimateEdition.";
    private GridGainConfiguration cfg;
    private GridGain plugin;
    private List<GridPluginProcessor> comps = new ArrayList<GridPluginProcessor>();
    private PluginContext ctx;
    private GridKernalContext igniteCtx;
    private LicenseProcessor lic;
    private DrProcessor dr;
    private GridSnapshotManager snapshotManager;
    private TransactionalDr txDr;
    private GridRecovery recMgr;
    private GridPluginProcessor snapCatalog;
    private GridPluginProcessor snapScheduler;
    private GridGainRollingUpgrade rollingUpgrade;
    private IgniteLogger log;
    private String ver;
    private ThreadPoolExecutor drExecSvc;
    private ThreadPoolExecutor drStreamExecSvc;
    private ThreadPoolExecutor secExecSvc;
    private final byte forceDataCenterId = (byte)IgniteSystemProperties.getInteger((String)"GG_DR_FORCE_DC_ID", (int)0);

    private void init(PluginContext ctx) throws IgniteCheckedException {
        String revHash;
        boolean isSnapshotConfigured;
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.igniteCtx = ((IgniteEx)ctx.grid()).context();
        IgniteConfiguration igniteCfg = ctx.igniteConfiguration();
        if (igniteCfg.getPluginConfigurations() != null) {
            for (PluginConfiguration pluginCfg : igniteCfg.getPluginConfigurations()) {
                if (!(pluginCfg instanceof GridGainConfiguration)) continue;
                if (this.cfg == null) {
                    this.cfg = (GridGainConfiguration)pluginCfg;
                    continue;
                }
                throw new IgniteException("More than one instance of " + GridGainConfiguration.class.getSimpleName() + " is provided. Check your Ignite plugins configuration.");
            }
        }
        if (this.cfg == null) {
            this.cfg = new GridGainConfiguration();
        }
        this.lic = igniteCfg.isClientMode() != false ? new ClientEntLicenseProcessor(ctx, this.cfg) : new GridEntLicenseProcessor(ctx, this.cfg);
        this.lic.start();
        this.plugin = new GridGainImpl(this);
        boolean bl = isSnapshotConfigured = this.cfg != null && this.cfg.getSnapshotConfiguration() != null;
        if (isSnapshotConfigured && !this.ultimateLicense()) {
            throw new IgniteCheckedException("Snapshot feature is not allowed by the licence.");
        }
        boolean zOs = "z/OS".equals(System.getProperty("os.name"));
        if (zOs && !this.zOsLicense()) {
            throw new IgniteCheckedException("z/OS deployment is not allowed by the licence.");
        }
        if (igniteCfg.getCacheConfiguration() != null) {
            for (CacheConfiguration ccfg : igniteCfg.getCacheConfiguration()) {
                if (ccfg.getEntryCompressionConfiguration() == null || this.compressionLicense()) continue;
                throw new IgniteException("Entry compression is not allowed by the licence [cacheName=" + ccfg.getName() + "]");
            }
        }
        String rev = (revHash = GridGainProperties.get("gridgain.revision")).length() > 8 ? revHash.substring(0, 8) : revHash;
        String buildDataStr = GridGainProperties.get("gridgain.build");
        String relDate = "";
        if (buildDataStr != null && !buildDataStr.isEmpty()) {
            try {
                long buildDate = Long.valueOf(buildDataStr) * 1000L;
                relDate = IgniteVersionUtils.formatBuildTimeStamp((long)buildDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ver = GridGainProperties.get("gridgain.version") + '#' + relDate + "-sha1:" + rev;
    }

    public String name() {
        return "GridGain";
    }

    public String version() {
        return this.ver;
    }

    public String copyright() {
        return GridGainProperties.COPYRIGHT;
    }

    public <T extends IgnitePlugin> T plugin() {
        return (T)this.plugin;
    }

    @Nullable
    public <T> T createComponent(PluginContext ctx, Class<T> cls) {
        block27: {
            boolean persistenceEnabled = this.cfg != null && CU.isPersistenceEnabled((IgniteConfiguration)this.igniteCtx.config()) && !this.igniteCtx.isDaemon();
            ClassLoader ldr = U.gridClassLoader();
            try {
                Class<?> mgrCls;
                boolean txDrConfigured;
                block28: {
                    if (cls.equals(GridSecurityProcessor.class)) {
                        return (T)((Object)new GridEntSecurityProcessor(this.igniteCtx));
                    }
                    if (cls.equals(GridSegmentationProcessor.class)) {
                        return (T)((Object)new GridEntSegmentationProcessor(this.igniteCtx));
                    }
                    if (cls.equals(DiscoveryNodeValidationProcessor.class)) {
                        return (T)((Object)new GridEntDiscoveryNodeValidationProcessor(this.igniteCtx));
                    }
                    if (cls.equals(CacheConflictResolutionManager.class)) {
                        return (T)((Object)new CacheEntConflictResolutionManager(null));
                    }
                    if (cls.equals(IgniteCacheSnapshotManager.class)) {
                        Class<?> mgrCls2;
                        boolean isSnapshotConfigured;
                        block25: {
                            isSnapshotConfigured = this.cfg != null && this.cfg.getSnapshotConfiguration() != null;
                            mgrCls2 = null;
                            try {
                                mgrCls2 = ldr.loadClass(SNAPSHOT_MANAGER_CLS);
                                this.igniteCtx.addNodeAttribute("plugins.gg.ultimate", (Object)true);
                            }
                            catch (ClassNotFoundException e) {
                                if (!isSnapshotConfigured) break block25;
                                throw e;
                            }
                        }
                        if (mgrCls2 != null && !this.ultimateLicense()) {
                            IgniteLogger log0 = this.log == null ? ctx.log(GridPluginProvider.class) : this.log;
                            U.warn((IgniteLogger)log0, (Object)"Snapshot feature is disabled (not allowed by the license).");
                        }
                        if (!(persistenceEnabled || this.igniteCtx.clientNode() || this.igniteCtx.isDaemon())) {
                            if (isSnapshotConfigured) {
                                U.warn((IgniteLogger)this.log, (Object)"Will not start snapshot manager (snapshots are configured, but no persistence-enabled regions are configured)");
                            }
                            return null;
                        }
                        if ((persistenceEnabled || this.igniteCtx.clientNode() || this.igniteCtx.isDaemon()) && mgrCls2 != null && this.ultimateLicense()) {
                            return (T)mgrCls2.getConstructor(GridGainConfiguration.class).newInstance(this.cfg);
                        }
                        return null;
                    }
                    if (cls.equals(IGridClusterStateProcessor.class)) {
                        Class<?> mgrCls3;
                        block26: {
                            boolean isSnapshotConfigured = this.cfg != null && this.cfg.getSnapshotConfiguration() != null;
                            mgrCls3 = null;
                            try {
                                mgrCls3 = ldr.loadClass(SNAPSHOT_STATE_PROCESSOR_CLS);
                                this.igniteCtx.addNodeAttribute("plugins.gg.ultimate", (Object)true);
                            }
                            catch (ClassNotFoundException e) {
                                if (!isSnapshotConfigured) break block26;
                                throw e;
                            }
                        }
                        if (mgrCls3 != null && !this.ultimateLicense()) {
                            IgniteLogger log0 = this.log == null ? ctx.log(GridPluginProvider.class) : this.log;
                            U.warn((IgniteLogger)log0, (Object)"Snapshot feature is disabled (not allowed by the license).");
                        }
                        if ((persistenceEnabled || this.igniteCtx.clientNode() || this.igniteCtx.isDaemon()) && mgrCls3 != null && this.ultimateLicense()) {
                            return (T)mgrCls3.getConstructor(GridKernalContext.class).newInstance(this.igniteCtx);
                        }
                        return null;
                    }
                    if (!cls.equals(TransactionalDrProcessor.class)) break block27;
                    boolean isSnapshotConfigured = this.cfg != null && this.cfg.getSnapshotConfiguration() != null;
                    boolean bl = txDrConfigured = this.cfg != null && GridGainTxDrConfiguration.extractTxDrConfiguration(this.cfg) != null;
                    if (!isSnapshotConfigured && txDrConfigured) {
                        IgniteLogger log0 = this.log == null ? ctx.log(GridPluginProvider.class) : this.log;
                        U.warn((IgniteLogger)log0, (Object)"Transactional DR feature requires configured snapshot feature");
                        return null;
                    }
                    mgrCls = null;
                    try {
                        mgrCls = ldr.loadClass(TRANSACTIONAL_DR_PROCESSOR_CLS);
                    }
                    catch (ClassNotFoundException e) {
                        if (!txDrConfigured) break block28;
                        throw e;
                    }
                }
                if (mgrCls != null && !this.ultimateLicense()) {
                    IgniteLogger log0 = this.log == null ? ctx.log(GridPluginProvider.class) : this.log;
                    U.warn((IgniteLogger)log0, (Object)"Transactional DR feature is disabled (not allowed by the license).");
                }
                if (!(persistenceEnabled || this.igniteCtx.clientNode() || this.igniteCtx.isDaemon())) {
                    if (txDrConfigured) {
                        U.warn((IgniteLogger)this.log, (Object)"Will not start transactional DR manager (TX DR is configured, but no persistence-enabled regions are configured)");
                    }
                    return null;
                }
                if ((persistenceEnabled || this.igniteCtx.clientNode() || this.igniteCtx.isDaemon()) && mgrCls != null && txDrConfigured && this.ultimateLicense()) {
                    return (T)mgrCls.getConstructor(GridKernalContext.class, GridGainConfiguration.class).newInstance(this.igniteCtx, this.cfg);
                }
                return null;
            }
            catch (Exception e) {
                IgniteLogger log0 = this.log == null ? ctx.log(GridPluginProvider.class) : this.log;
                log0.error("Components initialization failed: " + cls.getName(), (Throwable)e);
            }
        }
        return null;
    }

    private boolean ultimateLicense() {
        return this.checkFeature("ultimate");
    }

    private boolean zOsLicense() {
        return this.checkFeature("zos");
    }

    public boolean compressionLicense() {
        return this.checkFeature("compression", "ultimate");
    }

    private boolean checkFeature(String ... reqFeatures) {
        ProductLicense prodLic = this.lic.license();
        assert (prodLic != null);
        Collection<GridLicenseFeature> features = prodLic.getEnabledFeatures();
        if (features != null) {
            for (String reqFeature : reqFeatures) {
                if (!features.contains(new GridLicenseFeature(reqFeature))) continue;
                return true;
            }
        }
        return false;
    }

    public CachePluginProvider createCacheProvider(CachePluginContext ctx) {
        return new GridCachePluginProvider(this, ctx);
    }

    public void initExtensions(PluginContext ctx, ExtensionRegistry registry) throws IgniteCheckedException {
        this.init(ctx);
        registry.registerExtension(MessageFactory.class, (Extension)new MessageFactory(){

            @Nullable
            public Message create(short type) {
                switch (type) {
                    case 120: {
                        return new DrInternalRequestEntry();
                    }
                    case 121: {
                        return new DrInternalRequest();
                    }
                    case 122: {
                        return new DrInternalResponse();
                    }
                    case 177: {
                        return new DrPartitionStatesMessage();
                    }
                    case 178: {
                        return new DrStateRecord();
                    }
                }
                return null;
            }
        });
        if (GridGainComponentType.SNAPSHOTS.inClassPath()) {
            registry.registerExtension(MessageFactory.class, (Extension)GridGainComponentType.SNAPSHOTS.newInstance());
        }
        if (GridGainComponentType.TRANSACTIONAL_DR.inClassPath()) {
            registry.registerExtension(MessageFactory.class, (Extension)GridGainComponentType.TRANSACTIONAL_DR.newInstance());
        }
        if (this.cfg.isRollingUpdatesEnabled()) {
            registry.registerExtension(MessageFormatter.class, (Extension)new RollingUpgradeMessageFormatter(this.igniteCtx));
        }
        if (GridGainComponentType.BULKLOAD.inClassPath()) {
            registry.registerExtension(BulkLoadCommandProcessor.class, (Extension)GridGainComponentType.BULKLOAD.newInstance());
        }
        if (GridGainComponentType.SQL.inClassPath()) {
            registry.registerExtension(SqlPluginExtension.class, (Extension)GridGainComponentType.SQL.newInstance());
        }
        String igniteInstanceName = ctx.igniteConfiguration().getIgniteInstanceName();
        this.drExecSvc = new IgniteThreadPoolExecutor("GridGain-data-replication", igniteInstanceName, this.cfg.getDrThreadPoolSize(), this.cfg.getDrThreadPoolSize(), 60000L, new LinkedBlockingQueue());
        this.drExecSvc.allowCoreThreadTimeOut(true);
        this.drStreamExecSvc = new IgniteThreadPoolExecutor("GridGain-data-streamer", igniteInstanceName, this.cfg.getDrStreamerThreadPoolSize(), this.cfg.getDrStreamerThreadPoolSize(), 60000L, new LinkedBlockingQueue());
        this.drStreamExecSvc.allowCoreThreadTimeOut(true);
        this.secExecSvc = new IgniteThreadPoolExecutor("GridGain-security", igniteInstanceName, this.cfg.getSecurityThreadPoolSize(), this.cfg.getSecurityThreadPoolSize(), 60000L, new LinkedBlockingQueue());
        this.secExecSvc.allowCoreThreadTimeOut(true);
        IoPool drPoolExtension = new IoPool(){

            public byte id() {
                return 33;
            }

            public Executor executor() {
                return GridPluginProvider.this.drExecSvc;
            }
        };
        registry.registerExtension(IoPool.class, (Extension)drPoolExtension);
        IoPool drStreamPoolExtension = new IoPool(){

            public byte id() {
                return 34;
            }

            public Executor executor() {
                return GridPluginProvider.this.drStreamExecSvc;
            }
        };
        registry.registerExtension(IoPool.class, (Extension)drStreamPoolExtension);
        IoPool securityExtension = new IoPool(){

            public byte id() {
                return 35;
            }

            public Executor executor() {
                return GridPluginProvider.this.secExecSvc;
            }
        };
        registry.registerExtension(IoPool.class, (Extension)securityExtension);
        registry.registerExtension(PlatformPluginExtension.class, (Extension)new InteropPlatformPluginExtension(this.igniteCtx));
        registry.registerExtension(EntryCompressionStrategySupplier.class, (Extension)this);
    }

    public void start(PluginContext ctx) throws IgniteCheckedException {
        TransactionalDrProcessor txDr;
        if (!this.cfg.isRollingUpdatesEnabled()) {
            U.quietAndWarn((IgniteLogger)this.log, (Object)"Rolling updates are disabled. GridGain version update will require full cluster restart. Consider changing 'GridGainConfiguration.rollingUpdatesEnabled' configuration property.");
        } else {
            this.igniteCtx.performance().add("Disable rolling updates");
        }
        this.validateConfiguration(this.cfg, ctx.grid().configuration());
        this.igniteCtx.addNodeAttribute("plugins.gg.node", (Object)true);
        this.igniteCtx.addNodeAttribute("plugins.gg.data.center.id", (Object)this.cfg.getDataCenterId());
        if (this.forceDataCenterId > 0) {
            this.cfg.setDataCenterId(this.forceDataCenterId);
            this.igniteCtx.addNodeAttribute("plugins.gg.force.data.center.id", (Object)this.cfg.getDataCenterId());
        }
        this.rollingUpgrade = new GridGainRollingUpgradeFacade(this.igniteCtx.rollingUpgrade());
        this.dr = new DrProcessor(ctx, this.cfg);
        this.comps.add(this.dr);
        if (!this.igniteCtx.isDaemon()) {
            boolean isSnapshotConfigured;
            this.igniteCtx.cache().context().versions().dataCenterId(this.cfg.getDataCenterId());
            boolean bl = isSnapshotConfigured = this.cfg.getSnapshotConfiguration() != null;
            if (!this.igniteCtx.clientNode() && isSnapshotConfigured && this.ultimateLicense()) {
                ClassLoader ldr = U.gridClassLoader();
                try {
                    this.snapCatalog = (GridPluginProcessor)ldr.loadClass(SNAPSHOTS_CATALOG_CLS).getConstructor(PluginContext.class, GridGainConfiguration.class).newInstance(ctx, this.cfg);
                    this.comps.add(this.snapCatalog);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
                try {
                    this.snapScheduler = (GridPluginProcessor)ldr.loadClass(SNAPSHOTS_SCHEDULE_CLS).getConstructor(PluginContext.class, GridGainConfiguration.class).newInstance(ctx, this.cfg);
                    this.comps.add(this.snapScheduler);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
                try {
                    if (CU.isPersistenceEnabled((IgniteConfiguration)this.igniteCtx.config())) {
                        this.recMgr = (GridRecovery)ldr.loadClass(RECOVERY_PROCESSOR_CLS).getConstructor(PluginContext.class, GridGainConfiguration.class).newInstance(ctx, this.cfg);
                        this.comps.add((GridPluginProcessor)((Object)this.recMgr));
                    }
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
        }
        for (GridPluginProcessor comp : this.comps) {
            comp.start();
        }
        this.comps.add(this.lic);
        IgniteCacheSnapshotManager snapshot = this.igniteCtx.cache().context().snapshot();
        if (snapshot instanceof GridSnapshotManager) {
            this.snapshotManager = (GridSnapshotManager)snapshot;
        }
        if ((txDr = this.igniteCtx.txDr()) instanceof TransactionalDr) {
            this.txDr = (TransactionalDr)txDr;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("GridGain Configuration: " + this.cfg);
        }
    }

    private void validateConfiguration(GridGainConfiguration ggCfg, IgniteConfiguration cfg) {
        boolean txDrConfigured;
        boolean isSnapshotConfigured;
        boolean drEnabled;
        A.ensure((ggCfg.getDataCenterId() >= 0 ? 1 : 0) != 0, (String)"cfg.getDataCenterId() >= 0");
        A.ensure((ggCfg.getDataCenterId() < 32 ? 1 : 0) != 0, (String)"cfg.getDataCenterId() <= 31");
        boolean bl = drEnabled = this.forceDataCenterId != 0 || ggCfg.getDataCenterId() != 0;
        if (drEnabled) {
            if (this.forceDataCenterId != 0) {
                A.ensure((this.forceDataCenterId > 0 && this.forceDataCenterId < 32 ? 1 : 0) != 0, (String)"System property GG_DR_FORCE_DC_ID must be between 1 and 31.");
            } else {
                A.ensure((ggCfg.getDataCenterId() > 0 && ggCfg.getDataCenterId() < 32 ? 1 : 0) != 0, (String)"cfg.getDataCenterId() must be between 1 and 31 if grid has send or receiver hub configuration.");
            }
            this.assertParameter(ggCfg.getDrThreadPoolSize() > 0, "cfg.getDrThreadPoolSize() >= 0");
            this.assertParameter(ggCfg.getIncrementalDrPoolSize() > 0, "cfg.getIncrementalDrPoolSize() > 0");
            this.assertParameter(ggCfg.getDrStreamerThreadPoolSize() > 0, "cfg.getDrStreamerThreadPoolSize() >= 0");
            this.assertParameter(ggCfg.getDrManagementThreadPoolSize() > 0, "cfg.getDrManagementThreadPoolSize() >= 0");
            if (!this.igniteCtx.clientNode()) {
                this.assertParameter(ggCfg.getDrStateTransferThreadPoolSize() > 0, "cfg.getDrStateTransferThreadPoolSize() > 0");
            }
        } else {
            A.ensure((ggCfg.getDrSenderConfiguration() == null ? 1 : 0) != 0, (String)"cfg.getDataCenterId() is not set. Sender hub can't be started.");
            A.ensure((ggCfg.getDrReceiverConfiguration() == null ? 1 : 0) != 0, (String)"cfg.getDataCenterId() is not set. Receiver hub can't be started.");
            for (CacheConfiguration ccfg : cfg.getCacheConfiguration()) {
                GridGainCacheConfiguration cpCfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)ccfg, GridGainCacheConfiguration.class);
                A.ensure((!DrUtils.isDrEnabled(cpCfg) ? 1 : 0) != 0, (String)("cfg.getDataCenterId() is not set. Data center replication can't be enabled for cache: " + ccfg.getName()));
            }
        }
        boolean bl2 = isSnapshotConfigured = ggCfg != null && ggCfg.getSnapshotConfiguration() != null;
        if (isSnapshotConfigured) {
            ClassLoader loader = U.gridClassLoader();
            try {
                Class.forName(SNAPSHOT_MANAGER_CLS, false, loader);
            }
            catch (ClassNotFoundException e) {
                this.failWithInvalidParameter("Install GridGain Ultimate Edition to create cluster snapshots. Otherwise, disable SnapshotConfiguration in your settings.");
            }
        }
        boolean bl3 = txDrConfigured = ggCfg != null && GridGainTxDrConfiguration.extractTxDrConfiguration(ggCfg) != null;
        if (txDrConfigured) {
            ClassLoader loader = U.gridClassLoader();
            try {
                Class.forName(TRANSACTIONAL_DR_PROCESSOR_CLS, false, loader);
            }
            catch (ClassNotFoundException e) {
                this.failWithInvalidParameter("Install GridGain Ultimate Edition to enable Transactional Data Replication feature. Otherwise, disable GridGainTxDrConfiguration in your settings.");
            }
        }
    }

    private void assertParameter(boolean cond, String condDesc) {
        if (!cond) {
            this.failWithInvalidParameter(condDesc);
        }
    }

    private void failWithInvalidParameter(String condDesc) {
        throw new IgniteException("GridGain plugin configuration parameter invalid: " + condDesc);
    }

    public void stop(boolean cancel) {
        for (GridPluginProcessor comp : this.comps) {
            comp.stop(cancel);
        }
        assert (this.log != null);
        U.shutdownNow(this.getClass(), (ExecutorService)this.drExecSvc, (IgniteLogger)this.log);
        this.drExecSvc = null;
        U.shutdownNow(this.getClass(), (ExecutorService)this.drStreamExecSvc, (IgniteLogger)this.log);
        this.drStreamExecSvc = null;
        U.shutdownNow(this.getClass(), (ExecutorService)this.secExecSvc, (IgniteLogger)this.log);
        this.secExecSvc = null;
    }

    public void onIgniteStart() throws IgniteCheckedException {
        for (GridPluginProcessor comp : this.comps) {
            comp.onIgniteStart();
        }
    }

    public void onIgniteStop(boolean cancel) {
        for (GridPluginProcessor comp : this.comps) {
            comp.onIgniteStop(cancel);
        }
    }

    @Nullable
    public Serializable provideDiscoveryData(UUID nodeId) {
        return null;
    }

    public void receiveDiscoveryData(UUID nodeId, Serializable data) {
        for (GridPluginProcessor comp : this.comps) {
            comp.receiveDiscoveryData(nodeId, data);
        }
    }

    public void validateNewNode(ClusterNode node) throws PluginValidationException {
        if (!node.isDaemon() && !this.ctx.localNode().isDaemon()) {
            Byte rmtDataCenterId;
            Byte locDataCenterId = (Byte)this.ctx.localNode().attribute("plugins.gg.force.data.center.id");
            if (locDataCenterId != null) {
                rmtDataCenterId = (Byte)node.attribute("plugins.gg.force.data.center.id");
                if (rmtDataCenterId == null) {
                    rmtDataCenterId = (Byte)node.attribute("plugins.gg.data.center.id");
                }
                if (!F.eq((Object)locDataCenterId, (Object)rmtDataCenterId) && !F.eq((Object)rmtDataCenterId, (Object)0)) {
                    String locMsg = "Remote node has data center ID different from local [locDataCenterId=" + locDataCenterId + ", rmtDataCenterId=" + rmtDataCenterId + ']';
                    String rmtMsg = "Remote node has data center ID different from local [locDataCenterId=" + rmtDataCenterId + ", rmtDataCenterId=" + locDataCenterId + ']';
                    throw new PluginValidationException(locMsg, rmtMsg, node.id());
                }
            } else {
                locDataCenterId = (Byte)this.ctx.localNode().attribute("plugins.gg.data.center.id");
                if (!F.eq((Object)locDataCenterId, (Object)(rmtDataCenterId = (Byte)node.attribute("plugins.gg.data.center.id")))) {
                    String locMsg = "Remote node has data center ID different from local [locDataCenterId=" + locDataCenterId + ", rmtDataCenterId=" + rmtDataCenterId + ']';
                    String rmtMsg = "Remote node has data center ID different from local [locDataCenterId=" + rmtDataCenterId + ", rmtDataCenterId=" + locDataCenterId + ']';
                    throw new PluginValidationException(locMsg, rmtMsg, node.id());
                }
            }
        }
        for (GridPluginProcessor comp : this.comps) {
            comp.validateNewNode(node);
        }
    }

    public PluginContext context() {
        return this.ctx;
    }

    public LicenseProcessor license() {
        return this.lic;
    }

    public DrProcessor dr() {
        return this.dr;
    }

    public TransactionalDr txDr() {
        return this.txDr;
    }

    @Nullable
    public GridSnapshotManager databaseManager() {
        return this.snapshotManager;
    }

    @Nullable
    public GridRecovery recovery() {
        return this.recMgr;
    }

    @Nullable
    public GridPluginProcessor getSnapshotsCatalog() {
        return this.snapCatalog;
    }

    @Nullable
    public GridPluginProcessor getSnapshotScheduler() {
        return this.snapScheduler;
    }

    @Nullable
    public GridEntSecurityProcessor security() {
        IgniteSecurity security = this.igniteCtx.security();
        if (security instanceof IgniteSecurityProcessor) {
            return (GridEntSecurityProcessor)((IgniteSecurityProcessor)security).gridSecurityProcessor();
        }
        if (security instanceof NoOpIgniteSecurityProcessor) {
            return (GridEntSecurityProcessor)((NoOpIgniteSecurityProcessor)security).gridSecurityProcessor();
        }
        throw new IllegalStateException("Unsupported security instance: " + security.getClass().getSimpleName());
    }

    public GridGainRollingUpgrade rollingUpgrade() {
        return this.rollingUpgrade;
    }

    public GridGainConfiguration configuration() {
        return this.cfg;
    }

    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        for (GridPluginProcessor proc : this.comps) {
            if (!(proc instanceof IgniteChangeGlobalStateSupport)) continue;
            ((IgniteChangeGlobalStateSupport)proc).onActivate(kctx);
        }
    }

    public void onDeActivate(GridKernalContext kctx) {
        for (int i = this.comps.size() - 1; i >= 0; --i) {
            GridPluginProcessor proc = this.comps.get(i);
            if (!(proc instanceof IgniteChangeGlobalStateSupport)) continue;
            ((IgniteChangeGlobalStateSupport)proc).onDeActivate(kctx);
        }
    }

    public <C extends EntryCompressionConfiguration> Map<Class<C>, IgniteClosure<C, EntryCompressionStrategy>> strategies() {
        HashMap<Class<C>, IgniteClosure<C, EntryCompressionStrategy>> res = new HashMap<Class<C>, IgniteClosure<C, EntryCompressionStrategy>>();
        try {
            Class<?> zstd = Class.forName("org.gridgain.grid.cache.compress.ZstdDictionaryCompressionConfiguration");
            Class<?> gzip = Class.forName("org.gridgain.grid.cache.compress.GzipCompressionConfiguration");
            res.putAll(((EntryCompressionStrategySupplier)zstd.newInstance()).strategies());
            res.putAll(((EntryCompressionStrategySupplier)gzip.newInstance()).strategies());
        }
        catch (ClassNotFoundException zstd) {
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IgniteException((Throwable)ex);
        }
        return res;
    }

    public <K, V> CachePluginConfiguration<K, V> readClientCachePluginConfiguration(BinaryRawReaderEx reader) {
        return GridGainClientCacheConfigurationSerializer.read((BinaryRawReader)reader);
    }
}

