/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class HibernateReadWriteAccessStrategy
extends HibernateAccessStrategyAdapter {
    private final ThreadLocal<TxContext> txCtx;

    protected HibernateReadWriteAccessStrategy(Ignite ignite, HibernateCacheProxy cache, ThreadLocal txCtx, HibernateExceptionConverter eConverter) {
        super(ignite, cache, eConverter);
        this.txCtx = txCtx;
    }

    @Override
    public Object get(Object key) {
        boolean success = false;
        Object val = null;
        try {
            val = this.cache.get(key);
            success = true;
            Object object = val;
            return object;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
        finally {
            if (!success) {
                this.rollbackCurrentTx();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Get [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ", success=" + success + ']');
            }
        }
    }

    @Override
    public void putFromLoad(Object key, Object val) {
        boolean success = false;
        try {
            this.cache.put(key, val);
            success = true;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
        finally {
            if (!success) {
                this.rollbackCurrentTx();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Put from load [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ", success=" + success + ']');
            }
        }
    }

    @Override
    public void lock(Object key) {
        boolean success = false;
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx == null) {
                ctx = new TxContext();
                this.txCtx.set(ctx);
            }
            this.lockKey(key);
            ctx.locked(key);
            success = true;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
        finally {
            if (!success) {
                this.rollbackCurrentTx();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock [cache=" + this.cache.name() + ", key=" + key + ", success=" + success + ']');
            }
        }
    }

    @Override
    public void unlock(Object key) {
        boolean success = false;
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.unlock(ctx, key);
            }
            success = true;
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        finally {
            if (!success) {
                this.rollbackCurrentTx();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unlock [cache=" + this.cache.name() + ", key=" + key + ", success=" + success + ']');
            }
        }
    }

    @Override
    public boolean update(Object key, Object val) {
        return false;
    }

    @Override
    public boolean afterUpdate(Object key, Object val) {
        boolean success = false;
        boolean res = false;
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.cache.put(key, val);
                this.unlock(ctx, key);
                res = true;
            }
            success = true;
            boolean bl = res;
            return bl;
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        finally {
            if (!success) {
                this.rollbackCurrentTx();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Put after update [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ", success=" + success + ']');
            }
        }
    }

    @Override
    public boolean insert(Object key, Object val) {
        return false;
    }

    @Override
    public boolean afterInsert(Object key, Object val) {
        boolean success = false;
        try {
            this.cache.put(key, val);
            success = true;
            boolean bl = true;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
        finally {
            if (!success) {
                this.rollbackCurrentTx();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Put after insert [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ", success=" + success + ']');
            }
        }
    }

    @Override
    public void remove(Object key) {
        boolean success = false;
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.cache.remove(key);
            }
            success = true;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
        finally {
            if (!success) {
                this.rollbackCurrentTx();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Remove [cache=" + this.cache.name() + ", key=" + key + ", success=" + success + ']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(TxContext ctx, Object key) {
        if (ctx.unlocked(key)) {
            this.txCtx.remove();
            GridNearTxLocal tx = this.cache.tx();
            assert (tx != null);
            try {
                tx.proxy().commit();
            }
            finally {
                tx.proxy().close();
            }
            assert (this.cache.tx() == null);
        }
    }

    private void rollbackCurrentTx() {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.txCtx.remove();
                GridNearTxLocal tx = this.cache.tx();
                if (tx != null) {
                    tx.proxy().rollback();
                }
            }
        }
        catch (IgniteException e) {
            this.log.error("Failed to rollback cache transaction.", (Throwable)e);
        }
    }

    private void lockKey(Object key) throws IgniteCheckedException {
        if (this.cache.tx() == null) {
            this.cache.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        }
        this.cache.get(key);
    }

    private static class TxContext {
        private Set<Object> locked = new GridLeanSet();

        private TxContext() {
        }

        void locked(Object key) {
            this.locked.add(key);
        }

        boolean unlocked(Object key) {
            this.locked.remove(key);
            return this.locked.isEmpty();
        }
    }
}

