/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;

public class HibernateReadOnlyAccessStrategy
extends HibernateAccessStrategyAdapter {
    public HibernateReadOnlyAccessStrategy(Ignite ignite, HibernateCacheProxy cache, HibernateExceptionConverter eConverter) {
        super(ignite, cache, eConverter);
    }

    @Override
    public boolean insert(Object key, Object val) {
        return false;
    }

    @Override
    public boolean afterInsert(Object key, Object val) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Put [cache=" + this.cache.name() + ", key=" + key + ']');
        }
        try {
            this.cache.put(key, val);
            return true;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public void lock(Object key) {
    }

    @Override
    public void unlock(Object key) {
    }

    @Override
    public void remove(Object key) {
    }

    @Override
    public boolean update(Object key, Object val) {
        throw new UnsupportedOperationException("Updates are not supported for read-only access strategy.");
    }

    @Override
    public boolean afterUpdate(Object key, Object val) {
        throw new UnsupportedOperationException("Updates are not supported for read-only access strategy.");
    }
}

