/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class HibernateNonStrictAccessStrategy
extends HibernateAccessStrategyAdapter {
    private final ThreadLocal<WriteContext> writeCtx;

    HibernateNonStrictAccessStrategy(Ignite ignite, HibernateCacheProxy cache, ThreadLocal writeCtx, HibernateExceptionConverter eConverter) {
        super(ignite, cache, eConverter);
        this.writeCtx = writeCtx;
    }

    @Override
    public void lock(Object key) {
        WriteContext ctx = this.writeCtx.get();
        if (ctx == null) {
            ctx = new WriteContext();
            this.writeCtx.set(ctx);
        }
        ctx.locked(key);
    }

    @Override
    public void unlock(Object key) {
        try {
            WriteContext ctx = this.writeCtx.get();
            if (ctx != null && ctx.unlocked(key)) {
                this.writeCtx.remove();
                ctx.updateCache(this.cache);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public boolean update(Object key, Object val) {
        return false;
    }

    @Override
    public boolean afterUpdate(Object key, Object val) {
        WriteContext ctx = this.writeCtx.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Put after update [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
        }
        if (ctx != null) {
            ctx.updated(key, val);
            this.unlock(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean insert(Object key, Object val) {
        return false;
    }

    @Override
    public boolean afterInsert(Object key, Object val) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Put after insert [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
        }
        try {
            this.cache.put(key, val);
            return true;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public void remove(Object key) {
        WriteContext ctx = this.writeCtx.get();
        if (ctx != null) {
            ctx.removed(key);
        }
    }

    private static class WriteContext {
        @GridToStringInclude
        private Map<Object, Object> updates;
        @GridToStringInclude
        private Set<Object> rmvs;
        @GridToStringInclude
        private Set<Object> locked = new GridLeanSet();

        private WriteContext() {
        }

        void locked(Object key) {
            this.locked.add(key);
        }

        boolean unlocked(Object key) {
            this.locked.remove(key);
            return this.locked.isEmpty();
        }

        void updated(Object key, Object val) {
            if (this.updates == null) {
                this.updates = new LinkedHashMap<Object, Object>();
            }
            this.updates.put(key, val);
        }

        void removed(Object key) {
            if (this.rmvs == null) {
                this.rmvs = new GridLeanSet();
            }
            this.rmvs.add(key);
        }

        void updateCache(HibernateCacheProxy cache) throws IgniteCheckedException {
            if (!F.isEmpty(this.rmvs)) {
                cache.removeAll(this.rmvs);
            }
            if (!F.isEmpty(this.updates)) {
                cache.putAll(this.updates);
            }
        }

        public String toString() {
            return S.toString(WriteContext.class, (Object)this);
        }
    }
}

