/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.hibernate.HibernateKeyTransformer;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class HibernateCacheProxy
implements IgniteInternalCache<Object, Object> {
    private final Supplier<IgniteInternalCache<Object, Object>> delegate;
    private final HibernateKeyTransformer keyTransformer;
    private String cacheName;

    HibernateCacheProxy(String cacheName, Supplier<IgniteInternalCache<Object, Object>> delegate, HibernateKeyTransformer keyTransformer) {
        assert (cacheName != null);
        assert (delegate != null);
        assert (keyTransformer != null);
        this.cacheName = cacheName;
        this.delegate = delegate;
        this.keyTransformer = keyTransformer;
    }

    public HibernateKeyTransformer keyTransformer() {
        return this.keyTransformer;
    }

    public String name() {
        return this.cacheName;
    }

    public boolean skipStore() {
        return this.delegate.get().skipStore();
    }

    public IgniteInternalCache setSkipStore(boolean skipStore) {
        return this.delegate.get().setSkipStore(skipStore);
    }

    public boolean isEmpty() {
        return this.delegate.get().isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.get().containsKey(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture<Boolean> containsKeyAsync(Object key) {
        return this.delegate.get().containsKeyAsync(this.keyTransformer.transform(key));
    }

    public boolean containsKeys(Collection keys) {
        return this.delegate.get().containsKey(this.transform(keys));
    }

    public IgniteInternalFuture<Boolean> containsKeysAsync(Collection keys) {
        return this.delegate.get().containsKeysAsync(this.transform(keys));
    }

    @Nullable
    public Object localPeek(Object key, CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().localPeek(this.keyTransformer.transform(key), peekModes);
    }

    public Iterable<Cache.Entry<Object, Object>> localEntries(CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().localEntries(peekModes);
    }

    @Nullable
    public Object get(Object key) throws IgniteCheckedException {
        return this.delegate.get().get(this.keyTransformer.transform(key));
    }

    @Nullable
    public CacheEntry getEntry(Object key) throws IgniteCheckedException {
        return this.delegate.get().getEntry(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture getAsync(Object key) {
        return this.delegate.get().getAsync(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture<CacheEntry<Object, Object>> getEntryAsync(Object key) {
        return this.delegate.get().getEntryAsync(this.keyTransformer.transform(key));
    }

    public Map getAll(@Nullable Collection keys) throws IgniteCheckedException {
        return this.delegate.get().getAll(this.transform(keys));
    }

    public Collection<CacheEntry<Object, Object>> getEntries(@Nullable Collection keys) throws IgniteCheckedException {
        return this.delegate.get().getEntries(this.transform(keys));
    }

    public IgniteInternalFuture<Map<Object, Object>> getAllAsync(@Nullable Collection keys) {
        return this.delegate.get().getAllAsync(this.transform(keys));
    }

    public IgniteInternalFuture<Collection<CacheEntry<Object, Object>>> getEntriesAsync(@Nullable Collection keys) {
        return this.delegate.get().getEntriesAsync(this.transform(keys));
    }

    @Nullable
    public Object getAndPut(Object key, Object val) throws IgniteCheckedException {
        return this.delegate.get().getAndPut(this.keyTransformer.transform(key), val);
    }

    public IgniteInternalFuture getAndPutAsync(Object key, Object val) {
        return this.delegate.get().getAndPutAsync(this.keyTransformer.transform(key), val);
    }

    public boolean put(Object key, Object val) throws IgniteCheckedException {
        return this.delegate.get().put(this.keyTransformer.transform(key), val);
    }

    public IgniteInternalFuture<Boolean> putAsync(Object key, Object val) {
        return this.delegate.get().putAsync(this.keyTransformer.transform(key), val);
    }

    @Nullable
    public Object getAndPutIfAbsent(Object key, Object val) throws IgniteCheckedException {
        return this.delegate.get().getAndPutIfAbsent(this.keyTransformer.transform(key), val);
    }

    public IgniteInternalFuture getAndPutIfAbsentAsync(Object key, Object val) {
        return this.delegate.get().getAndPutIfAbsentAsync(this.keyTransformer.transform(key), val);
    }

    public boolean putIfAbsent(Object key, Object val) throws IgniteCheckedException {
        return this.delegate.get().putIfAbsent(this.keyTransformer.transform(key), val);
    }

    public IgniteInternalFuture<Boolean> putIfAbsentAsync(Object key, Object val) {
        return this.delegate.get().putIfAbsentAsync(this.keyTransformer.transform(key), val);
    }

    @Nullable
    public Object getAndReplace(Object key, Object val) throws IgniteCheckedException {
        return this.delegate.get().getAndReplace(this.keyTransformer.transform(key), val);
    }

    public IgniteInternalFuture getAndReplaceAsync(Object key, Object val) {
        return this.delegate.get().getAndReplaceAsync(this.keyTransformer.transform(key), val);
    }

    public boolean replace(Object key, Object val) throws IgniteCheckedException {
        return this.delegate.get().replace(this.keyTransformer.transform(key), val);
    }

    public IgniteInternalFuture<Boolean> replaceAsync(Object key, Object val) {
        return this.delegate.get().replaceAsync(this.keyTransformer.transform(key), val);
    }

    public boolean replace(Object key, Object oldVal, Object newVal) throws IgniteCheckedException {
        return this.delegate.get().replace(this.keyTransformer.transform(key), oldVal, newVal);
    }

    public IgniteInternalFuture<Boolean> replaceAsync(Object key, Object oldVal, Object newVal) {
        return this.delegate.get().replaceAsync(this.keyTransformer.transform(key), oldVal, newVal);
    }

    public void putAll(@Nullable Map m) throws IgniteCheckedException {
        this.delegate.get().putAll(this.transform(m));
    }

    public IgniteInternalFuture<?> putAllAsync(@Nullable Map m) {
        return this.delegate.get().putAllAsync(this.transform(m));
    }

    public Set keySet() {
        return this.delegate.get().keySet();
    }

    public Set<Cache.Entry<Object, Object>> entrySet() {
        return this.delegate.get().entrySet();
    }

    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        return this.delegate.get().txStart(concurrency, isolation);
    }

    public GridNearTxLocal txStartEx(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        return this.delegate.get().txStartEx(concurrency, isolation);
    }

    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, int txSize) {
        return this.delegate.get().txStart(concurrency, isolation, timeout, txSize);
    }

    @Nullable
    public GridNearTxLocal tx() {
        return this.delegate.get().tx();
    }

    public boolean evict(Object key) {
        return this.delegate.get().evict(this.keyTransformer.transform(key));
    }

    public void evictAll(@Nullable Collection keys) {
        this.delegate.get().evictAll(this.transform(keys));
    }

    public void clearLocally(boolean srv, boolean near, boolean readers) {
        this.delegate.get().clearLocally(srv, near, readers);
    }

    public boolean clearLocally(Object key) {
        return this.delegate.get().clearLocally(this.keyTransformer.transform(key));
    }

    public void clearLocallyAll(Set keys, boolean srv, boolean near, boolean readers) {
        this.delegate.get().clearLocallyAll((Set)this.transform(keys), srv, near, readers);
    }

    public void clear(Object key) throws IgniteCheckedException {
        this.delegate.get().clear(this.keyTransformer.transform(key));
    }

    public void clearAll(Set keys) throws IgniteCheckedException {
        this.delegate.get().clearAll((Set)this.transform(keys));
    }

    public void clear() throws IgniteCheckedException {
        this.delegate.get().clear();
    }

    public IgniteInternalFuture<?> clearAsync() {
        return this.delegate.get().clearAsync();
    }

    public IgniteInternalFuture<?> clearAsync(Object key) {
        return this.delegate.get().clearAsync(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture<?> clearAllAsync(Set keys) {
        return this.delegate.get().clearAllAsync((Set)this.transform(keys));
    }

    @Nullable
    public Object getAndRemove(Object key) throws IgniteCheckedException {
        return this.delegate.get().getAndRemove(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture getAndRemoveAsync(Object key) {
        return this.delegate.get().getAndRemoveAsync(this.keyTransformer.transform(key));
    }

    public boolean remove(Object key) throws IgniteCheckedException {
        return this.delegate.get().remove(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture<Boolean> removeAsync(Object key) {
        return this.delegate.get().removeAsync(this.keyTransformer.transform(key));
    }

    public boolean remove(Object key, Object val) throws IgniteCheckedException {
        return this.delegate.get().remove(this.keyTransformer.transform(key), val);
    }

    public IgniteInternalFuture<Boolean> removeAsync(Object key, Object val) {
        return this.delegate.get().removeAsync(this.keyTransformer.transform(key), val);
    }

    public void removeAll(@Nullable Collection keys) throws IgniteCheckedException {
        this.delegate.get().removeAll(this.transform(keys));
    }

    public IgniteInternalFuture<?> removeAllAsync(@Nullable Collection keys) {
        return this.delegate.get().removeAllAsync(this.transform(keys));
    }

    public void removeAll() throws IgniteCheckedException {
        this.delegate.get().removeAll();
    }

    public IgniteInternalFuture<?> removeAllAsync() {
        return this.delegate.get().removeAllAsync();
    }

    public boolean lock(Object key, long timeout) throws IgniteCheckedException {
        return this.delegate.get().lock(this.keyTransformer.transform(key), timeout);
    }

    public IgniteInternalFuture<Boolean> lockAsync(Object key, long timeout) {
        return this.delegate.get().lockAsync(this.keyTransformer.transform(key), timeout);
    }

    public boolean lockAll(@Nullable Collection keys, long timeout) throws IgniteCheckedException {
        return this.delegate.get().lockAll(this.transform(keys), timeout);
    }

    public IgniteInternalFuture<Boolean> lockAllAsync(@Nullable Collection keys, long timeout) {
        return this.delegate.get().lockAllAsync(this.transform(keys), timeout);
    }

    public void unlock(Object key) throws IgniteCheckedException {
        this.delegate.get().unlock(this.keyTransformer.transform(key));
    }

    public void unlockAll(@Nullable Collection keys) throws IgniteCheckedException {
        this.delegate.get().unlockAll(this.transform(keys));
    }

    public boolean isLocked(Object key) {
        return this.delegate.get().isLocked(this.keyTransformer.transform(key));
    }

    public boolean isLockedByThread(Object key) {
        return this.delegate.get().isLockedByThread(this.keyTransformer.transform(key));
    }

    public int size() {
        return this.delegate.get().size();
    }

    public long sizeLong() {
        return this.delegate.get().sizeLong();
    }

    public int localSize(CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().localSize(peekModes);
    }

    public long localSizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().localSizeLong(peekModes);
    }

    public long localSizeLong(int partition, CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().localSizeLong(partition, peekModes);
    }

    public int size(CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().size(peekModes);
    }

    public long sizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().sizeLong(peekModes);
    }

    public long sizeLong(int partition, CachePeekMode[] peekModes) throws IgniteCheckedException {
        return this.delegate.get().sizeLong(partition, peekModes);
    }

    public IgniteInternalFuture<Integer> sizeAsync(CachePeekMode[] peekModes) {
        return this.delegate.get().sizeAsync(peekModes);
    }

    public IgniteInternalFuture<Long> sizeLongAsync(CachePeekMode[] peekModes) {
        return this.delegate.get().sizeLongAsync(peekModes);
    }

    public IgniteInternalFuture<Long> sizeLongAsync(int partition, CachePeekMode[] peekModes) {
        return this.delegate.get().sizeLongAsync(partition, peekModes);
    }

    public int nearSize() {
        return this.delegate.get().nearSize();
    }

    public int primarySize() {
        return this.delegate.get().primarySize();
    }

    public long primarySizeLong() {
        return this.delegate.get().primarySizeLong();
    }

    public CacheConfiguration configuration() {
        return this.delegate.get().configuration();
    }

    public Affinity affinity() {
        return this.delegate.get().affinity();
    }

    public CacheMetrics clusterMetrics() {
        return this.delegate.get().clusterMetrics();
    }

    public CacheMetrics clusterMetrics(ClusterGroup grp) {
        return this.delegate.get().clusterMetrics(grp);
    }

    public CacheMetrics localMetrics() {
        return this.delegate.get().localMetrics();
    }

    public CacheMetricsMXBean clusterMxBean() {
        return this.delegate.get().clusterMxBean();
    }

    public CacheMetricsMXBean localMxBean() {
        return this.delegate.get().localMxBean();
    }

    public long offHeapEntriesCount() {
        return this.delegate.get().offHeapEntriesCount();
    }

    public long offHeapAllocatedSize() {
        return this.delegate.get().offHeapAllocatedSize();
    }

    public IgniteInternalFuture<?> rebalance() {
        return this.delegate.get().rebalance();
    }

    public IgniteInternalCache forSubjectId(UUID subjId) {
        return this.delegate.get().forSubjectId(subjId);
    }

    @Nullable
    public Object getForcePrimary(Object key) throws IgniteCheckedException {
        return this.delegate.get().getForcePrimary(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture getForcePrimaryAsync(Object key) {
        return this.delegate.get().getForcePrimaryAsync(this.keyTransformer.transform(key));
    }

    public Map getAllOutTx(Set keys) throws IgniteCheckedException {
        return this.delegate.get().getAllOutTx((Set)this.transform(keys));
    }

    public IgniteInternalFuture<Map<Object, Object>> getAllOutTxAsync(Set keys) {
        return this.delegate.get().getAllOutTxAsync((Set)this.transform(keys));
    }

    @Nullable
    public ExpiryPolicy expiry() {
        return this.delegate.get().expiry();
    }

    public IgniteInternalCache withExpiryPolicy(ExpiryPolicy plc) {
        return this.delegate.get().withExpiryPolicy(plc);
    }

    public IgniteInternalCache withNoRetries() {
        return this.delegate.get().withNoRetries();
    }

    public <K1, V1> IgniteInternalCache<K1, V1> withAllowAtomicOpsInTx() {
        return this.delegate.get().withAllowAtomicOpsInTx();
    }

    public GridCacheContext context() {
        return this.delegate.get().context();
    }

    public void localLoadCache(@Nullable IgniteBiPredicate p, Object ... args) throws IgniteCheckedException {
        this.delegate.get().localLoadCache(p, args);
    }

    public IgniteInternalFuture<?> localLoadCacheAsync(@Nullable IgniteBiPredicate p, Object ... args) {
        return this.delegate.get().localLoadCacheAsync(p, args);
    }

    public Collection<Integer> lostPartitions() {
        return this.delegate.get().lostPartitions();
    }

    public void preloadPartition(int part) throws IgniteCheckedException {
        this.delegate.get().preloadPartition(part);
    }

    public IgniteInternalFuture<?> preloadPartitionAsync(int part) throws IgniteCheckedException {
        return this.delegate.get().preloadPartitionAsync(part);
    }

    public boolean localPreloadPartition(int part) throws IgniteCheckedException {
        return this.delegate.get().localPreloadPartition(part);
    }

    public int localEntrySize(Object key) throws IgniteCheckedException {
        return this.delegate.get().localEntrySize(this.keyTransformer.transform(key));
    }

    public boolean touch(Object key) {
        return this.delegate.get().touch(this.keyTransformer.transform(key));
    }

    public IgniteInternalFuture<Boolean> touchAsync(Object key) {
        return this.delegate.get().touchAsync(this.keyTransformer.transform(key));
    }

    @Nullable
    public EntryProcessorResult invoke(@Nullable AffinityTopologyVersion topVer, Object key, EntryProcessor entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.delegate.get().invoke(topVer, key, entryProcessor, args);
    }

    public IgniteInternalFuture<Map> invokeAllAsync(Map map, Object ... args) {
        return this.delegate.get().invokeAllAsync(map, args);
    }

    public Map invokeAll(Map map, Object ... args) throws IgniteCheckedException {
        return this.delegate.get().invokeAll(map, args);
    }

    public IgniteInternalFuture<Map> invokeAllAsync(Set keys, EntryProcessor entryProcessor, Object ... args) {
        return this.delegate.get().invokeAllAsync((Set)this.transform(keys), entryProcessor, args);
    }

    public Map invokeAll(Set keys, EntryProcessor entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.delegate.get().invokeAll((Set)this.transform(keys), entryProcessor, args);
    }

    public IgniteInternalFuture<EntryProcessorResult> invokeAsync(Object key, EntryProcessor entryProcessor, Object ... args) {
        return this.delegate.get().invokeAsync(this.keyTransformer.transform(key), entryProcessor, args);
    }

    @Nullable
    public EntryProcessorResult invoke(Object key, EntryProcessor entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.delegate.get().invoke(this.keyTransformer.transform(key), entryProcessor, args);
    }

    public Iterator<Cache.Entry<Object, Object>> scanIterator(boolean keepBinary, @Nullable IgniteBiPredicate p, long timeout) throws IgniteCheckedException {
        return this.delegate.get().scanIterator(keepBinary, p, timeout);
    }

    public Iterator<Cache.Entry<Object, Object>> scanIterator(boolean keepBinary, @Nullable IgniteBiPredicate p) throws IgniteCheckedException {
        return this.scanIterator(keepBinary, p, 0L);
    }

    public IgniteInternalFuture<?> removeAllConflictAsync(Map drMap) throws IgniteCheckedException {
        return this.delegate.get().removeAllConflictAsync(drMap);
    }

    public void removeAllConflict(Map drMap) throws IgniteCheckedException {
        this.delegate.get().removeAllConflictAsync(drMap);
    }

    public IgniteInternalFuture<?> putAllConflictAsync(Map drMap) throws IgniteCheckedException {
        return this.delegate.get().putAllConflictAsync(drMap);
    }

    public void putAllConflict(Map drMap) throws IgniteCheckedException {
        this.delegate.get().putAllConflict(drMap);
    }

    public IgniteInternalCache keepBinary() {
        return this.delegate.get().keepBinary();
    }

    public IgniteInternalCache cache() {
        return this.delegate.get().cache();
    }

    public Iterator iterator() {
        return this.delegate.get().iterator();
    }

    private Collection<Object> transform(Collection<Object> keys) {
        LinkedList<Object> res = new LinkedList<Object>();
        for (Object o : keys) {
            res.add(this.keyTransformer.transform(o));
        }
        return res;
    }

    private Map<Object, Object> transform(Map<Object, Object> map) {
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        Set<Map.Entry<Object, Object>> ents = map.entrySet();
        for (Map.Entry<Object, Object> e : ents) {
            res.put(this.keyTransformer.transform(e.getKey()), e.getValue());
        }
        return res;
    }
}

