/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;
import org.apache.ignite.cache.hibernate.HibernateKeyTransformer;
import org.apache.ignite.cache.hibernate.HibernateNonStrictAccessStrategy;
import org.apache.ignite.cache.hibernate.HibernateReadOnlyAccessStrategy;
import org.apache.ignite.cache.hibernate.HibernateReadWriteAccessStrategy;
import org.apache.ignite.cache.hibernate.HibernateTransactionalAccessStrategy;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.G;

public class HibernateAccessStrategyFactory {
    private final HibernateKeyTransformer keyTransformer;
    private final HibernateExceptionConverter eConverter;
    @Deprecated
    public static final String GRID_NAME_PROPERTY = "org.apache.ignite.hibernate.grid_name";
    public static final String IGNITE_INSTANCE_NAME_PROPERTY = "org.apache.ignite.hibernate.ignite_instance_name";
    public static final String REGION_CACHE_PROPERTY = "org.apache.ignite.hibernate.region_cache.";
    public static final String DFLT_ACCESS_TYPE_PROPERTY = "org.apache.ignite.hibernate.default_access_type";
    public static final String GRID_CONFIG_PROPERTY = "org.apache.ignite.hibernate.grid_config";
    public static final String VERIFY_ATOMICITY = "org.apache.ignite.hibernate.verify_atomicity";
    public static final String CACHE_PREFIX = "org.apache.ignite.hibernate.cache_prefix";
    private Ignite ignite;
    private final Map<String, String> regionCaches = new HashMap<String, String>();
    private final ThreadLocal threadLoc = new ThreadLocal();
    private final ConcurrentHashMap<String, ThreadLocal> threadLocMap = new ConcurrentHashMap();
    private String cachePrefix;
    private boolean verifyAtomicity = true;

    HibernateAccessStrategyFactory(HibernateKeyTransformer keyTransformer, HibernateExceptionConverter eConverter) {
        this(keyTransformer, eConverter, null);
    }

    public HibernateAccessStrategyFactory(HibernateKeyTransformer keyTransformer, HibernateExceptionConverter eConverter, Ignite ignite) {
        this.keyTransformer = keyTransformer;
        this.eConverter = eConverter;
        this.ignite = ignite;
    }

    public void start(Map<Object, Object> cfgValues) {
        this.cachePrefix = cfgValues.getOrDefault(CACHE_PREFIX, "").toString();
        this.verifyAtomicity = Boolean.valueOf(cfgValues.getOrDefault(VERIFY_ATOMICITY, this.verifyAtomicity).toString());
        Object igniteInstanceName = cfgValues.get(IGNITE_INSTANCE_NAME_PROPERTY);
        if (this.ignite == null) {
            Iterator<Map.Entry<Object, Object>> gridCfg = cfgValues.get(GRID_CONFIG_PROPERTY);
            if (gridCfg != null) {
                try {
                    this.ignite = G.start((String)gridCfg.toString());
                }
                catch (IgniteException e) {
                    throw this.eConverter.convert((Exception)((Object)e));
                }
            } else {
                this.ignite = Ignition.ignite((String)(igniteInstanceName == null ? null : igniteInstanceName.toString()));
            }
        }
        for (Map.Entry<Object, Object> entry : cfgValues.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(REGION_CACHE_PROPERTY)) continue;
            String regionName = key.substring(REGION_CACHE_PROPERTY.length());
            String cacheName = entry.getValue().toString();
            if (((IgniteKernal)this.ignite).getCache(this.cachePrefix + cacheName) == null) {
                throw new IllegalArgumentException("Cache '" + cacheName + "' specified for region '" + regionName + "' is not configured.");
            }
            this.regionCaches.put(regionName, cacheName);
        }
        IgniteLogger log = this.ignite.log().getLogger(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("HibernateRegionFactory started [igniteInstanceName=" + igniteInstanceName + ']');
        }
    }

    public Ignite node() {
        return this.ignite;
    }

    HibernateCacheProxy regionCache(String regionName) {
        String cacheName = this.regionCaches.get(regionName);
        if (cacheName == null) {
            cacheName = regionName;
        }
        cacheName = this.cachePrefix + cacheName;
        LazyCacheSupplier lazyCache = new LazyCacheSupplier(cacheName, regionName);
        return new HibernateCacheProxy(cacheName, lazyCache, this.keyTransformer);
    }

    HibernateAccessStrategyAdapter createReadOnlyStrategy(HibernateCacheProxy cache) {
        return new HibernateReadOnlyAccessStrategy(this.ignite, cache, this.eConverter);
    }

    HibernateAccessStrategyAdapter createNonStrictReadWriteStrategy(HibernateCacheProxy cache) {
        ThreadLocal threadLoc = this.threadLocMap.get(cache.name());
        if (threadLoc == null) {
            threadLoc = new ThreadLocal();
            ThreadLocal old = this.threadLocMap.putIfAbsent(cache.name(), threadLoc);
            if (old != null) {
                threadLoc = old;
            }
        }
        return new HibernateNonStrictAccessStrategy(this.ignite, cache, threadLoc, this.eConverter);
    }

    HibernateAccessStrategyAdapter createReadWriteStrategy(HibernateCacheProxy cache) {
        if (this.verifyAtomicity && cache.configuration().getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL) {
            throw new IllegalArgumentException("Hibernate READ-WRITE access strategy must have Ignite cache with 'TRANSACTIONAL' atomicity mode: " + cache.name());
        }
        return new HibernateReadWriteAccessStrategy(this.ignite, cache, this.threadLoc, this.eConverter);
    }

    HibernateAccessStrategyAdapter createTransactionalStrategy(HibernateCacheProxy cache) {
        if (this.verifyAtomicity) {
            if (cache.configuration().getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL) {
                throw new IllegalArgumentException("Hibernate TRANSACTIONAL access strategy must have Ignite cache with 'TRANSACTIONAL' atomicity mode: " + cache.name());
            }
            TransactionConfiguration txCfg = this.ignite.configuration().getTransactionConfiguration();
            if (txCfg == null || txCfg.getTxManagerFactory() == null && txCfg.getTxManagerLookupClassName() == null && cache.configuration().getTransactionManagerLookupClassName() == null) {
                throw new IllegalArgumentException("Hibernate TRANSACTIONAL access strategy must have Ignite with Factory<TransactionManager> configured (see IgniteConfiguration.getTransactionConfiguration().setTxManagerFactory()): " + cache.name());
            }
        }
        return new HibernateTransactionalAccessStrategy(this.ignite, cache, this.eConverter);
    }

    static /* synthetic */ Ignite access$100(HibernateAccessStrategyFactory x0) {
        return x0.ignite;
    }

    private class LazyCacheSupplier
    implements Supplier<IgniteInternalCache<Object, Object>> {
        private final AtomicReference<IgniteInternalCache<Object, Object>> reference = new AtomicReference();
        private final String cacheName;
        private final String regionName;

        private LazyCacheSupplier(String cacheName, String regionName) {
            this.cacheName = cacheName;
            this.regionName = regionName;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public IgniteInternalCache<Object, Object> get() {
            cache = this.reference.get();
            if (cache == null) {
                ignite = (IgniteKernal)HibernateAccessStrategyFactory.access$100(HibernateAccessStrategyFactory.this);
                jcache = (IgniteCacheProxy)ignite.cache(this.cacheName);
                if (jcache == null) {
                    try {
                        template = ignite.context().cache().getConfigFromTemplate(this.cacheName);
                        if (template == null) ** GOTO lbl16
                        ignite.createCache(template);
                        cache = ignite.getCache(this.cacheName);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IllegalArgumentException("Failed to get cache: " + e.getMessage(), e);
                    }
                } else {
                    cache = jcache.internalProxy();
                }
lbl16:
                // 3 sources

                if (cache == null) {
                    throw new IllegalArgumentException("Cache '" + this.cacheName + "' for region '" + this.regionName + "' is not configured.");
                }
                this.reference.compareAndSet(null, (IgniteInternalCache<Object, Object>)cache);
            }
            return cache;
        }
    }
}

