/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public abstract class HibernateAccessStrategyAdapter {
    protected final HibernateCacheProxy cache;
    private final HibernateExceptionConverter eConverter;
    protected final Ignite ignite;
    protected final IgniteLogger log;

    protected HibernateAccessStrategyAdapter(Ignite ignite, HibernateCacheProxy cache, HibernateExceptionConverter eConverter) {
        this.cache = cache;
        this.ignite = ignite;
        this.eConverter = eConverter;
        this.log = ignite.log().getLogger(this.getClass());
    }

    final RuntimeException convertException(Exception e) {
        return this.eConverter.convert(e);
    }

    @Nullable
    public Object get(Object key) {
        try {
            Object val = this.cache.get(key);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Get [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
            }
            return val;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    public void putFromLoad(Object key, Object val, boolean minimalPutOverride) {
        this.putFromLoad(key, val);
    }

    public void putFromLoad(Object key, Object val) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Put from load [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
        }
        try {
            this.cache.put(key, val);
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    public abstract void lock(Object var1);

    public abstract void unlock(Object var1);

    public abstract boolean update(Object var1, Object var2);

    public abstract boolean afterUpdate(Object var1, Object var2);

    public abstract boolean insert(Object var1, Object var2);

    public abstract boolean afterInsert(Object var1, Object var2);

    public abstract void remove(Object var1);

    public void evict(Object key) {
        HibernateAccessStrategyAdapter.evict(this.ignite, this.cache, key);
    }

    public void evictAll() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Evict all [cache=" + this.cache.name() + ']');
        }
        try {
            HibernateAccessStrategyAdapter.evictAll(this.cache);
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    public final void removeAll() {
        this.evictAll();
    }

    public void lockRegion() {
    }

    public void unlockRegion() {
    }

    public static void evict(Ignite ignite, HibernateCacheProxy cache, Object key) {
        key = cache.keyTransformer().transform(key);
        ignite.compute((ClusterGroup)ignite.cluster()).call((IgniteCallable)new ClearKeyCallable(key, cache.name()));
    }

    public static void evictAll(IgniteInternalCache<Object, Object> cache) throws IgniteCheckedException {
        cache.clear();
    }

    private static class ClearKeyCallable
    implements IgniteCallable<Void>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;
        private Object key;
        private String cacheName;

        public ClearKeyCallable() {
        }

        private ClearKeyCallable(Object key, String cacheName) {
            this.key = key;
            this.cacheName = cacheName;
        }

        public Void call() throws IgniteCheckedException {
            IgniteInternalCache cache = ((IgniteKernal)this.ignite).getCache(this.cacheName);
            assert (cache != null);
            cache.clearLocally(this.key);
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.key);
            U.writeString((DataOutput)out, (String)this.cacheName);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.key = in.readObject();
            this.cacheName = U.readString((DataInput)in);
        }
    }
}

