/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;

public class SqlTableColumnView {
    private final GridH2Table tbl;
    private final Column col;
    private final GridQueryProperty prop;
    private final IndexColumn affCol;

    public SqlTableColumnView(GridH2Table tbl, Column col) {
        this.tbl = tbl;
        this.col = col;
        this.prop = tbl.rowDescriptor().type().property(col.getName());
        this.affCol = tbl.getAffinityKeyColumn();
    }

    @Order
    public String columnName() {
        return this.col.getName();
    }

    @Order(value=2)
    public String schemaName() {
        return this.tbl.getSchema().getName();
    }

    @Order(value=1)
    public String tableName() {
        return this.tbl.identifier().table();
    }

    public Class<?> type() {
        if (this.prop == null) {
            return null;
        }
        return this.prop.type();
    }

    public String defaultValue() {
        if (this.prop == null) {
            return null;
        }
        return String.valueOf(this.prop.defaultValue());
    }

    public int precision() {
        return H2Utils.resolveDefaultPrecisionIfUndefined(this.prop);
    }

    public int scale() {
        return H2Utils.resolveDefaultScaleIfUndefined(this.prop);
    }

    public boolean nullable() {
        return this.col.isNullable();
    }

    public boolean pk() {
        return this.tbl.rowDescriptor().isKeyColumn(this.col.getColumnId());
    }

    public boolean autoIncrement() {
        return this.col.isAutoIncrement();
    }

    public boolean affinityColumn() {
        return this.affCol != null && this.col.getColumnId() == this.affCol.column.getColumnId();
    }
}

