/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.Hasher;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnOverrides;
import org.apache.ignite.internal.processors.query.stat.hll.HLL;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ColumnStatisticsCollector {
    private final Column col;
    private final HLL hll = ColumnStatisticsCollector.buildHll();
    private Value min = null;
    private Value max = null;
    private long total = 0L;
    private long size = 0L;
    private final Comparator<Value> comp;
    private long nullsCnt;
    private final boolean complexType;
    private final Hasher hash = new Hasher();
    private final long ver;

    public ColumnStatisticsCollector(Column col, Comparator<Value> comp) {
        this(col, comp, 0L);
    }

    public ColumnStatisticsCollector(Column col, Comparator<Value> comp, long ver) {
        this.col = col;
        this.comp = comp;
        this.ver = ver;
        TypeInfo colTypeInfo = col.getType();
        this.complexType = colTypeInfo == TypeInfo.TYPE_ARRAY || colTypeInfo == TypeInfo.TYPE_ENUM_UNDEFINED || colTypeInfo == TypeInfo.TYPE_JAVA_OBJECT || colTypeInfo == TypeInfo.TYPE_RESULT_SET || colTypeInfo == TypeInfo.TYPE_UNKNOWN;
    }

    private byte[] getBytes(Value val) {
        switch (val.getValueType()) {
            case 13: {
                String strVal = val.getString();
                return strVal.getBytes(StandardCharsets.UTF_8);
            }
            case 1: {
                byte[] byArray;
                if (val.getBoolean()) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray = byArray3;
                    byArray3[0] = 0;
                }
                return byArray;
            }
            case 6: 
            case 7: 
            case 8: {
                return U.join((byte[][])new byte[][]{val.getBigDecimal().unscaledValue().toByteArray(), BigInteger.valueOf(val.getBigDecimal().scale()).toByteArray()});
            }
            case 9: {
                return BigInteger.valueOf(val.getTime().getTime()).toByteArray();
            }
            case 10: {
                return BigInteger.valueOf(val.getDate().getTime()).toByteArray();
            }
            case 11: {
                return BigInteger.valueOf(val.getTimestamp().getTime()).toByteArray();
            }
        }
        return val.getBytes();
    }

    public void add(Value val) {
        ++this.total;
        if (H2Utils.isNullValue(val)) {
            ++this.nullsCnt;
            return;
        }
        byte[] bytes = this.getBytes(val);
        this.size += (long)bytes.length;
        this.hll.addRaw(this.hash.fastHash(bytes));
        if (!this.complexType) {
            if (null == this.min || this.comp.compare(val, this.min) < 0) {
                this.min = val;
            }
            if (null == this.max || this.comp.compare(val, this.max) > 0) {
                this.max = val;
            }
        }
    }

    public ColumnStatistics finish() {
        int averageSize = ColumnStatisticsCollector.averageSize(this.size, this.total, this.nullsCnt);
        return new ColumnStatistics(this.min, this.max, this.nullsCnt, this.hll.cardinality(), this.total, averageSize, this.hll.toBytes(), this.ver, U.currentTimeMillis());
    }

    private static int averageSize(long size, long total, long nullsCnt) {
        long averageSizeLong = total - nullsCnt > 0L ? size / (total - nullsCnt) : 0L;
        return averageSizeLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)averageSizeLong;
    }

    public Column col() {
        return this.col;
    }

    public static ColumnStatistics aggregate(Comparator<Value> comp, List<ColumnStatistics> partStats, StatisticsColumnOverrides overrides) {
        assert (!F.isEmpty(partStats));
        Long overrideDistinct = overrides == null ? null : overrides.distinct();
        HLL hll = ColumnStatisticsCollector.buildHll();
        Value min = null;
        Value max = null;
        long nullsCnt = 0L;
        long total = 0L;
        long totalSize = 0L;
        ColumnStatistics firstStat = (ColumnStatistics)F.first(partStats);
        long ver = firstStat.version();
        long createdAt = firstStat.createdAt();
        for (ColumnStatistics partStat : partStats) {
            assert (ver == partStat.version()) : "Aggregate statistics with different version [stats=" + partStats + ']';
            if (overrideDistinct == null) {
                HLL partHll = HLL.fromBytes(partStat.raw());
                hll.union(partHll);
            }
            total += partStat.total();
            nullsCnt += partStat.nulls();
            totalSize += (long)partStat.size() * (partStat.total() - partStat.nulls());
            if (min == null || partStat.min() != null && comp.compare(partStat.min(), min) < 0) {
                min = partStat.min();
            }
            if (max == null || partStat.max() != null && comp.compare(partStat.max(), max) > 0) {
                max = partStat.max();
            }
            if (createdAt >= partStat.createdAt()) continue;
            createdAt = partStat.createdAt();
        }
        Integer overrideSize = overrides == null ? null : overrides.size();
        int averageSize = overrideSize == null ? ColumnStatisticsCollector.averageSize(totalSize, total, nullsCnt) : overrideSize;
        long distinct = overrideDistinct == null ? hll.cardinality() : overrideDistinct.longValue();
        Long overrideNulls = overrides == null ? null : overrides.nulls();
        long nulls = overrideNulls == null ? nullsCnt : overrideNulls;
        Long overrideTotal = overrides == null ? null : overrides.total();
        total = overrideTotal == null ? total : overrideTotal;
        return new ColumnStatistics(min, max, nulls, distinct, total, averageSize, hll.toBytes(), ver, createdAt);
    }

    private static HLL buildHll() {
        return new HLL(13, 5);
    }
}

