/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

public class SqlSystemViewSchemas
extends SqlAbstractLocalSystemView {
    private final SchemaManager schemaMgr;

    public SqlSystemViewSchemas(GridKernalContext ctx, SchemaManager schemaMgr) {
        super("SCHEMAS", "Ignite SQL schemas", ctx, SqlSystemViewSchemas.newColumn("SCHEMA_NAME"));
        this.schemaMgr = schemaMgr;
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        Set<String> schemaNames = this.schemaMgr.schemaNames();
        ArrayList<Row> rows = new ArrayList<Row>(schemaNames.size());
        for (String schemaName : schemaNames) {
            rows.add(this.createRow(ses, schemaName));
        }
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.schemaMgr.schemaNames().size();
    }
}

