/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.ObjectMetric;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

public class SqlSystemViewCacheGroupsIOStatistics
extends SqlAbstractLocalSystemView {
    public SqlSystemViewCacheGroupsIOStatistics(GridKernalContext ctx) {
        super("LOCAL_CACHE_GROUPS_IO", "Local node IO statistics for cache groups", ctx, "CACHE_GROUP_NAME", SqlSystemViewCacheGroupsIOStatistics.newColumn("CACHE_GROUP_ID", 4), SqlSystemViewCacheGroupsIOStatistics.newColumn("CACHE_GROUP_NAME"), SqlSystemViewCacheGroupsIOStatistics.newColumn("PHYSICAL_READS", 5), SqlSystemViewCacheGroupsIOStatistics.newColumn("LOGICAL_READS", 5));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        SqlSystemViewColumnCondition nameCond = this.conditionForColumn("CACHE_GROUP_NAME", first, last);
        if (nameCond.isEquality()) {
            String cacheGrpName = nameCond.valueForEquality().getString();
            MetricRegistry mreg = this.ctx.metric().registry(MetricUtils.metricName((String[])new String[]{IoStatisticsType.CACHE_GROUP.metricGroupName(), cacheGrpName}));
            IntMetric grpId = (IntMetric)mreg.findMetric("grpId");
            ObjectMetric grpName = (ObjectMetric)mreg.findMetric("name");
            if (grpId == null) {
                Collections.emptyIterator();
            }
            if (mreg != null) {
                return Collections.singleton(this.toRow(ses, grpId.value(), (String)grpName.value(), mreg)).iterator();
            }
        } else {
            Collection grpCtxs = this.ctx.cache().cacheGroups();
            GridMetricManager mmgr = this.ctx.metric();
            return GridFunc.iterator((Iterable)grpCtxs, (IgniteClosure & Serializable)grpCtx -> this.toRow(ses, grpCtx.groupId(), grpCtx.cacheOrGroupName(), mmgr.registry(MetricUtils.metricName((String[])new String[]{IoStatisticsType.CACHE_GROUP.metricGroupName(), grpCtx.cacheOrGroupName()}))), (boolean)true, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)grpCtx -> !grpCtx.systemCache()});
        }
        return Collections.emptyIterator();
    }

    private Row toRow(Session ses, int grpId, String grpName, MetricRegistry mreg) {
        IntMetric grpIdMetric = (IntMetric)mreg.findMetric("grpId");
        if (grpIdMetric == null) {
            return this.createRow(ses, grpId, grpName, 0, 0);
        }
        return this.createRow(ses, grpId, grpName, ((LongMetric)mreg.findMetric("PHYSICAL_READS")).value(), ((LongMetric)mreg.findMetric("LOGICAL_READS")).value());
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.ctx.cache().cacheGroups().size();
    }
}

