/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;

public class GridSqlMerge
extends GridSqlStatement {
    private GridSqlElement into;
    private GridSqlColumn[] cols;
    private List<GridSqlElement[]> rows;
    private GridSqlQuery qry;

    @Override
    public String getSQL() {
        StringBuilder buff = new StringBuilder(this.explain() ? "EXPLAIN " : "");
        buff.append("MERGE INTO ").append(this.into.getSQL()).append("(");
        for (int i = 0; i < this.cols.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append('\n').append(this.cols[i].getSQL());
        }
        buff.append("\n)\n");
        if (!this.rows.isEmpty()) {
            buff.append("VALUES\n");
            StringBuilder valuesBuff = new StringBuilder();
            List<GridSqlElement[]> rows = this.rows();
            for (int i = 0; i < rows.size(); ++i) {
                GridSqlElement[] row = rows.get(i);
                if (i > 0) {
                    valuesBuff.append(",\n");
                }
                StringBuilder rowBuff = new StringBuilder("(");
                for (int j = 0; j < row.length; ++j) {
                    if (j > 0) {
                        rowBuff.append(", ");
                    }
                    rowBuff.append(row[j] != null ? row[j].getSQL() : "DEFAULT");
                }
                rowBuff.append(')');
                valuesBuff.append(rowBuff.toString());
            }
            buff.append(valuesBuff.toString());
        } else {
            buff.append('\n').append(this.qry.getSQL());
        }
        return buff.toString();
    }

    public GridSqlElement into() {
        return this.into;
    }

    public GridSqlMerge into(GridSqlElement from) {
        this.into = from;
        return this;
    }

    public List<GridSqlElement[]> rows() {
        return this.rows;
    }

    public GridSqlMerge rows(List<GridSqlElement[]> rows) {
        assert (rows != null);
        this.rows = rows;
        return this;
    }

    public GridSqlQuery query() {
        return this.qry;
    }

    public GridSqlMerge query(GridSqlQuery qry) {
        this.qry = qry;
        return this;
    }

    public GridSqlColumn[] columns() {
        return this.cols;
    }

    public GridSqlMerge columns(GridSqlColumn[] cols) {
        this.cols = cols;
        return this;
    }
}

