/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.dr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.TombstoneCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.dr.VisorDrPartitionCountersJob;
import org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersJobResult;
import org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersTaskArg;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VisorDrRepairPartitionCountersJob
extends VisorDrPartitionCountersJob<VisorDrRepairPartitionCountersTaskArg, Collection<VisorDrRepairPartitionCountersJobResult>> {
    private static final long serialVersionUID = 0L;
    private final Map<String, Set<Integer>> cachePartsMap;
    private final int batchSize;
    private final boolean keepBinary;
    @LoggerResource
    private IgniteLogger log;

    public VisorDrRepairPartitionCountersJob(@NotNull VisorDrRepairPartitionCountersTaskArg arg, Map<String, Set<Integer>> cachePartsMap, boolean debug) {
        super(arg, debug);
        this.cachePartsMap = cachePartsMap;
        this.keepBinary = arg.isKeepBinary();
        this.batchSize = arg.getBatchSize();
    }

    protected Collection<VisorDrRepairPartitionCountersJobResult> run(@Nullable VisorDrRepairPartitionCountersTaskArg arg) throws IgniteException {
        assert (arg != null);
        ArrayList<VisorDrRepairPartitionCountersJobResult> results = new ArrayList<VisorDrRepairPartitionCountersJobResult>();
        for (String cache : this.cachePartsMap.keySet()) {
            results.add(this.executeForCache(cache));
        }
        return results;
    }

    private VisorDrRepairPartitionCountersJobResult executeForCache(String cache) {
        Set<Integer> parts = this.cachePartsMap.get(cache);
        HashSet<Integer> affectedPartitions = new HashSet<Integer>();
        HashSet<Integer> affectedCaches = new HashSet<Integer>();
        long entriesProcessed = 0L;
        long brokenEntriesFound = 0L;
        long tombstonesCleared = 0L;
        long tombstonesFailedToClear = 0L;
        long entriesFixed = 0L;
        long entriesFailedToFix = 0L;
        long size = 0L;
        for (Integer part : parts) {
            PartitionRepairMetrics metrics = this.executeForPartition(cache, part);
            if (metrics.brokenEntriesFound > 0L) {
                affectedPartitions.add(part);
            }
            affectedCaches.addAll(metrics.affectedCaches);
            entriesProcessed += metrics.entriesProcessed;
            brokenEntriesFound += metrics.brokenEntriesFound;
            entriesFixed += metrics.entriesFixed;
            entriesFailedToFix += metrics.entriesFailedToFix;
            tombstonesCleared += metrics.tombstonesCleared;
            tombstonesFailedToClear += metrics.tombstonesFailedToClear;
            size += metrics.size;
        }
        return new VisorDrRepairPartitionCountersJobResult(cache, size, affectedCaches, affectedPartitions, entriesProcessed, brokenEntriesFound, tombstonesCleared, tombstonesFailedToClear, entriesFixed, entriesFailedToFix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartitionRepairMetrics executeForPartition(String cache, Integer part) {
        CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(CU.cacheId((String)cache));
        GridDhtLocalPartition locPart = this.reservePartition(part, grpCtx, cache);
        PartitionRepairMetrics metrics = new PartitionRepairMetrics();
        metrics.size = locPart.fullSize();
        try {
            try {
                HashSet<Long> counters = new HashSet<Long>();
                ArrayList<GridCacheEntryInfo> batch = new ArrayList<GridCacheEntryInfo>(100);
                GridIterator iter = grpCtx.offheap().partitionIterator(part.intValue(), 3);
                while (iter.hasNext()) {
                    this.fillBatch(metrics, grpCtx.shared(), (GridIterator<CacheDataRow>)iter, batch, counters);
                    this.repairEntries(metrics, grpCtx, batch, part);
                    batch.clear();
                }
            }
            finally {
                locPart.release();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBatch(PartitionRepairMetrics metrics, GridCacheSharedContext ctx, GridIterator<CacheDataRow> iter, ArrayList<GridCacheEntryInfo> batch, Set<Long> counters) {
        while (iter.hasNext() && batch.size() < this.batchSize) {
            ctx.database().checkpointReadLock();
            try {
                int cnt = this.batchSize;
                while (iter.hasNext() && cnt-- > 0) {
                    CacheDataRow row = (CacheDataRow)iter.next();
                    ++metrics.entriesProcessed;
                    if (counters.add(row.version().updateCounter())) continue;
                    metrics.affectedCaches.add(row.cacheId());
                    ++metrics.brokenEntriesFound;
                    batch.add(this.extractEntryInfo(row));
                }
            }
            finally {
                ctx.database().checkpointReadUnlock();
            }
        }
    }

    private GridCacheEntryInfo extractEntryInfo(CacheDataRow row) {
        GridCacheEntryInfo info = new GridCacheEntryInfo();
        info.key(row.key());
        info.cacheId(row.cacheId());
        info.setDeleted(row.value() == TombstoneCacheObject.INSTANCE);
        info.value(row.value());
        info.version(row.version());
        info.expireTime(row.expireTime());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairEntries(PartitionRepairMetrics metrics, CacheGroupContext grp, List<GridCacheEntryInfo> infos, int part) throws IgniteCheckedException {
        if (infos.isEmpty()) {
            return;
        }
        grp.shared().database().checkpointReadLock();
        try {
            GridCacheAdapter cache = grp.sharedGroup() ? null : grp.shared().cache().context().cacheContext(grp.groupId()).cache();
            for (GridCacheEntryInfo info : infos) {
                GridDhtCacheEntry entry;
                if (cache == null || grp.sharedGroup() && cache.context().cacheId() != info.cacheId()) {
                    GridCacheContext cctx = grp.shared().cacheContext(info.cacheId());
                    if (cctx == null) {
                        ++metrics.entriesFailedToFix;
                        this.log.warning("Failed to fix entry (cache has gone?): cacheId=" + info.cacheId() + ", part=" + part + ", key=" + info.key());
                        continue;
                    }
                    cache = cctx.cache();
                }
                if ((entry = (GridDhtCacheEntry)cache.entryEx(info.key())) == null) {
                    this.log.warning("Failed to fix entry (concurrently removed?): cacheName=" + cache.name() + ", part=" + part + ", key=" + info.key());
                    continue;
                }
                if (info.isDeleted()) {
                    if (entry.clearInternal(info.version())) {
                        ++metrics.tombstonesCleared;
                        continue;
                    }
                    ++metrics.tombstonesFailedToClear;
                    this.log.warning("Failed to cleanup tombstone (concurrently removed?): cacheName=" + cache.name() + ", part=" + part + ", key=" + info.key());
                    continue;
                }
                KeyCacheObject key = entry.key();
                Object val = this.keepBinaryIfNeeded((GridCacheAdapter<Object, Object>)cache).get((Object)key);
                if (val == null) {
                    ++metrics.entriesFailedToFix;
                    this.log.warning("Failed to fix entry (concurrently removed?): cacheName=" + cache.name() + ", part=" + part + ", key=" + info.key());
                    continue;
                }
                this.keepBinaryIfNeeded((GridCacheAdapter<Object, Object>)cache).replace((Object)key, val, val);
                ++metrics.entriesFixed;
            }
        }
        finally {
            grp.shared().database().checkpointReadUnlock();
        }
    }

    @NotNull
    private IgniteInternalCache<Object, Object> keepBinaryIfNeeded(GridCacheAdapter<Object, Object> cache) {
        return this.keepBinary ? cache.keepBinary() : cache;
    }

    public String toString() {
        return S.toString(VisorDrRepairPartitionCountersJob.class, (Object)((Object)this));
    }

    private static class PartitionRepairMetrics {
        public long brokenEntriesFound;
        public long tombstonesCleared;
        public long tombstonesFailedToClear;
        public long entriesFixed;
        public long entriesFailedToFix;
        public long entriesProcessed;
        public long size;
        public Set<Integer> affectedCaches = new HashSet<Integer>();

        private PartitionRepairMetrics() {
        }
    }
}

