/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.dml.DmlArgument;
import org.apache.ignite.internal.processors.query.h2.dml.DmlArguments;
import org.apache.ignite.internal.processors.query.h2.dml.DmlAstUtils;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedPlanInfo;
import org.apache.ignite.internal.processors.query.h2.dml.FastUpdate;
import org.apache.ignite.internal.processors.query.h2.dml.KeyValueSupplier;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlMerge;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.internal.h2.table.Column;

public final class UpdatePlanBuilder {
    private static final IgniteClosure<GridSqlColumn, Column> TO_H2_COL = GridSqlColumn::column;
    private static boolean ALLOW_KEY_VAL_UPDATES = IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_ALLOW_KEY_VAL_UPDATES", (boolean)false);

    private UpdatePlanBuilder() {
    }

    public static UpdatePlan planForStatement(QueryDescriptor planKey, GridSqlStatement stmt, boolean mvccEnabled, IgniteH2Indexing idx, IgniteLogger log, boolean forceFillAbsentPKsWithDefaults) throws IgniteCheckedException {
        if (stmt instanceof GridSqlMerge || stmt instanceof GridSqlInsert) {
            return UpdatePlanBuilder.planForInsert(planKey, stmt, idx, mvccEnabled, log, forceFillAbsentPKsWithDefaults);
        }
        if (stmt instanceof GridSqlUpdate || stmt instanceof GridSqlDelete) {
            return UpdatePlanBuilder.planForUpdate(planKey, stmt, idx, mvccEnabled, log);
        }
        throw new IgniteSQLException("Unsupported operation: " + stmt.getSQL(), 1002);
    }

    private static UpdatePlan planForInsert(QueryDescriptor planKey, GridSqlStatement stmt, IgniteH2Indexing idx, boolean mvccEnabled, IgniteLogger log, boolean forceFillAbsentPKsWithDefaults) throws IgniteCheckedException {
        boolean fillAbsentPKsWithNullsOrDefaults;
        int rowsNum;
        boolean isTwoStepSubqry;
        GridSqlColumn[] cols;
        GridH2RowDescriptor desc;
        GridSqlTable tbl;
        GridSqlElement target;
        UpdateMode mode;
        GridSqlQuery sel = null;
        List<GridSqlElement[]> elRows = null;
        if (stmt instanceof GridSqlInsert) {
            mode = UpdateMode.INSERT;
            GridSqlInsert ins = (GridSqlInsert)stmt;
            target = ins.into();
            tbl = DmlAstUtils.gridTableForElement(target);
            GridH2Table h2Tbl = tbl.dataTable();
            assert (h2Tbl != null);
            desc = h2Tbl.rowDescriptor();
            cols = ins.columns();
            if (UpdatePlanBuilder.noQuery(ins.rows())) {
                elRows = ins.rows();
            } else {
                sel = DmlAstUtils.selectForInsertOrMerge(cols, ins.rows(), ins.query());
            }
            isTwoStepSubqry = ins.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : ins.rows().size();
        } else if (stmt instanceof GridSqlMerge) {
            mode = UpdateMode.MERGE;
            GridSqlMerge merge = (GridSqlMerge)stmt;
            target = merge.into();
            tbl = DmlAstUtils.gridTableForElement(target);
            desc = tbl.dataTable().rowDescriptor();
            cols = merge.columns();
            if (UpdatePlanBuilder.noQuery(merge.rows())) {
                elRows = merge.rows();
            } else {
                sel = DmlAstUtils.selectForInsertOrMerge(cols, merge.rows(), merge.query());
            }
            isTwoStepSubqry = merge.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : merge.rows().size();
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        isTwoStepSubqry &= sel != null && (sel instanceof GridSqlUnion || sel instanceof GridSqlSelect && ((GridSqlSelect)sel).from() != null);
        int keyColIdx = -1;
        int valColIdx = -1;
        boolean hasKeyProps = false;
        boolean hasValProps = false;
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + tbl.dataTable().getName() + "'", 3002);
        }
        GridCacheContext<?, ?> cctx = desc.context();
        String[] colNames = new String[cols.length];
        int[] colTypes = new int[cols.length];
        GridQueryTypeDescriptor type = desc.type();
        Set<String> rowKeys = desc.getRowKeyColumnNames();
        boolean onlyVisibleColumns = true;
        for (int i = 0; i < cols.length; ++i) {
            String colName;
            GridSqlColumn col = cols[i];
            if (!col.column().getVisible()) {
                onlyVisibleColumns = false;
            }
            colNames[i] = colName = col.columnName();
            colTypes[i] = col.resultType().type();
            rowKeys.remove(colName);
            int colId = col.column().getColumnId();
            if (desc.isKeyColumn(colId)) {
                keyColIdx = i;
                continue;
            }
            if (desc.isValueColumn(colId)) {
                valColIdx = i;
                continue;
            }
            GridQueryProperty prop = desc.type().property(colName);
            assert (prop != null) : "Property '" + colName + "' not found.";
            if (prop.key()) {
                hasKeyProps = true;
                continue;
            }
            hasValProps = true;
        }
        rowKeys.removeIf(rowKey -> desc.type().property(rowKey).defaultValue() != null);
        boolean bl = fillAbsentPKsWithNullsOrDefaults = type.fillAbsentPKsWithDefaults() || forceFillAbsentPKsWithDefaults;
        if (fillAbsentPKsWithNullsOrDefaults && onlyVisibleColumns && !rowKeys.isEmpty()) {
            String[] extendedColNames = new String[rowKeys.size() + colNames.length];
            int[] extendedColTypes = new int[rowKeys.size() + colTypes.length];
            System.arraycopy(colNames, 0, extendedColNames, 0, colNames.length);
            System.arraycopy(colTypes, 0, extendedColTypes, 0, colTypes.length);
            int currId = colNames.length;
            for (String key : rowKeys) {
                Column col = tbl.dataTable().getColumn(key);
                extendedColNames[currId] = col.getName();
                extendedColTypes[currId] = col.getType().getValueType();
                ++currId;
            }
            colNames = extendedColNames;
            colTypes = extendedColTypes;
        }
        UpdatePlanBuilder.verifyDmlColumns(tbl.dataTable(), F.viewReadOnly(Arrays.asList(cols), TO_H2_COL, (IgnitePredicate[])new IgnitePredicate[0]));
        KeyValueSupplier keySupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), keyColIdx, hasKeyProps, true, false);
        KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), valColIdx, hasValProps, false, false);
        String selectSql = sel != null ? sel.getSQL() : null;
        DmlDistributedPlanInfo distributed = null;
        if (rowsNum == 0 && !F.isEmpty((String)selectSql)) {
            distributed = UpdatePlanBuilder.checkPlanCanBeDistributed(idx, mvccEnabled, planKey, selectSql, tbl.dataTable().cacheName(), log);
        }
        ArrayList<List<DmlArgument>> rows = null;
        if (elRows != null) {
            assert (sel == null);
            rows = new ArrayList<List<DmlArgument>>(elRows.size());
            for (GridSqlElement[] elRow : elRows) {
                ArrayList<DmlArgument> row = new ArrayList<DmlArgument>(cols.length);
                for (GridSqlElement el : elRow) {
                    DmlArgument arg = DmlArguments.create(el);
                    row.add(arg);
                }
                rows.add(row);
            }
        }
        return new UpdatePlan(mode, tbl.dataTable(), colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, selectSql, !isTwoStepSubqry, rows, rowsNum, null, distributed, false, fillAbsentPKsWithNullsOrDefaults);
    }

    private static boolean noQuery(List<GridSqlElement[]> rows) {
        if (F.isEmpty(rows)) {
            return false;
        }
        boolean noQry = true;
        for (int i = 0; i < rows.size(); ++i) {
            GridSqlElement[] row = rows.get(i);
            for (int i1 = 0; i1 < row.length; ++i1) {
                GridSqlElement el = row[i1];
                if (noQry &= el instanceof GridSqlConst || el instanceof GridSqlParameter) continue;
                return noQry;
            }
        }
        return true;
    }

    private static UpdatePlan planForUpdate(QueryDescriptor planKey, GridSqlStatement stmt, IgniteH2Indexing idx, boolean mvccEnabled, IgniteLogger log) throws IgniteCheckedException {
        UpdateMode mode;
        FastUpdate fastUpdate;
        GridSqlElement target;
        if (stmt instanceof GridSqlUpdate) {
            UpdatePlanBuilder.verifyUpdateColumns(stmt);
            GridSqlUpdate update = (GridSqlUpdate)stmt;
            target = update.target();
            fastUpdate = DmlAstUtils.getFastUpdateArgs(update);
            mode = UpdateMode.UPDATE;
        } else if (stmt instanceof GridSqlDelete) {
            GridSqlDelete del = (GridSqlDelete)stmt;
            target = del.from();
            fastUpdate = DmlAstUtils.getFastDeleteArgs(del);
            mode = UpdateMode.DELETE;
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        GridSqlTable tbl = DmlAstUtils.gridTableForElement(target);
        GridH2Table h2Tbl = tbl.dataTable();
        assert (h2Tbl != null);
        GridH2RowDescriptor desc = h2Tbl.rowDescriptor();
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + h2Tbl.getName() + "'", 3002);
        }
        if (fastUpdate != null) {
            return new UpdatePlan(mode, h2Tbl, null, fastUpdate, null);
        }
        if (stmt instanceof GridSqlUpdate) {
            boolean hasProps;
            ArrayList<GridSqlColumn> updatedCols = ((GridSqlUpdate)stmt).cols();
            int valColIdx = -1;
            String[] colNames = new String[updatedCols.size()];
            int[] colTypes = new int[updatedCols.size()];
            for (int i = 0; i < updatedCols.size(); ++i) {
                colNames[i] = ((GridSqlColumn)updatedCols.get(i)).columnName();
                colTypes[i] = ((GridSqlColumn)updatedCols.get(i)).resultType().type();
                Column col = ((GridSqlColumn)updatedCols.get(i)).column();
                if (!desc.isValueColumn(col.getColumnId())) continue;
                valColIdx = i;
            }
            boolean hasNewVal = valColIdx != -1;
            boolean bl = hasProps = !hasNewVal || updatedCols.size() > 1;
            if (hasNewVal) {
                valColIdx += 2;
            }
            int newValColIdx = hasNewVal ? valColIdx : 1;
            KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(desc.context(), desc.type(), newValColIdx, hasProps, false, true);
            GridSqlSelect sel = DmlAstUtils.selectForUpdate((GridSqlUpdate)stmt);
            String selectSql = sel.getSQL();
            DmlDistributedPlanInfo distributed = null;
            if (!F.isEmpty((String)selectSql)) {
                distributed = UpdatePlanBuilder.checkPlanCanBeDistributed(idx, mvccEnabled, planKey, selectSql, tbl.dataTable().cacheName(), log);
            }
            return new UpdatePlan(UpdateMode.UPDATE, h2Tbl, colNames, colTypes, null, valSupplier, -1, valColIdx, selectSql, false, null, 0, null, distributed, sel.canBeLazy(), false);
        }
        GridSqlSelect sel = DmlAstUtils.selectForDelete((GridSqlDelete)stmt);
        String selectSql = sel.getSQL();
        DmlDistributedPlanInfo distributed = null;
        if (!F.isEmpty((String)selectSql)) {
            distributed = UpdatePlanBuilder.checkPlanCanBeDistributed(idx, mvccEnabled, planKey, selectSql, tbl.dataTable().cacheName(), log);
        }
        return new UpdatePlan(UpdateMode.DELETE, h2Tbl, selectSql, null, distributed);
    }

    public static UpdatePlan planForBulkLoad(List<String> cols, GridH2Table tbl) throws IgniteCheckedException {
        GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + tbl.getName() + "'", 3002);
        }
        GridCacheContext<?, ?> cctx = desc.context();
        if (cols == null) {
            throw new IgniteSQLException("Columns are not defined", 3002);
        }
        String[] colNames = new String[cols.size()];
        Column[] h2Cols = new Column[cols.size()];
        int[] colTypes = new int[cols.size()];
        int keyColIdx = -1;
        int valColIdx = -1;
        boolean hasKeyProps = false;
        boolean hasValProps = false;
        for (int i = 0; i < cols.size(); ++i) {
            Column h2Col;
            String colName;
            colNames[i] = colName = cols.get(i);
            h2Cols[i] = h2Col = tbl.getColumn(colName);
            colTypes[i] = h2Col.getType().getValueType();
            int colId = h2Col.getColumnId();
            if (desc.isKeyColumn(colId)) {
                keyColIdx = i;
                continue;
            }
            if (desc.isValueColumn(colId)) {
                valColIdx = i;
                continue;
            }
            GridQueryProperty prop = desc.type().property(colName);
            assert (prop != null) : "Property '" + colName + "' not found.";
            if (prop.key()) {
                hasKeyProps = true;
                continue;
            }
            hasValProps = true;
        }
        UpdatePlanBuilder.verifyDmlColumns(tbl, Arrays.asList(h2Cols));
        KeyValueSupplier keySupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), keyColIdx, hasKeyProps, true, false);
        KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), valColIdx, hasValProps, false, false);
        return new UpdatePlan(UpdateMode.BULK_LOAD, tbl, colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, null, true, null, 0, null, null, true, false);
    }

    private static KeyValueSupplier createSupplier(final GridCacheContext<?, ?> cctx, GridQueryTypeDescriptor desc, final int colIdx, boolean hasProps, final boolean key, boolean forUpdate) throws IgniteCheckedException {
        Constructor ctor;
        final String typeName = key ? desc.keyTypeName() : desc.valueTypeName();
        final Class cls = key ? (Class)U.firstNotNull((Object[])new Class[]{U.classForName((String)desc.keyTypeName(), null), desc.keyClass()}) : desc.valueClass();
        boolean isSqlType = QueryUtils.isSqlType((Class)cls);
        if (key && desc.implicitPk()) {
            return arg -> UUID.randomUUID();
        }
        if (isSqlType || !hasProps) {
            if (colIdx != -1) {
                return new PlainValueSupplier(colIdx);
            }
            if (isSqlType) {
                throw new IgniteCheckedException((key ? "Key" : "Value") + " is missing from query");
            }
        }
        if (cctx.binaryMarshaller()) {
            if (colIdx != -1) {
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) {
                        Object obj = arg.get(colIdx);
                        if (obj == null) {
                            return null;
                        }
                        BinaryObject bin = (BinaryObject)cctx.grid().binary().toBinary(obj);
                        BinaryObjectBuilder builder = cctx.grid().binary().builder(bin);
                        cctx.prepareAffinityField(builder);
                        return builder;
                    }
                };
            }
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) {
                    BinaryObjectBuilder builder = cctx.grid().binary().builder(typeName);
                    cctx.prepareAffinityField(builder);
                    return builder;
                }
            };
        }
        if (colIdx != -1) {
            if (forUpdate && colIdx == 1) {
                assert (!key);
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) throws IgniteCheckedException {
                        byte[] oldPropBytes = cctx.marshaller().marshal(arg.get(1));
                        return cctx.marshaller().unmarshal(oldPropBytes, U.resolveClassLoader((IgniteConfiguration)cctx.gridConfig()));
                    }
                };
            }
            return new PlainValueSupplier(colIdx);
        }
        try {
            ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ignored) {
            ctor = null;
        }
        if (ctor != null) {
            final Constructor ctor0 = ctor;
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) throws IgniteCheckedException {
                    try {
                        return ctor0.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        if (S.includeSensitive()) {
                            throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + " [type=" + typeName + ']', (Throwable)e);
                        }
                        throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + '.', (Throwable)e);
                    }
                }
            };
        }
        return new KeyValueSupplier(){

            public Object apply(List<?> arg) throws IgniteCheckedException {
                try {
                    return GridUnsafe.allocateInstance((Class)cls);
                }
                catch (InstantiationException e) {
                    if (S.includeSensitive()) {
                        throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + " [type=" + typeName + ']', (Throwable)e);
                    }
                    throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + '.', (Throwable)e);
                }
            }
        };
    }

    private static void verifyUpdateColumns(GridSqlStatement statement) {
        if (!(statement instanceof GridSqlUpdate)) {
            return;
        }
        GridSqlUpdate update = (GridSqlUpdate)statement;
        GridSqlElement updTarget = update.target();
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(updTarget, tbls);
        if (tbls.size() != 1) {
            throw new IgniteSQLException("Failed to determine target table for UPDATE", 3001);
        }
        GridSqlTable tbl = (GridSqlTable)tbls.iterator().next();
        GridH2Table gridTbl = tbl.dataTable();
        if (gridTbl != null && UpdatePlanBuilder.updateAffectsKeyColumns(gridTbl, update.set().keySet())) {
            throw new IgniteSQLException("SQL UPDATE can't modify key or its fields directly", 2003);
        }
        if (gridTbl != null) {
            UpdatePlanBuilder.verifyDmlColumns(gridTbl, F.viewReadOnly(update.cols(), TO_H2_COL, (IgnitePredicate[])new IgnitePredicate[0]));
        }
    }

    private static boolean updateAffectsKeyColumns(GridH2Table gridTbl, Set<String> affectedColNames) {
        GridH2RowDescriptor desc = gridTbl.rowDescriptor();
        for (String colName : affectedColNames) {
            int colId = gridTbl.getColumn(colName).getColumnId();
            if (desc.isKeyColumn(colId)) {
                return true;
            }
            if (colId < 2 || !desc.isColumnKeyProperty(colId - 2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void verifyDmlColumns(GridH2Table tab, Collection<Column> affectedCols) {
        GridH2RowDescriptor desc = tab.rowDescriptor();
        String keyColName = null;
        String valColName = null;
        boolean hasKeyProps = false;
        boolean hasValProps = false;
        for (Column col : affectedCols) {
            boolean hasEntireValcol;
            int colId = col.getColumnId();
            if (desc.isKeyColumn(colId)) {
                if (keyColName != null) throw new IgniteSQLException("Columns " + keyColName + " and " + col + " both refer to entire cache key object.", 1001);
                keyColName = col.getName();
            } else if (desc.isValueColumn(colId)) {
                if (valColName != null) throw new IgniteSQLException("Columns " + valColName + " and " + col + " both refer to entire cache value object.", 1001);
                valColName = col.getName();
            } else {
                assert (colId >= 2) : "Unexpected column [name=" + col + ", id=" + colId + "].";
                if (desc.isColumnKeyProperty(colId - 2)) {
                    hasKeyProps = true;
                } else {
                    hasValProps = true;
                }
            }
            boolean hasEntireKeyCol = keyColName != null;
            boolean bl = hasEntireValcol = valColName != null;
            if (hasEntireKeyCol && hasKeyProps) {
                throw new IgniteSQLException("Column " + keyColName + " refers to entire key cache object. It must not be mixed with other columns that refer to parts of key.", 1001);
            }
            if (hasEntireValcol && hasValProps) {
                throw new IgniteSQLException("Column " + valColName + " refers to entire value cache object. It must not be mixed with other columns that refer to parts of value.", 1001);
            }
            if (ALLOW_KEY_VAL_UPDATES) continue;
            if (desc.isKeyColumn(colId) && !QueryUtils.isSqlType((Class)desc.type().keyClass())) {
                throw new IgniteSQLException("Update of composite key column is not supported", 1002);
            }
            if (!desc.isValueColumn(colId) || QueryUtils.isSqlType((Class)desc.type().valueClass())) continue;
            throw new IgniteSQLException("Update of composite value column is not supported", 1002);
        }
    }

    /*
     * Exception decompiling
     */
    private static DmlDistributedPlanInfo checkPlanCanBeDistributed(IgniteH2Indexing idx, boolean mvccEnabled, QueryDescriptor planKey, String selectQry, String cacheName, IgniteLogger log) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class PlainValueSupplier
    implements KeyValueSupplier {
        private final int colIdx;

        private PlainValueSupplier(int colIdx) {
            this.colIdx = colIdx;
        }

        public Object apply(List<?> arg) {
            return arg.get(this.colIdx);
        }
    }
}

