/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlCacheException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.QueryParserCacheEntry;
import org.apache.ignite.internal.processors.query.h2.QueryParserMetricsHolder;
import org.apache.ignite.internal.processors.query.h2.QueryParserResult;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultCommand;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultDml;
import org.apache.ignite.internal.processors.query.h2.dml.DmlAstUtils;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParser;
import org.apache.ignite.internal.sql.SqlStrictParseException;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlAnalyzeCommand;
import org.apache.ignite.internal.sql.command.SqlBeginTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropStatisticsCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlKillContinuousQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.sql.command.SqlRefreshStatitsicsCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.internal.h2.command.Prepared;
import org.jetbrains.annotations.Nullable;

public class QueryParser {
    private static final int CACHE_SIZE = 1024;
    private static final Pattern INTERNAL_CMD_RE = Pattern.compile("^(create|drop)\\s+index|^analyze\\s|^refresh\\sstatistics|^drop\\sstatistics|^alter\\s+table|^copy|^set|^begin|^commit|^rollback|^(create|alter|drop)\\s+user|^kill\\s+(query|continuous)|show|help|grant|revoke", 2);
    private final IgniteH2Indexing idx;
    private final ConnectionManager connMgr;
    private final IgniteLogger log;
    private final QueryParserMetricsHolder metricsHolder;
    private final boolean forceFillAbsentPKsWithDefaults;
    private volatile GridBoundedConcurrentLinkedHashMap<QueryDescriptor, QueryParserCacheEntry> cache = new GridBoundedConcurrentLinkedHashMap(1024);

    public QueryParser(IgniteH2Indexing idx, ConnectionManager connMgr) {
        this.idx = idx;
        this.connMgr = connMgr;
        this.log = idx.kernalContext().log(QueryParser.class);
        this.metricsHolder = new QueryParserMetricsHolder(idx.kernalContext().metric());
        this.forceFillAbsentPKsWithDefaults = IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_FILL_ABSENT_PK_WITH_DEFAULTS", (boolean)false);
    }

    public QueryParserResult parse(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.idx.kernalContext().tracing().create(SpanType.SQL_QRY_PARSE, MTC.span()));){
            QueryParserResult res = this.parse0(schemaName, qry, remainingAllowed);
            QueryParser.checkQueryType(qry, res.isSelect());
            QueryParserResult queryParserResult = res;
            return queryParserResult;
        }
    }

    public QueryParameters queryParameters(SqlFieldsQuery qry) {
        int timeout;
        NestedTxMode nestedTxMode = NestedTxMode.DEFAULT;
        boolean autoCommit = true;
        List batchedArgs = null;
        long maxMem = 0L;
        if (qry instanceof SqlFieldsQueryEx) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)qry;
            if (qry0.getNestedTxMode() != null) {
                nestedTxMode = qry0.getNestedTxMode();
            }
            autoCommit = qry0.isAutoCommit();
            batchedArgs = qry0.batchedArguments();
            maxMem = qry0.getMaxMemory();
        }
        if ((timeout = qry.getTimeout()) < 0) {
            timeout = this.idx.distributedConfiguration().defaultQueryTimeout();
        }
        return new QueryParameters(qry.getArgs(), qry.getPartitions(), timeout, qry.isLazy(), qry.getPageSize(), maxMem, null, nestedTxMode, autoCommit, batchedArgs, qry.getUpdateBatchSize());
    }

    private QueryParserResult parse0(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        QueryDescriptor qryDesc = QueryParser.queryDescriptor(schemaName, qry);
        QueryParserCacheEntry cached = (QueryParserCacheEntry)this.cache.get((Object)qryDesc);
        if (cached != null) {
            this.metricsHolder.countCacheHit();
            MTC.span().addTag("sql.parser.cache.hit", () -> "true");
            return new QueryParserResult(qryDesc, this.queryParameters(qry), null, cached.parametersMeta(), cached.select(), cached.dml(), cached.command());
        }
        this.metricsHolder.countCacheMiss();
        MTC.span().addTag("sql.parser.cache.hit", () -> "false");
        QueryParserResult parseRes = this.parseNative(schemaName, qry, remainingAllowed);
        if (parseRes == null) {
            parseRes = this.parseH2(schemaName, qry, qryDesc.batched(), remainingAllowed);
        }
        if (parseRes.remainingQuery() == null) {
            cached = new QueryParserCacheEntry(parseRes.parametersMeta(), parseRes.select(), parseRes.dml(), parseRes.command());
            this.cache.put((Object)qryDesc, (Object)cached);
        }
        return parseRes;
    }

    @Nullable
    private QueryParserResult parseNative(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        String sql = qry.getSql();
        if (!INTERNAL_CMD_RE.matcher(sql.trim()).find()) {
            return null;
        }
        try {
            SqlParser parser = new SqlParser(schemaName, sql);
            SqlCommand nativeCmd = parser.nextCommand();
            assert (nativeCmd != null) : "Empty query. Parser met end of data";
            if (!(nativeCmd instanceof SqlCreateIndexCommand || nativeCmd instanceof SqlDropIndexCommand || nativeCmd instanceof SqlBeginTransactionCommand || nativeCmd instanceof SqlCommitTransactionCommand || nativeCmd instanceof SqlRollbackTransactionCommand || nativeCmd instanceof SqlBulkLoadCommand || nativeCmd instanceof SqlAlterTableCommand || nativeCmd instanceof SqlSetStreamingCommand || nativeCmd instanceof SqlCreateUserCommand || nativeCmd instanceof SqlAlterUserCommand || nativeCmd instanceof SqlDropUserCommand || nativeCmd instanceof SqlKillQueryCommand || nativeCmd instanceof SqlAnalyzeCommand || nativeCmd instanceof SqlRefreshStatitsicsCommand || nativeCmd instanceof SqlDropStatisticsCommand || nativeCmd instanceof SqlKillContinuousQueryCommand)) {
                return null;
            }
            SqlFieldsQuery newQry = QueryParser.cloneFieldsQuery(qry).setSql(parser.lastCommandSql());
            QueryDescriptor newPlanKey = QueryParser.queryDescriptor(schemaName, newQry);
            SqlFieldsQuery remainingQry = null;
            if (!F.isEmpty((String)parser.remainingSql())) {
                QueryParser.checkRemainingAllowed(remainingAllowed);
                remainingQry = QueryParser.cloneFieldsQuery(qry).setSql(parser.remainingSql()).setArgs(qry.getArgs());
            }
            QueryParserResultCommand cmd = new QueryParserResultCommand(nativeCmd, null, false);
            return new QueryParserResult(newPlanKey, this.queryParameters(newQry), remainingQry, Collections.emptyList(), null, null, cmd);
        }
        catch (SqlStrictParseException e) {
            throw new IgniteSQLException(e.getMessage(), e.errorCode(), (Throwable)e);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to parse SQL with native parser [qry=" + sql + ", err=" + e + ']');
            }
            if (!IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK")) {
                return null;
            }
            int code = 1001;
            if (e instanceof SqlParseException) {
                code = ((SqlParseException)e).code();
            }
            throw new IgniteSQLException("Failed to parse DDL statement: " + sql + ": " + e.getMessage(), code, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private QueryParserResult parseH2(String schemaName, SqlFieldsQuery qry, boolean batched, boolean remainingAllowed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 44[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkRemainingAllowed(boolean allowed) {
        if (allowed) {
            return;
        }
        throw new IgniteSQLException("Multiple statements queries are not supported.", 1002);
    }

    private Integer mvccCacheIdForSelect(Map<Object, Object> objMap) {
        Boolean mvccEnabled = null;
        Integer mvccCacheId = null;
        GridCacheContextInfo cctx = null;
        for (Object o : objMap.values()) {
            boolean curMvccEnabled;
            GridSqlTable tbl;
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable) || ((GridSqlTable)o).dataTable() == null || (tbl = (GridSqlTable)o).dataTable() == null) continue;
            GridCacheContextInfo curCctx = tbl.dataTable().cacheInfo();
            assert (curCctx != null);
            boolean bl = curMvccEnabled = curCctx.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
            if (mvccEnabled == null) {
                mvccEnabled = curMvccEnabled;
                if (mvccEnabled.booleanValue()) {
                    mvccCacheId = curCctx.cacheId();
                }
                cctx = curCctx;
                continue;
            }
            if (mvccEnabled == curMvccEnabled) continue;
            MvccUtils.throwAtomicityModesMismatchException((CacheConfiguration)cctx.config(), (CacheConfiguration)curCctx.config());
        }
        return mvccCacheId;
    }

    private QueryParserResultDml prepareDmlStatement(QueryDescriptor planKey, Prepared prepared) {
        UpdatePlan plan;
        if (F.eq((Object)QueryUtils.sysSchemaName(), (Object)planKey.schemaName())) {
            throw new IgniteSQLException("DML statements are not supported on " + planKey.schemaName() + " schema", 1002);
        }
        GridSqlQueryParser parser = new GridSqlQueryParser(false, this.log);
        GridSqlStatement stmt = parser.parse(prepared);
        List<GridH2Table> tbls = parser.tablesForDml();
        for (GridH2Table h2tbl : tbls) {
            H2Utils.checkAndStartNotStartedCache(this.idx.kernalContext(), h2tbl);
        }
        GridCacheContextInfo ctx = null;
        boolean mvccEnabled = false;
        for (GridH2Table h2tbl : tbls) {
            boolean curMvccEnabled;
            GridCacheContextInfo curCtx = h2tbl.cacheInfo();
            boolean bl = curMvccEnabled = curCtx.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
            if (ctx == null) {
                ctx = curCtx;
                mvccEnabled = curMvccEnabled;
                continue;
            }
            if (curMvccEnabled == mvccEnabled) continue;
            MvccUtils.throwAtomicityModesMismatchException((CacheConfiguration)ctx.config(), (CacheConfiguration)curCtx.config());
        }
        GridH2Table streamTbl = null;
        if (GridSqlQueryParser.isStreamableInsertStatement(prepared)) {
            GridSqlInsert insert = (GridSqlInsert)stmt;
            streamTbl = DmlAstUtils.gridTableForElement(insert.into()).dataTable();
        }
        try {
            plan = UpdatePlanBuilder.planForStatement(planKey, stmt, mvccEnabled, this.idx, this.log, this.forceFillAbsentPKsWithDefaults);
        }
        catch (Exception e) {
            if (e instanceof IgniteSQLException) {
                throw (IgniteSQLException)((Object)e);
            }
            if (e instanceof SqlCacheException) {
                throw (SqlCacheException)e;
            }
            throw new IgniteSQLException("Failed to prepare update plan.", (Throwable)e);
        }
        return new QueryParserResultDml(stmt, mvccEnabled, streamTbl, plan);
    }

    public void clearCache() {
        this.cache = new GridBoundedConcurrentLinkedHashMap(1024);
    }

    private static void checkQueryType(SqlFieldsQuery qry, boolean isQry) {
        Boolean qryFlag;
        Boolean bl = qryFlag = qry instanceof SqlFieldsQueryEx ? ((SqlFieldsQueryEx)qry).isQuery() : null;
        if (qryFlag != null && qryFlag != isQry) {
            throw new IgniteSQLException("Given statement type does not match that declared by JDBC driver", 3003);
        }
    }

    private static SqlFieldsQuery cloneFieldsQuery(SqlFieldsQuery oldQry) {
        return oldQry.copy().setLocal(oldQry.isLocal()).setPageSize(oldQry.getPageSize());
    }

    private static QueryDescriptor queryDescriptor(String schemaName, SqlFieldsQuery qry) {
        boolean batched = false;
        if (qry instanceof SqlFieldsQueryEx) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)qry;
            batched = qry0.isBatched();
        }
        return new QueryDescriptor(schemaName, qry.getSql(), qry.isCollocated(), qry.isDistributedJoins(), qry.isEnforceJoinOrder(), qry.isLocal(), !qry.isLocal() && qry.isSkipReducerOnUpdate(), batched, qry.getQueryInitiatorId(), qry.getLabel());
    }
}

