/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.internal.cache.query.SqlBuilderContext;
import org.apache.ignite.internal.cache.query.SqlIndexQueryCriterion;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IndexQuerySqlBuilderContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.table.IndexColumn;
import org.jetbrains.annotations.Nullable;

public class IndexQuerySqlGenerator {
    public static SqlGeneratorResult generate(IndexQuery<?, ?> qry, H2TableDescriptor tblDesc) {
        int i;
        SB buffer = new SB();
        buffer.a("SELECT ").a("_KEY").a(", ").a("_VAL");
        buffer.a(" FROM ").a(tblDesc.fullTableName());
        Index index = null;
        if (qry.getIndexName() != null) {
            index = IndexQuerySqlGenerator.resolveIndex(qry.getIndexName(), tblDesc.table());
            buffer.a(" USE INDEX (\"").a(index.getName()).a("\")");
        }
        ArrayList<Object> args = null;
        if (qry.getCriteria() != null) {
            List criteria = qry.getCriteria();
            args = new ArrayList<Object>();
            for (i = 0; i < criteria.size(); ++i) {
                IndexQueryCriterion criterion = (IndexQueryCriterion)criteria.get(i);
                if (i == 0) {
                    buffer.a(" WHERE ");
                } else {
                    buffer.a(" AND ");
                }
                if (!(criterion instanceof SqlIndexQueryCriterion)) {
                    throw new IllegalArgumentException(String.format("Unknown IndexQuery criterion type [%s]", criterion.getClass().getSimpleName()));
                }
                String condition = ((SqlIndexQueryCriterion)criterion).toSql((SqlBuilderContext)new IndexQuerySqlBuilderContext(tblDesc.table(), args));
                buffer.a(condition);
            }
        }
        if (index != null) {
            buffer.a(" ORDER BY ");
            IndexColumn[] idxColumns = index.getIndexColumns();
            for (i = 0; i < idxColumns.length; ++i) {
                if (i > 0) {
                    buffer.a(", ");
                }
                IndexColumn idxCol = idxColumns[i];
                buffer.a('\"').a(idxCol.columnName).a('\"');
                if (idxCol.sortType != 1) continue;
                buffer.a(" DESC");
            }
        }
        if (qry.getLimit() != 0) {
            buffer.a(" LIMIT ").a(qry.getLimit());
        }
        return new SqlGeneratorResult(buffer.toString(), args);
    }

    private static Index resolveIndex(String idxName, GridH2Table table) {
        ArrayList<Index> indexes = table.getIndexes();
        String upperCaseIdxName = idxName.toUpperCase();
        Index upperCaseIndex = null;
        for (Index idx : indexes) {
            if (idx.getName().equals(idxName)) {
                return idx;
            }
            if (upperCaseIndex != null || !idx.getName().equals(upperCaseIdxName)) continue;
            upperCaseIndex = idx;
        }
        if (upperCaseIndex != null) {
            return upperCaseIndex;
        }
        throw new IgniteException("Index \"" + upperCaseIdxName + "\" not found.");
    }

    static class SqlGeneratorResult {
        private final String sql;
        @Nullable
        private final List<Object> arguments;

        SqlGeneratorResult(String sql, @Nullable List<Object> arguments) {
            this.sql = sql;
            this.arguments = arguments;
        }

        String sql() {
            return this.sql;
        }

        @Nullable
        Object[] arguments() {
            return this.arguments == null ? null : this.arguments.toArray();
        }
    }
}

