/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.ContentTypeBundle;
import org.projectnessie.model.types.ContentTypeRegistry;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ContentTypes {
    public static Content.Type[] all() {
        return Registry.all();
    }

    @Nonnull
    public static Content.Type forName(String name) {
        return Registry.forName(name);
    }

    private static final class DefaultContentTypeImpl
    implements Content.Type {
        private DefaultContentTypeImpl() {
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return this.name();
        }

        @Override
        public String name() {
            return "UNKNOWN";
        }

        @Override
        public Class<? extends Content> type() {
            throw new IllegalStateException("UNKNOWN Content.Type has no type");
        }
    }

    private static final class ContentTypeImpl
    implements Content.Type {
        private final String name;
        private final Class<? extends Content> type;

        private ContentTypeImpl(String name, Class<? extends Content> type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<? extends Content> type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContentTypeImpl)) {
                return false;
            }
            ContentTypeImpl that = (ContentTypeImpl)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class Registry {
        private static final Content.Type[] all;
        private static final Map<String, Content.Type> byName;

        private Registry() {
        }

        private static Content.Type[] all() {
            return (Content.Type[])all.clone();
        }

        private static Content.Type forName(String name) {
            Content.Type type = byName.get(name);
            if (type == null) {
                throw new IllegalArgumentException("No content type registered for name " + name);
            }
            return type;
        }

        static {
            RegistryHelper registryHelper = new RegistryHelper();
            DefaultContentTypeImpl unknownContentType = new DefaultContentTypeImpl();
            registryHelper.add(unknownContentType);
            for (ContentTypeBundle bundle : ServiceLoader.load(ContentTypeBundle.class)) {
                bundle.register(registryHelper);
            }
            byName = Collections.unmodifiableMap(registryHelper.names);
            all = registryHelper.list.toArray(new Content.Type[0]);
        }
    }

    static final class RegistryHelper
    implements ContentTypeRegistry {
        private final List<Content.Type> list = new ArrayList<Content.Type>();
        private final Map<String, Content.Type> names = new HashMap<String, Content.Type>();

        RegistryHelper() {
        }

        @Override
        public void register(Class<? extends Content> type) {
            Objects.requireNonNull(type, "Illegal content-type registration: type must not be null");
            JsonTypeName jsonTypeName = type.getAnnotation(JsonTypeName.class);
            if (jsonTypeName == null) {
                throw new IllegalArgumentException(String.format("Content-type registration: %s has no @JsonTypeName annotation", type.getName()));
            }
            String name = jsonTypeName.value();
            if (name == null || name.trim().isEmpty() || !name.trim().equals(name)) {
                throw new IllegalArgumentException(String.format("Illegal content-type registration: illegal name '%s' for %s", name, type.getName()));
            }
            ContentTypeImpl contentType = new ContentTypeImpl(name, type);
            Content.Type ex = this.names.get(name);
            if (ex != null) {
                throw new IllegalStateException(String.format("Duplicate content type registration for %s/%s, existing: %s/%s", name, type.getName(), ex.name(), ex.type().getName()));
            }
            this.add(contentType);
        }

        void add(Content.Type unknownContentType) {
            this.list.add(unknownContentType);
            this.names.put(unknownContentType.name(), unknownContentType);
        }
    }
}

