/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import javax.annotation.Nullable;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v2.params.AbstractParams;
import org.projectnessie.api.v2.params.ReferencesParamsBuilder;
import org.projectnessie.model.FetchOption;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ReferencesParams
extends AbstractParams<ReferencesParams> {
    @Parameter(description="Specifies how much extra information is to be retrived from the server.\n\nIf the fetch option is set to 'ALL' the following addition information will be returned for each Branch object in the output:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits from the root to the HEAD of the branch).\n\nThe returned Tag instances will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetch")
    @Nullable
    private FetchOption fetchOption;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are:\n\n- ref (Reference) describes the reference, with fields name (String), hash (String), metadata (ReferenceMetadata)\n\n- metadata (ReferenceMetadata) shortcut to ref.metadata, never null, but possibly empty\n\n- commit (CommitMeta) - shortcut to ref.metadata.commitMetaOfHEAD, never null, but possibly empty\n\n- refType (String) - the reference type, either BRANCH or TAG\n\nNote that the expression can only test attributes metadata and commit, if 'fetchOption' is set to 'ALL'.", examples={@ExampleObject(ref="expr_by_refType"), @ExampleObject(ref="expr_by_ref_name"), @ExampleObject(ref="expr_by_ref_commit")})
    @QueryParam(value="filter")
    @Nullable
    private String filter;

    public ReferencesParams() {
    }

    @Builder.Constructor
    ReferencesParams(@Nullable Integer maxRecords, @Nullable String pageToken, @Nullable FetchOption fetchOption, @Nullable String filter) {
        super(maxRecords, pageToken);
        this.fetchOption = fetchOption;
        this.filter = filter;
    }

    @Nullable
    public FetchOption fetchOption() {
        return this.fetchOption;
    }

    @Nullable
    public String filter() {
        return this.filter;
    }

    public static ReferencesParamsBuilder builder() {
        return new ReferencesParamsBuilder();
    }

    public static ReferencesParams empty() {
        return ReferencesParams.builder().build();
    }

    @Override
    public ReferencesParams forNextPage(String pageToken) {
        return new ReferencesParams(this.maxRecords(), pageToken, this.fetchOption, this.filter);
    }
}

