/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.Size;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ImmutableNessieConfiguration;
import org.projectnessie.model.NessieConfigurationHolder;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Schema(type=SchemaType.OBJECT, title="NessieConfiguration", description="Configuration object to tell a client how a server is configured.")
@JsonSerialize(as=ImmutableNessieConfiguration.class)
@JsonDeserialize(as=ImmutableNessieConfiguration.class)
@Value.Immutable
public abstract class NessieConfiguration {
    @Nullable
    @jakarta.annotation.Nullable
    @Size
    @jakarta.validation.constraints.Size(min=1)
    public abstract @Size @jakarta.validation.constraints.Size(min=1) String getDefaultBranch();

    @JsonView(value={Views.V2.class})
    @Value.Default
    public int getMinSupportedApiVersion() {
        return 1;
    }

    public abstract int getMaxSupportedApiVersion();

    @JsonView(value={Views.V2.class})
    @Value.Default
    public int getActualApiVersion() {
        return 0;
    }

    @JsonView(value={Views.V2.class})
    @Nullable
    @jakarta.annotation.Nullable
    public abstract String getSpecVersion();

    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    @jakarta.annotation.Nullable
    public abstract String getNoAncestorHash();

    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    @jakarta.annotation.Nullable
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    public abstract Instant getRepositoryCreationTimestamp();

    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    @jakarta.annotation.Nullable
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    public abstract Instant getOldestPossibleCommitTimestamp();

    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract Map<String, String> getAdditionalProperties();

    public static NessieConfiguration getBuiltInConfig() {
        return NessieConfigurationHolder.NESSIE_API_SPEC;
    }
}

