/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.http;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.ws.rs.Consumes;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.projectnessie.api.v1.DiffApi;
import org.projectnessie.api.v1.params.DiffParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Tag(name="v1")
@javax.ws.rs.Consumes(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="v1/diffs")
@jakarta.ws.rs.Path(value="v1/diffs")
public interface HttpDiffApi
extends DiffApi {
    @Override
    @GET
    @jakarta.ws.rs.GET
    @Produces(value={"application/json"})
    @jakarta.ws.rs.Produces(value={"application/json"})
    @Path(value="{fromRefWithHash}...{toRefWithHash}")
    @jakarta.ws.rs.Path(value="{fromRefWithHash}...{toRefWithHash}")
    @Operation(summary="Get a diff for two given references", description="The URL pattern is basically 'from' and 'to' separated by '...' (three dots). 'from' and 'to' must start with a reference name, optionally followed by hash on that reference, the hash prefixed with the'*' character.\n\nExamples: \n  diffs/main...myBranch\n  diffs/main...myBranch\\*1234567890123456\n  diffs/main\\*1234567890123456...myBranch\n  diffs/main\\*1234567890123456...myBranch\\*1234567890123456\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned diff for the given references.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="diffResponse")}, schema=@Schema(implementation=DiffResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, fromRef/toRef name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given fromRef/toRef"), @APIResponse(responseCode="404", description="fromRef/toRef not found")})
    @JsonView(value={Views.V1.class})
    public DiffResponse getDiff(@BeanParam @jakarta.ws.rs.BeanParam DiffParams var1) throws NessieNotFoundException;
}

