/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt.join;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.join.RangeStream;
import org.apache.ignite.internal.processors.query.h2.opt.join.SegmentKey;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

public class BroadcastCursor
implements Cursor,
Comparator<RangeStream> {
    private final GridH2IndexBase idx;
    private final int rangeId;
    private final RangeStream[] streams;
    private boolean first = true;
    private int off;

    public BroadcastCursor(GridH2IndexBase idx, int rangeId, Collection<SegmentKey> segmentKeys, Map<SegmentKey, RangeStream> rangeStreams) {
        this.idx = idx;
        this.rangeId = rangeId;
        this.streams = new RangeStream[segmentKeys.size()];
        int i = 0;
        for (SegmentKey segmentKey : segmentKeys) {
            RangeStream stream = rangeStreams.get(segmentKey);
            assert (stream != null);
            this.streams[i++] = stream;
        }
    }

    @Override
    public int compare(RangeStream o1, RangeStream o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return this.idx.compareRows((SearchRow)o1.get(this.rangeId), (SearchRow)o2.get(this.rangeId));
    }

    private boolean goFirst() {
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i].next(this.rangeId)) continue;
            this.streams[i] = null;
            ++this.off;
        }
        if (this.off == this.streams.length) {
            return false;
        }
        Arrays.sort(this.streams, this);
        return true;
    }

    private boolean goNext() {
        assert (this.off != this.streams.length);
        if (!this.streams[this.off].next(this.rangeId)) {
            this.streams[this.off] = null;
            return ++this.off != this.streams.length;
        }
        H2Utils.bubbleUp(this.streams, this.off, this);
        return true;
    }

    public boolean next() {
        if (this.first) {
            this.first = false;
            return this.goFirst();
        }
        return this.goNext();
    }

    public Row get() {
        return this.streams[this.off].get(this.rangeId);
    }

    public SearchRow getSearchRow() {
        return this.get();
    }

    public boolean previous() {
        throw new UnsupportedOperationException();
    }
}

