/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class H2IndexCostedBase
extends BaseIndex {
    private final CostFunction constFunc;
    private final GridH2Table tbl;
    private final IgniteLogger log;

    protected H2IndexCostedBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        super((Table)tbl, 0, name, cols, type);
        CostFunctionType costFuncType;
        this.tbl = tbl;
        this.log = tbl.rowDescriptor().tableDescriptor().indexing().kernalContext().log("H2Index");
        try {
            costFuncType = CostFunctionType.valueOf(IgniteSystemProperties.getString((String)"IGNITE_INDEX_COST_FUNCTION", (String)CostFunctionType.LAST.name()));
        }
        catch (IllegalArgumentException e) {
            LT.warn((IgniteLogger)this.log, (String)("Invalid cost function: " + IgniteSystemProperties.getString((String)"IGNITE_INDEX_COST_FUNCTION") + ", the LAST cost function is used. Available functions: " + Arrays.toString((Object[])CostFunctionType.values())));
            costFuncType = CostFunctionType.LAST;
        }
        switch (costFuncType) {
            case COMPATIBLE_8_7_12: {
                this.constFunc = this::getCostRangeIndex_8_7_12;
                break;
            }
            case COMPATIBLE_8_7_6: {
                this.constFunc = this::getCostRangeIndex_8_7_6;
                break;
            }
            case COMPATIBLE_8_7_28: {
                this.constFunc = this::getCostRangeIndex_8_7_28;
                break;
            }
            default: {
                this.constFunc = new CostFunctionLast()::getCostRangeIndex;
            }
        }
    }

    protected long costRangeIndex(Session ses, int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, AllColumnsForPlan allColumnsSet) {
        return this.constFunc.getCostRangeIndex(ses, masks, rowCount, filters, filter, sortOrder, isScanIndex, allColumnsSet);
    }

    private long getCostRangeIndex_8_7_28(Session ses, int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, AllColumnsForPlan allColumnsSet) {
        TableFilter tableFilter;
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            while (i < len) {
                Column column;
                int index;
                int mask;
                if (((mask = masks[index = (column = this.columns[i++]).getColumnId()]) & 1) == 1) {
                    if (i == len && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = Math.min(5L + Math.max(rowsCost / distinctRows, 1L), rowsCost - (long)(i > 0 ? 1 : 0));
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = Math.min(5L + rowsCost / 4L, rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = Math.min(5L + rowsCost / 3L, rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if ((mask & 4) != 4) break;
                rowsCost = Math.min(rowsCost / 3L, rowsCost - (long)(i > 0 ? 1 : 0));
                break;
            }
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter2 = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter2);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean skipColumnsIntersection = false;
        if (filters != null && (tableFilter = filters[filter]) != null && this.columns != null) {
            skipColumnsIntersection = true;
            ArrayList idxConds = tableFilter.getIndexConditions();
            if (F.isEmpty((Collection)idxConds)) {
                skipColumnsIntersection = false;
            }
            for (IndexCondition cond : idxConds) {
                if (cond.getColumn() != this.columns[0]) continue;
                skipColumnsIntersection = false;
                break;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null && !skipColumnsIntersection) {
            boolean foundAllColumnsWeNeed = true;
            ArrayList foundCols = allColumnsSet.get(this.getTable());
            if (foundCols != null) {
                for (Column c : foundCols) {
                    boolean found = false;
                    for (Column c2 : this.columns) {
                        if (c != c2) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    foundAllColumnsWeNeed = false;
                    break;
                }
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }

    protected final long getCostRangeIndex_8_7_12(Session ses, int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, AllColumnsForPlan allColumnsSet) {
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            boolean tryAdditional = false;
            while (i < len) {
                Column column;
                int index;
                int mask;
                if (((mask = masks[index = (column = this.columns[i++]).getColumnId()]) & 1) == 1) {
                    if (i == len && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = 2L + Math.max(rowCount / distinctRows, 1L);
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = 2L + rowsCost / 4L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = 2L + rowsCost / 3L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 4) == 4) {
                    rowsCost /= 3L;
                    tryAdditional = true;
                    break;
                }
                if (mask != 0) break;
                --i;
                break;
            }
            if (tryAdditional) {
                while (i < len && masks[this.columns[i].getColumnId()] != 0) {
                    ++i;
                    --rowsCost;
                }
            }
            rowsCost += (long)(len - i);
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null) {
            boolean foundAllColumnsWeNeed = true;
            ArrayList foundCols = allColumnsSet.get(this.getTable());
            if (foundCols != null) {
                for (Column c : foundCols) {
                    boolean found = false;
                    for (Column c2 : this.columns) {
                        if (c != c2) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    foundAllColumnsWeNeed = false;
                    break;
                }
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }

    private final long getCostRangeIndex_8_7_6(Session ses, int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, AllColumnsForPlan allColumnsSet) {
        rowCount = 10000L;
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int len = this.columns.length;
            for (int i = 0; i < len; ++i) {
                long distinctRows;
                Column column = this.columns[i];
                int index = column.getColumnId();
                int mask = masks[index];
                if ((mask & 1) == 1) {
                    if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                } else {
                    if ((mask & 6) == 6) {
                        rowsCost = 2L + rowCount / 4L;
                        break;
                    }
                    if ((mask & 2) == 2) {
                        rowsCost = 2L + rowCount / 3L;
                        break;
                    }
                    if ((mask & 4) != 4) break;
                    rowsCost = rowCount / 3L;
                    break;
                }
                rowsCost = 2L + Math.max(rowCount / distinctRows, 1L);
            }
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null) {
            boolean foundAllColumnsWeNeed = true;
            ArrayList foundCols = allColumnsSet.get(this.getTable());
            if (foundCols != null) {
                for (Column c : foundCols) {
                    boolean found = false;
                    for (Column c2 : this.columns) {
                        if (c != c2) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    foundAllColumnsWeNeed = false;
                    break;
                }
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }

    private final class CostFunctionLast
    implements CostFunction {
        private final double NULL_FRACTION = 0.25;
        private final MathContext MATH_CONTEXT = MathContext.DECIMAL64;
        private final int RANGE_CLOSE_SELECTIVITY = 25;
        private final int RANGE_OPEN_SELECTIVITY = 33;

        private CostFunctionLast() {
        }

        private double nulls(ColumnStatistics colStat) {
            if (colStat == null) {
                return 0.25;
            }
            if (colStat.total() > 0L) {
                return (double)colStat.nulls() / (double)colStat.total();
            }
            return 0.0;
        }

        private long rowCost(Session ses, TableFilter filter, int[] masks, long rowCount, ObjectStatisticsImpl locTblStats) {
            double totalCardinality = 0.0;
            long rowsCost = rowCount;
            if (masks != null) {
                int i = 0;
                int len = H2IndexCostedBase.this.columns.length;
                while (i < len) {
                    Column column = H2IndexCostedBase.this.columns[i++];
                    ColumnStatistics colStats = this.getColumnStatistics(locTblStats, column);
                    int index = column.getColumnId();
                    int mask = masks[index];
                    if (this.isByteFlag(mask, 1)) {
                        long distinctRows;
                        double cardinality;
                        if (i == len && H2IndexCostedBase.this.getIndexType().isUnique()) {
                            rowsCost = 3L;
                            break;
                        }
                        Value equalValue = this.getEqualValue(ses, column, filter);
                        Boolean equalNull = equalValue == null ? null : Boolean.valueOf(equalValue.getValueType() == 0);
                        rowCount = this.getColumnSize(colStats, rowCount, equalNull);
                        if (colStats != null && equalNull == Boolean.TRUE) {
                            rowsCost = Math.min(5L + Math.max(Math.round((double)rowsCost * this.nulls(colStats)), 1L), rowsCost - (long)(i > 0 ? 1 : 0));
                            continue;
                        }
                        if (colStats != null && equalNull == Boolean.FALSE) {
                            rowsCost = Math.max(Math.round((double)rowsCost * (1.0 - this.nulls(colStats))), 1L);
                        }
                        if (colStats == null) {
                            cardinality = (double)column.getSelectivity() / 100.0;
                            totalCardinality = 1.0 - (1.0 - totalCardinality) * (1.0 - cardinality);
                            distinctRows = Math.round((double)rowCount * totalCardinality);
                        } else {
                            long nonNulls = colStats.total() - colStats.nulls();
                            cardinality = nonNulls == 0L ? 1.0 : (double)colStats.distinct() / (double)nonNulls;
                            totalCardinality = 1.0 - (1.0 - totalCardinality) * (1.0 - cardinality);
                            distinctRows = Math.round((double)rowCount * totalCardinality);
                        }
                        if (distinctRows <= 0L) {
                            distinctRows = 1L;
                        }
                        rowsCost = Math.min(5L + Math.max(rowsCost / distinctRows, 1L), rowsCost - (long)(i > 0 ? 1 : 0));
                        continue;
                    }
                    if (this.isByteFlag(mask, 6) || this.isByteFlag(mask, 2) || this.isByteFlag(mask, 4)) {
                        Value min = this.getStartValue(ses, column, filter);
                        Value max = this.getEndValue(ses, column, filter);
                        int percent = this.estimatePercent(colStats, min, max);
                        rowsCost = Math.min(5L + rowsCost * (long)percent / 100L, rowsCost - (long)(i > 0 ? 1 : 0));
                        break;
                    }
                    if (this.isNullFilter(ses, column, filter)) {
                        if (colStats == null) break;
                        rowsCost = Math.min(5L + colStats.nulls(), rowsCost - (long)(i > 0 ? 1 : 0));
                        break;
                    }
                    if (!this.isNotNullFilter(ses, column, filter) || colStats == null) break;
                    rowsCost = Math.min(5L + colStats.total() - colStats.nulls(), rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
            }
            return rowsCost;
        }

        private long getColumnSize(@Nullable ColumnStatistics colStats, long rowCount, Boolean nulls) {
            if (colStats == null) {
                return rowCount;
            }
            if (nulls == null) {
                return colStats.total();
            }
            if (nulls.booleanValue()) {
                return colStats.nulls();
            }
            return colStats.total() - colStats.nulls();
        }

        private Value getEqualValue(Session ses, Column column, TableFilter filter) {
            Value maxValue = null;
            for (IndexCondition cond : filter.getIndexConditions()) {
                Expression expr;
                if (!column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 0) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant()) continue;
                Value curVal = cond.getCurrentValue(ses);
                if (null != maxValue && curVal == null && filter.getTable().compareValues(curVal, maxValue) >= 0) continue;
                maxValue = curVal;
            }
            return maxValue;
        }

        private Value getStartValue(Session ses, Column column, TableFilter filter) {
            if (filter == null) {
                return null;
            }
            Value maxValue = null;
            for (IndexCondition cond : filter.getIndexConditions()) {
                Expression expr;
                if (!column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 2) && !this.isByteFlag(cond.getCompareType(), 1) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant()) continue;
                Value curVal = cond.getCurrentValue(ses);
                if (null != maxValue && curVal == null && filter.getTable().compareValues(curVal, maxValue) >= 0) continue;
                maxValue = curVal;
            }
            return maxValue;
        }

        private Value getEndValue(Session ses, Column column, TableFilter filter) {
            if (filter == null) {
                return null;
            }
            Value minValue = null;
            for (IndexCondition cond : filter.getIndexConditions()) {
                Expression expr;
                if (!column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 4) && !this.isByteFlag(cond.getCompareType(), 3) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant()) continue;
                Value curVal = cond.getCurrentValue(ses);
                if (null != minValue && curVal == null && filter.getTable().compareValues(minValue, curVal) >= 0) continue;
                minValue = curVal;
            }
            return minValue;
        }

        private boolean isNotNullFilter(Session ses, Column column, TableFilter filter) {
            return false;
        }

        private boolean isNullFilter(Session ses, Column column, TableFilter filter) {
            if (filter == null) {
                return false;
            }
            for (IndexCondition cond : filter.getIndexConditions()) {
                Value curVal;
                Expression expr;
                if (column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 11) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant() || (curVal = cond.getCurrentValue(ses)) == null || curVal.getValueType() != 0) continue;
                return true;
            }
            return false;
        }

        private boolean isByteFlag(int value, int mask) {
            return (value & mask) == mask;
        }

        private int estimatePercent(ColumnStatistics colStat, Value min, Value max) {
            BigDecimal start;
            BigDecimal maxValue;
            if (colStat == null || colStat.min() == null || colStat.max() == null) {
                return this.estimatePercentFallback(min, max);
            }
            BigDecimal minValue = min == null ? null : this.getComparableValue(min);
            BigDecimal bigDecimal = maxValue = max == null ? null : this.getComparableValue(max);
            if (minValue == null && maxValue == null) {
                return this.estimatePercentFallback(min, max);
            }
            BigDecimal minStat = this.getComparableValue(colStat.min());
            BigDecimal maxStat = this.getComparableValue(colStat.max());
            if (minStat == null || maxStat == null) {
                return this.estimatePercentFallback(min, max);
            }
            BigDecimal end = maxValue == null || maxValue.compareTo(maxStat) > 0 ? maxStat : maxValue;
            BigDecimal actual = end.subtract(start = minValue == null || minValue.compareTo(minStat) < 0 ? minStat : minValue);
            if (actual.signum() < 0) {
                return 0;
            }
            BigDecimal total = maxStat.subtract(minStat);
            if (total.signum() < 0) {
                return this.estimatePercentFallback(min, max);
            }
            if (total.signum() == 0) {
                return minStat.equals(start) ? 100 - (int)Math.round(this.nulls(colStat) * 100.0) : 0;
            }
            int result = actual.multiply(BigDecimal.valueOf(100L - colStat.nulls())).divide(total, this.MATH_CONTEXT).intValue();
            return result > 100 ? 100 : result;
        }

        private int estimatePercentFallback(Value min, Value max) {
            return min == null || max == null ? 33 : 25;
        }

        private BigDecimal getComparableValue(Value value) {
            switch (value.getValueType()) {
                case 0: {
                    throw new IllegalArgumentException("Can't compare null values");
                }
                case 1: {
                    return new BigDecimal(value.getBoolean() ? 1 : 0);
                }
                case 2: {
                    return new BigDecimal(value.getByte());
                }
                case 3: {
                    return new BigDecimal(value.getShort());
                }
                case 4: {
                    return new BigDecimal(value.getInt());
                }
                case 5: {
                    return new BigDecimal(value.getLong());
                }
                case 6: {
                    return value.getBigDecimal();
                }
                case 7: {
                    return new BigDecimal(value.getDouble());
                }
                case 8: {
                    return new BigDecimal(value.getFloat());
                }
                case 10: {
                    return new BigDecimal(value.getDate().getTime());
                }
                case 9: {
                    return new BigDecimal(value.getTime().getTime());
                }
                case 11: {
                    return new BigDecimal(value.getTimestamp().getTime());
                }
                case 12: {
                    BigInteger bigInteger = new BigInteger(1, value.getBytes());
                    return new BigDecimal(bigInteger);
                }
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 21: 
                case 22: 
                case 39: {
                    return null;
                }
                case 20: {
                    BigInteger bigInt = new BigInteger(1, value.getBytes());
                    return new BigDecimal(bigInt);
                }
            }
            throw new IllegalStateException("Unsupported H2 type: " + value.getType());
        }

        private ColumnStatistics getColumnStatistics(@Nullable ObjectStatisticsImpl locTblStats, Column column) {
            return locTblStats == null ? null : locTblStats.columnStatistics(column.getName());
        }

        private long sortingCost(long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex) {
            if (sortOrder == null) {
                return 0L;
            }
            long sortingCost = 100L + rowCount / 10L;
            if (!isScanIndex) {
                boolean sortOrderMatches = true;
                int coveringCount = 0;
                int[] sortTypes = sortOrder.getSortTypes();
                TableFilter tableFilter = filters == null ? null : filters[filter];
                int len = sortTypes.length;
                for (int i = 0; i < len && i < H2IndexCostedBase.this.indexColumns.length; ++i) {
                    Column col = sortOrder.getColumn(i, tableFilter);
                    if (col == null) {
                        sortOrderMatches = false;
                        break;
                    }
                    IndexColumn indexCol = H2IndexCostedBase.this.indexColumns[i];
                    if (!col.equals((Object)indexCol.column)) {
                        sortOrderMatches = false;
                        break;
                    }
                    int sortType = sortTypes[i];
                    if (sortType != indexCol.sortType) {
                        sortOrderMatches = false;
                        break;
                    }
                    ++coveringCount;
                }
                if (sortOrderMatches) {
                    sortingCost = 100 - coveringCount;
                }
            }
            return sortingCost;
        }

        @Override
        public long getCostRangeIndex(Session ses, int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, AllColumnsForPlan allColumnsSet) {
            ObjectStatisticsImpl locTblStats = (ObjectStatisticsImpl)H2IndexCostedBase.this.tbl.tableStatistics();
            if (locTblStats != null) {
                rowCount = locTblStats.rowCount();
            }
            TableFilter tableFilter = filters == null ? null : filters[filter];
            long rowsCost = this.rowCost(ses, tableFilter, masks, rowCount += 1000L, locTblStats);
            long sortingCost = this.sortingCost(rowCount, filters, filter, sortOrder, isScanIndex);
            boolean skipColumnsIntersection = false;
            if (filters != null && tableFilter != null && H2IndexCostedBase.this.columns != null) {
                skipColumnsIntersection = true;
                ArrayList idxConds = tableFilter.getIndexConditions();
                if (F.isEmpty((Collection)idxConds)) {
                    skipColumnsIntersection = false;
                }
                for (IndexCondition cond : idxConds) {
                    if (cond.getColumn() != H2IndexCostedBase.this.columns[0]) continue;
                    skipColumnsIntersection = false;
                    break;
                }
            }
            boolean needsToReadFromScanIndex = true;
            if (!isScanIndex && allColumnsSet != null && !skipColumnsIntersection) {
                boolean foundAllColumnsWeNeed = true;
                ArrayList foundCols = allColumnsSet.get(H2IndexCostedBase.this.getTable());
                if (foundCols != null) {
                    for (Column c : foundCols) {
                        boolean found = false;
                        for (Column c2 : H2IndexCostedBase.this.columns) {
                            if (c != c2) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        foundAllColumnsWeNeed = false;
                        break;
                    }
                }
                if (foundAllColumnsWeNeed) {
                    needsToReadFromScanIndex = false;
                }
            }
            long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)H2IndexCostedBase.this.columns.length);
            return rc;
        }
    }

    private static enum CostFunctionType {
        LAST,
        COMPATIBLE_8_7_28,
        COMPATIBLE_8_7_12,
        COMPATIBLE_8_7_6;

    }

    private static interface CostFunction {
        public long getCostRangeIndex(Session var1, int[] var2, long var3, TableFilter[] var5, int var6, SortOrder var7, boolean var8, AllColumnsForPlan var9);
    }
}

