/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class QueryMemoryTracker
implements H2MemoryTracker,
GridQueryMemoryMetricProvider {
    private static final AtomicIntegerFieldUpdater<QueryMemoryTracker> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueryMemoryTracker.class, "state");
    private static final int STATE_INITIAL = 0;
    private static final int STATE_CLOSED = 1;
    @GridToStringExclude
    private final H2MemoryTracker parent;
    private final long quota;
    private final boolean offloadingEnabled;
    private final long blockSize;
    private long reservedFromParent;
    private volatile long reserved;
    private volatile long maxReserved;
    private volatile long writtenOnDisk;
    private volatile long maxWrittenOnDisk;
    private volatile long totalWrittenOnDisk;
    private volatile int state;
    private final List<ChildMemoryTracker> children = new ArrayList<ChildMemoryTracker>();
    private volatile int filesCreated;

    public QueryMemoryTracker(H2MemoryTracker parent, long quota, long blockSize, boolean offloadingEnabled) {
        assert (quota >= 0L);
        this.offloadingEnabled = offloadingEnabled;
        this.parent = parent;
        this.quota = quota;
        this.blockSize = quota != 0L ? Math.min(quota, blockSize) : blockSize;
    }

    public synchronized boolean reserve(long size) {
        assert (size >= 0L);
        this.checkClosed();
        this.reserved += size;
        this.maxReserved = Math.max(this.maxReserved, this.reserved);
        if (this.parent != null && this.reserved > this.reservedFromParent && !this.reserveFromParent()) {
            return false;
        }
        if (this.quota > 0L && this.reserved >= this.quota) {
            return this.onQuotaExceeded();
        }
        return true;
    }

    private void checkClosed() {
        if (this.closed()) {
            throw new TrackerWasClosedException("Memory tracker has been closed concurrently.");
        }
    }

    private boolean reserveFromParent() {
        long blockSize = Math.max(this.reserved - this.reservedFromParent, this.blockSize);
        if (this.quota > 0L) {
            blockSize = Math.min(blockSize, this.quota - this.reservedFromParent);
        }
        if (this.parent.reserve(blockSize)) {
            this.reservedFromParent += blockSize;
        } else {
            return false;
        }
        return true;
    }

    private boolean onQuotaExceeded() {
        if (this.offloadingEnabled) {
            return false;
        }
        throw new SqlMemoryQuotaExceededException("SQL query ran out of memory: Query quota was exceeded.");
    }

    public synchronized void release(long size) {
        assert (size >= 0L);
        if (size == 0L || this.closed()) {
            return;
        }
        this.reserved -= size;
        assert (this.reserved >= 0L) : "Try to free more memory that ever be reserved: [reserved=" + (this.reserved + size) + ", toFree=" + size + ']';
        if (this.parent != null && this.reservedFromParent - this.reserved > this.blockSize) {
            this.releaseFromParent();
        }
    }

    private void releaseFromParent() {
        long toReleaseFromParent = this.reservedFromParent - this.reserved;
        this.parent.release(toReleaseFromParent);
        this.reservedFromParent -= toReleaseFromParent;
        assert (this.reservedFromParent >= 0L) : this.reservedFromParent;
    }

    public long reserved() {
        return this.reserved;
    }

    public long maxReserved() {
        return this.maxReserved;
    }

    public long writtenOnDisk() {
        return this.writtenOnDisk;
    }

    public long maxWrittenOnDisk() {
        return this.maxWrittenOnDisk;
    }

    public long totalWrittenOnDisk() {
        return this.totalWrittenOnDisk;
    }

    public boolean isOffloadingEnabled() {
        return this.offloadingEnabled;
    }

    public synchronized void spill(long size) {
        assert (size >= 0L);
        if (size == 0L) {
            return;
        }
        this.checkClosed();
        if (this.parent != null) {
            this.parent.spill(size);
        }
        this.writtenOnDisk += size;
        this.totalWrittenOnDisk += size;
        this.maxWrittenOnDisk = Math.max(this.maxWrittenOnDisk, this.writtenOnDisk);
    }

    public synchronized void unspill(long size) {
        assert (size >= 0L);
        if (size == 0L) {
            return;
        }
        this.checkClosed();
        if (this.parent != null) {
            this.parent.unspill(size);
        }
        this.writtenOnDisk -= size;
    }

    public boolean closed() {
        return STATE_UPDATER.get(this) == 1;
    }

    public synchronized void close() {
        if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
            return;
        }
        for (ChildMemoryTracker child : this.children) {
            child.closeSilently();
        }
        this.children.clear();
        this.reserved = 0L;
        if (this.parent != null) {
            this.parent.release(this.reservedFromParent);
            this.parent.unspill(this.writtenOnDisk);
        }
    }

    public synchronized void incrementFilesCreated() {
        if (this.parent != null) {
            this.parent.incrementFilesCreated();
        }
        ++this.filesCreated;
    }

    public synchronized H2MemoryTracker createChildTracker() {
        this.checkClosed();
        ChildMemoryTracker child = new ChildMemoryTracker(this);
        this.children.add(child);
        return child;
    }

    public synchronized void onChildClosed(H2MemoryTracker child) {
        if (this.state != 1) {
            this.children.remove(child);
        }
    }

    public String toString() {
        return S.toString(QueryMemoryTracker.class, (Object)this);
    }

    public static class TrackerWasClosedException
    extends RuntimeException {
        public TrackerWasClosedException(String msg) {
            super(msg);
        }
    }

    private static class ChildMemoryTracker
    implements H2MemoryTracker {
        private static final AtomicIntegerFieldUpdater<ChildMemoryTracker> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChildMemoryTracker.class, "state");
        private final H2MemoryTracker parent;
        private long reserved;
        private long writtenOnDisk;
        private long totalWrittenOnDisk;
        private volatile int state;

        public ChildMemoryTracker(H2MemoryTracker parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean reserve(long size) {
            boolean res;
            this.checkClosed();
            try {
                res = this.parent.reserve(size);
            }
            finally {
                this.reserved += size;
            }
            return res;
        }

        public void release(long size) {
            if (this.state == 1) {
                return;
            }
            this.reserved -= size;
            this.parent.release(size);
        }

        public long writtenOnDisk() {
            return this.writtenOnDisk;
        }

        public long totalWrittenOnDisk() {
            return this.totalWrittenOnDisk;
        }

        public long reserved() {
            return this.reserved;
        }

        public void spill(long size) {
            this.checkClosed();
            this.parent.spill(size);
            this.writtenOnDisk += size;
            this.totalWrittenOnDisk += size;
        }

        public void unspill(long size) {
            this.checkClosed();
            this.parent.unspill(size);
            this.writtenOnDisk -= size;
        }

        public void incrementFilesCreated() {
            this.checkClosed();
            this.parent.incrementFilesCreated();
        }

        public H2MemoryTracker createChildTracker() {
            this.checkClosed();
            return this.parent.createChildTracker();
        }

        public void onChildClosed(H2MemoryTracker child) {
            this.parent.onChildClosed(child);
        }

        public boolean closed() {
            return this.state == 1;
        }

        public void close() {
            if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
                return;
            }
            this.parent.release(this.reserved);
            this.parent.unspill(this.writtenOnDisk);
            this.reserved = 0L;
            this.writtenOnDisk = 0L;
            this.parent.onChildClosed((H2MemoryTracker)this);
        }

        void closeSilently() {
            if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
                return;
            }
            this.reserved = 0L;
            this.writtenOnDisk = 0L;
        }

        private void checkClosed() {
            if (this.state == 1) {
                throw new TrackerWasClosedException("Memory tracker has been closed concurrently.");
            }
        }
    }
}

