/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.h2.disk.GroupedExternalResult;
import org.gridgain.internal.h2.command.dml.GroupByData;
import org.gridgain.internal.h2.command.dml.SelectGroups;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

public class H2ManagedGroupByData
extends GroupByData {
    private final int[] grpIdx;
    private GroupedExternalResult sortedExtRes;
    private TreeMap<ValueRow, Object[]> groupByData;
    private ValueRow lastGrpKey;
    private Object[] lastGrpData;
    private Iterator<Map.Entry<ValueRow, Object[]>> cursor;
    private Map.Entry<ValueRow, Object[]> curEntry;
    private int size;

    public H2ManagedGroupByData(Session ses, int[] grpIdx) {
        super(ses);
        this.grpIdx = grpIdx;
        this.groupByData = new TreeMap(ses.getDatabase().getCompareMode());
    }

    private void createExtGroupByData() {
        QueryMemoryManager memMgr = (QueryMemoryManager)this.ses.groupByDataFactory();
        this.sortedExtRes = memMgr.createGroupedExternalResult(this.ses, this.size);
    }

    public Object[] nextSource(ValueRow grpKey, int width) {
        this.lastGrpKey = grpKey;
        this.lastGrpData = this.groupByData.get(grpKey);
        if (this.lastGrpData == null) {
            this.lastGrpData = new Object[width];
            this.groupByData.put(grpKey, this.lastGrpData);
            this.onGroupChanged(grpKey, null, this.lastGrpData);
            ++this.size;
        }
        return this.lastGrpData;
    }

    public long size() {
        return this.size;
    }

    public boolean next() {
        assert (this.cursor != null);
        boolean hasNext = this.cursor.hasNext();
        this.curEntry = hasNext ? this.cursor.next() : null;
        return hasNext;
    }

    public ValueRow groupKey() {
        assert (this.curEntry != null);
        return this.curEntry.getKey();
    }

    public Object[] groupByExprData() {
        assert (this.curEntry != null);
        return this.curEntry.getValue();
    }

    public void reset() {
        if (this.sortedExtRes != null) {
            this.sortedExtRes.close();
            this.sortedExtRes = null;
        }
        this.cursor = null;
        this.sortedExtRes = null;
        this.groupByData = new TreeMap(this.ses.getDatabase().getCompareMode());
        this.lastGrpKey = null;
        this.curEntry = null;
        this.tracker.close();
        this.tracker = null;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void onRowProcessed() {
        this.initTracker();
        assert (this.tracker != null) : "tracker should not be null";
        Object[] old = this.groupByData.put(this.lastGrpKey, this.lastGrpData);
        this.onGroupChanged(this.lastGrpKey, old, this.lastGrpData);
        if (!this.tracker.reserve(0L)) {
            if (this.sortedExtRes == null) {
                this.createExtGroupByData();
            }
            this.spillGroupsToDisk();
        }
    }

    private void spillGroupsToDisk() {
        this.sortedExtRes.spillGroupsToDisk(this.groupByData);
        for (Map.Entry<ValueRow, Object[]> row : this.groupByData.entrySet()) {
            SelectGroups.cleanupAggregates((Object[])row.getValue(), (Session)this.ses);
        }
        this.groupByData.clear();
        this.tracker.release(this.tracker.reserved());
    }

    public void updateCurrent(Object[] grpByExprData) {
        assert (this.size == 1) : "size=" + this.size;
        assert (this.sortedExtRes == null);
        Object[] old = this.groupByData.put(this.lastGrpKey, grpByExprData);
        this.onGroupChanged(this.lastGrpKey, old, grpByExprData);
    }

    public void done(int width) {
        if (this.grpIdx == null && this.sortedExtRes == null && this.groupByData.isEmpty()) {
            this.groupByData.put(ValueRow.getEmpty(), new Object[width]);
        }
        if (this.sortedExtRes != null) {
            if (!this.groupByData.isEmpty()) {
                this.spillGroupsToDisk();
            }
            this.sortedExtRes.reset();
            this.cursor = new ExternalGroupsIterator(this.sortedExtRes, this.ses);
        } else {
            this.cursor = this.groupByData.entrySet().iterator();
        }
    }

    private static class ExternalGroupsIterator
    implements Iterator<Map.Entry<ValueRow, Object[]>> {
        private final GroupedExternalResult sortedExtRes;
        private final CompareMode cmp;
        private final Session ses;
        private int extSize;
        private Map.Entry<ValueRow, Object[]> cur;
        private Map.Entry<ValueRow, Object[]> next;

        private ExternalGroupsIterator(GroupedExternalResult res, Session ses) {
            this.sortedExtRes = res;
            this.ses = ses;
            this.cmp = ses.getDatabase().getCompareMode();
            this.extSize = this.sortedExtRes.size();
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public Map.Entry<ValueRow, Object[]> next() {
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            Map.Entry<ValueRow, Object[]> res = this.cur;
            this.cur = this.next;
            this.next = null;
            this.advance();
            return res;
        }

        private void advance() {
            Map.Entry<ValueRow, Object[]> row;
            assert (this.next == null);
            while (this.extSize-- > 0 && (row = this.sortedExtRes.next()) != null) {
                if (this.cur == null) {
                    this.cur = row;
                    continue;
                }
                if (this.cur.getKey().compareTypeSafe((Value)row.getKey(), this.cmp) == 0) {
                    Object[] curAggs = this.cur.getValue();
                    for (int i = 0; i < curAggs.length; ++i) {
                        Object newAgg = row.getValue()[i];
                        Object curAgg = curAggs[i];
                        ExternalGroupsIterator.mergeAggregates(curAgg, newAgg, this.ses);
                    }
                    continue;
                }
                this.next = row;
                break;
            }
        }

        private static void mergeAggregates(Object curAgg, Object newAgg, Session ses) {
            assert (newAgg == null == (curAgg == null)) : "newAgg=" + newAgg + ", curAgg=" + curAgg;
            if (newAgg == null) {
                return;
            }
            assert (newAgg.getClass() == curAgg.getClass()) : "newAgg=" + newAgg + ", curAgg=" + curAgg;
            if (newAgg instanceof AggregateData) {
                ((AggregateData)curAgg).mergeAggregate(ses, (AggregateData)newAgg);
            } else if (!(newAgg instanceof Value)) {
                throw new UnsupportedOperationException("Unsupported aggregate:" + newAgg.getClass() + ", curAgg=" + curAgg.getClass());
            }
        }
    }
}

