/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.communication.tcp.internal.IPv4Matcher;
import org.apache.ignite.spi.communication.tcp.internal.NetworkInterfaceMatcher;

public class BlacklistFilter
implements IgnitePredicate<InetAddress> {
    private static final long serialVersionUID = 0L;
    private final List<NetworkInterfaceMatcher> matchers;

    public BlacklistFilter(Collection<String> blacklist) {
        this.matchers = new ArrayList<NetworkInterfaceMatcher>(blacklist.size());
        for (String pattern : blacklist) {
            if (pattern == null || pattern.trim().isEmpty()) continue;
            this.matchers.add(new IPv4Matcher(pattern));
        }
    }

    @Override
    public boolean apply(InetAddress inetAddress) {
        for (NetworkInterfaceMatcher m : this.matchers) {
            if (!m.matches(inetAddress)) continue;
            return false;
        }
        return true;
    }
}

