/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.service.LazyServiceConfiguration;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceInfo
implements ServiceDescriptor {
    private static final long serialVersionUID = 0L;
    private volatile transient GridKernalContext ctx;
    private final UUID originNodeId;
    private final IgniteUuid srvcId;
    private final ServiceConfiguration cfg;
    private final boolean staticCfg;
    @GridToStringInclude
    private volatile Map<UUID, Integer> top = Collections.emptyMap();
    private volatile transient Class<? extends Service> srvcCls;

    public ServiceInfo(@NotNull UUID originNodeId, @NotNull IgniteUuid srvcId, @NotNull ServiceConfiguration cfg) {
        this(originNodeId, srvcId, cfg, false);
    }

    public ServiceInfo(@NotNull UUID originNodeId, @NotNull IgniteUuid srvcId, @NotNull ServiceConfiguration cfg, boolean staticCfg) {
        this.originNodeId = originNodeId;
        this.srvcId = srvcId;
        this.cfg = cfg;
        this.staticCfg = staticCfg;
    }

    public void context(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    public void topologySnapshot(@NotNull Map<UUID, Integer> top) {
        this.top = top;
    }

    public ServiceConfiguration configuration() {
        return this.cfg;
    }

    public boolean staticallyConfigured() {
        return this.staticCfg;
    }

    public IgniteUuid serviceId() {
        return this.srvcId;
    }

    @Override
    public String name() {
        return this.cfg.getName();
    }

    @Override
    public Class<? extends Service> serviceClass() {
        if (this.cfg instanceof LazyServiceConfiguration) {
            if (this.srvcCls != null) {
                return this.srvcCls;
            }
            String clsName = ((LazyServiceConfiguration)this.cfg).serviceClassName();
            try {
                this.srvcCls = Class.forName(clsName);
                return this.srvcCls;
            }
            catch (ClassNotFoundException e) {
                GridDeployment srvcDep;
                if (this.ctx != null && (srvcDep = this.ctx.deploy().getDeployment(clsName)) != null) {
                    IgniteBiTuple<Class<?>, Throwable> classOrError = srvcDep.deployedClass(clsName, new String[0]);
                    this.srvcCls = classOrError.get1();
                    if (this.srvcCls != null) {
                        return this.srvcCls;
                    }
                    Throwable err = classOrError.get2();
                    if (err != null) {
                        e.addSuppressed(err);
                    }
                }
                throw new IgniteException("Failed to find service class: " + clsName, e);
            }
        }
        return this.cfg.getService().getClass();
    }

    @Override
    public int totalCount() {
        return this.cfg.getTotalCount();
    }

    @Override
    public int maxPerNodeCount() {
        return this.cfg.getMaxPerNodeCount();
    }

    @Override
    @Nullable
    public String cacheName() {
        return this.cfg.getCacheName();
    }

    @Override
    @Nullable
    public <K> K affinityKey() {
        return (K)this.cfg.getAffinityKey();
    }

    @Override
    public UUID originNodeId() {
        return this.originNodeId;
    }

    @Override
    public Map<UUID, Integer> topologySnapshot() {
        return Collections.unmodifiableMap(this.top);
    }

    public String toString() {
        return S.toString(ServiceInfo.class, this);
    }
}

