/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.ClientSqlUtils;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheEntryQueryCursor;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryResponse;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;

public class ClientCacheSqlQueryRequest
extends ClientCacheDataRequest
implements ClientTxAwareRequest {
    private final SqlQuery qry;

    public ClientCacheSqlQueryRequest(BinaryRawReaderEx reader, ClientProtocolContext protocolCtx) {
        super(reader);
        this.qry = ((SqlQuery)((SqlQuery)new SqlQuery(reader.readString(), reader.readString()).setArgs(ClientSqlUtils.readQueryArgs(reader, protocolCtx)).setDistributedJoins(reader.readBoolean()).setLocal(reader.readBoolean())).setReplicatedOnly(reader.readBoolean()).setPageSize(reader.readInt())).setTimeout((int)reader.readLong(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteCache<Object, Object> cache = this.cache(ctx);
        ctx.incrementCursors();
        try {
            QueryCursor<Cache.Entry> cur = cache.query(this.qry);
            ClientCacheEntryQueryCursor cliCur = new ClientCacheEntryQueryCursor(cur, this.qry.getPageSize(), ctx);
            long cursorId = ctx.resources().put(cliCur);
            cliCur.id(cursorId);
            return new ClientCacheQueryResponse(this.requestId(), cliCur);
        }
        catch (Throwable e) {
            ctx.decrementCursors();
            throw e;
        }
    }
}

