/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.DoubleMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricManager;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMetricManager
extends GridManagerAdapter<MetricExporterSpi>
implements ReadOnlyMetricManager {
    public static final String SQL_SPI = "org.apache.ignite.internal.processors.metric.sql.SqlViewMetricExporterSpi";
    private static final long METRICS_UPDATE_FREQ = 3000L;
    public static final String SYS_METRICS = "sys";
    public static final String IGNITE_METRICS = "ignite";
    public static final String PME_METRICS = "pme";
    public static final String CLUSTER_METRICS = "cluster";
    public static final String CLIENT_CONNECTOR_METRICS = MetricUtils.metricName("client", "connector");
    public static final String TX_METRICS = "tx";
    public static final String DIAGNOSTIC_METRICS = "diagnostic";
    public static final String GC_CPU_LOAD = "GcCpuLoad";
    public static final String GC_CPU_LOAD_DESCRIPTION = "GC CPU load.";
    public static final String CPU_LOAD = "CpuLoad";
    public static final String CPU_LOAD_DESCRIPTION = "CPU load.";
    public static final String UP_TIME = "UpTime";
    public static final String THREAD_CNT = "ThreadCount";
    public static final String PEAK_THREAD_CNT = "PeakThreadCount";
    public static final String TOTAL_STARTED_THREAD_CNT = "TotalStartedThreadCount";
    public static final String DAEMON_THREAD_CNT = "DaemonThreadCount";
    public static final String PME_DURATION = "Duration";
    public static final String PME_OPS_BLOCKED_DURATION = "CacheOperationsBlockedDuration";
    public static final String PME_DURATION_HISTOGRAM = "DurationHistogram";
    public static final String PME_OPS_BLOCKED_DURATION_HISTOGRAM = "CacheOperationsBlockedDurationHistogram";
    public static final String REBALANCED = "Rebalanced";
    private static final MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
    private static final OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    private static final RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
    private static final ThreadMXBean threads = ManagementFactory.getThreadMXBean();
    private static final Collection<GarbageCollectorMXBean> gc = ManagementFactory.getGarbageCollectorMXBeans();
    public static final String HITRATE_CFG_PREFIX = MetricUtils.metricName("metrics", "hitrate");
    public static final String HISTOGRAM_CFG_PREFIX = MetricUtils.metricName("metrics", "histogram");
    private final ConcurrentHashMap<String, ReadOnlyMetricRegistry> registries = new ConcurrentHashMap();
    private final List<Consumer<ReadOnlyMetricRegistry>> metricRegCreationLsnrs = new CopyOnWriteArrayList<Consumer<ReadOnlyMetricRegistry>>();
    private final List<Consumer<ReadOnlyMetricRegistry>> metricRegRemoveLsnrs = new CopyOnWriteArrayList<Consumer<ReadOnlyMetricRegistry>>();
    private volatile ReadableDistributedMetaStorage roMetastorage;
    private volatile DistributedMetaStorage metastorage;
    private GridTimeoutProcessor.CancelableTask metricsUpdateTask;
    private final DoubleMetricImpl gcCpuLoad;
    private final DoubleMetricImpl cpuLoad;
    private final MemoryUsageMetrics heap;
    private final MemoryUsageMetrics nonHeap;

    public GridMetricManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])((Supplier<MetricExporterSpi[]>)() -> {
            MetricExporterSpi[] spi = ctx.config().getMetricExporterSpi();
            if (!IgniteComponentType.INDEXING.inClassPath()) {
                return spi;
            }
            MetricExporterSpi[] spiWithSql = new MetricExporterSpi[spi != null ? spi.length + 1 : 1];
            if (!F.isEmpty(spi)) {
                System.arraycopy(spi, 0, spiWithSql, 0, spi.length);
            }
            try {
                spiWithSql[spiWithSql.length - 1] = (MetricExporterSpi)U.newInstance(SQL_SPI);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            return spiWithSql;
        }).get());
        ctx.addNodeAttribute("org.apache.ignite.phy.ram", this.totalSysMemory());
        this.heap = new MemoryUsageMetrics(SYS_METRICS, MetricUtils.metricName("memory", "heap"));
        this.nonHeap = new MemoryUsageMetrics(SYS_METRICS, MetricUtils.metricName("memory", "nonheap"));
        this.heap.update(mem.getHeapMemoryUsage());
        this.nonHeap.update(mem.getNonHeapMemoryUsage());
        MetricRegistry sysreg = this.registry(SYS_METRICS);
        this.gcCpuLoad = sysreg.doubleMetric(GC_CPU_LOAD, GC_CPU_LOAD_DESCRIPTION);
        this.cpuLoad = sysreg.doubleMetric(CPU_LOAD, CPU_LOAD_DESCRIPTION);
        sysreg.register("SystemLoadAverage", os::getSystemLoadAverage, Double.class, null);
        sysreg.register(UP_TIME, rt::getUptime, null);
        sysreg.register(THREAD_CNT, threads::getThreadCount, null);
        sysreg.register(PEAK_THREAD_CNT, threads::getPeakThreadCount, null);
        sysreg.register(TOTAL_STARTED_THREAD_CNT, threads::getTotalStartedThreadCount, null);
        sysreg.register(DAEMON_THREAD_CNT, threads::getDaemonThreadCount, null);
        sysreg.register("CurrentThreadCpuTime", threads::getCurrentThreadCpuTime, null);
        sysreg.register("CurrentThreadUserTime", threads::getCurrentThreadUserTime, null);
        MetricRegistry pmeReg = this.registry(PME_METRICS);
        long[] pmeBounds = new long[]{500L, 1000L, 5000L, 30000L};
        pmeReg.histogram(PME_DURATION_HISTOGRAM, pmeBounds, "Histogram of PME durations in milliseconds.");
        pmeReg.histogram(PME_OPS_BLOCKED_DURATION_HISTOGRAM, pmeBounds, "Histogram of cache operations blocked PME durations in milliseconds.");
    }

    @Override
    protected void onKernalStart0() {
        this.metricsUpdateTask = this.ctx.timeout().schedule(new MetricsUpdater(), 3000L, 3000L);
    }

    @Override
    public void start() throws IgniteCheckedException {
        for (MetricExporterSpi spi : (MetricExporterSpi[])this.getSpis()) {
            spi.setMetricRegistry(this);
        }
        this.startSpi();
        this.ctx.internalSubscriptionProcessor().registerDistributedMetastorageListener(new DistributedMetastorageLifecycleListener(){

            @Override
            public void onReadyForRead(ReadableDistributedMetaStorage metastorage) {
                GridMetricManager.this.roMetastorage = metastorage;
                try {
                    metastorage.iterate(HITRATE_CFG_PREFIX, (name, val) -> GridMetricManager.this.onHitRateConfigChanged(name.substring(HITRATE_CFG_PREFIX.length() + 1), (Long)val));
                    metastorage.iterate(HISTOGRAM_CFG_PREFIX, (name, val) -> GridMetricManager.this.onHistogramConfigChanged(name.substring(HISTOGRAM_CFG_PREFIX.length() + 1), (long[])val));
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
                metastorage.listen(n -> n.startsWith(HITRATE_CFG_PREFIX), (name, oldVal, newVal) -> GridMetricManager.this.onHitRateConfigChanged(name.substring(HITRATE_CFG_PREFIX.length() + 1), (Long)newVal));
                metastorage.listen(n -> n.startsWith(HISTOGRAM_CFG_PREFIX), (name, oldVal, newVal) -> GridMetricManager.this.onHistogramConfigChanged(name.substring(HISTOGRAM_CFG_PREFIX.length() + 1), (long[])newVal));
            }

            @Override
            public void onReadyForWrite(DistributedMetaStorage metastorage) {
                GridMetricManager.this.metastorage = metastorage;
            }
        });
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        U.closeQuiet(this.metricsUpdateTask);
    }

    public MetricRegistry registry(String name) {
        return (MetricRegistry)this.registries.computeIfAbsent(name, n -> {
            MetricRegistry mreg = new MetricRegistry(name, name, mname -> (Long)this.readFromMetastorage(MetricUtils.metricName(HITRATE_CFG_PREFIX, mname)), mname -> (long[])this.readFromMetastorage(MetricUtils.metricName(HISTOGRAM_CFG_PREFIX, mname)), this.log);
            IgniteUtils.notifyListeners(mreg, this.metricRegCreationLsnrs, this.log);
            return mreg;
        });
    }

    public Map<String, ReadOnlyMetricRegistry> registries() {
        return this.registries;
    }

    private <T extends Serializable> T readFromMetastorage(String key) {
        if (this.roMetastorage == null) {
            return null;
        }
        try {
            return this.roMetastorage.read(key);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    @NotNull
    public Iterator<ReadOnlyMetricRegistry> iterator() {
        return this.registries.values().iterator();
    }

    @Override
    public void addMetricRegistryCreationListener(Consumer<ReadOnlyMetricRegistry> lsnr) {
        this.metricRegCreationLsnrs.add(lsnr);
    }

    @Override
    public void addMetricRegistryRemoveListener(Consumer<ReadOnlyMetricRegistry> lsnr) {
        this.metricRegRemoveLsnrs.add(lsnr);
    }

    public void remove(String regName) {
        ReadOnlyMetricRegistry mreg = this.registries.remove(regName);
        if (mreg == null) {
            return;
        }
        IgniteUtils.notifyListeners(mreg, this.metricRegRemoveLsnrs, this.log);
        DistributedMetaStorage metastorage0 = this.metastorage;
        if (metastorage0 == null) {
            return;
        }
        if (ReadableDistributedMetaStorage.isSupported(this.ctx) && DistributedMetaStorage.longKeysSupported(this.ctx) && this.metastorage != null) {
            try {
                GridCompoundFuture opsFut = new GridCompoundFuture();
                for (Metric m : mreg) {
                    if (m instanceof HitRateMetric) {
                        opsFut.add(this.metastorage.removeAsync(MetricUtils.metricName(HITRATE_CFG_PREFIX, m.name())));
                        continue;
                    }
                    if (!(m instanceof HistogramMetric)) continue;
                    opsFut.add(this.metastorage.removeAsync(MetricUtils.metricName(HISTOGRAM_CFG_PREFIX, m.name())));
                }
                opsFut.markInitialized();
                opsFut.get();
            }
            catch (NodeStoppingException opsFut) {
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }

    public void configureHitRate(String name, long rateTimeInterval) throws IgniteCheckedException {
        A.notNullOrEmpty(name, "name");
        A.ensure(rateTimeInterval > 0L, "rateTimeInterval should be positive");
        A.notNull(this.metastorage, "Metastorage not ready. Node not started?");
        if (this.ctx.isStopping()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
        }
        this.metastorage.write(MetricUtils.metricName(HITRATE_CFG_PREFIX, name), Long.valueOf(rateTimeInterval));
    }

    public void configureHistogram(String name, long[] bounds) throws IgniteCheckedException {
        A.notNullOrEmpty(name, "name");
        A.notEmpty(bounds, "bounds");
        A.notNull(this.metastorage, "Metastorage not ready. Node not started?");
        if (this.ctx.isStopping()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
        }
        this.metastorage.write(MetricUtils.metricName(HISTOGRAM_CFG_PREFIX, name), (Serializable)bounds);
    }

    private void onHitRateConfigChanged(String name, @Nullable Long rateTimeInterval) {
        if (rateTimeInterval == null) {
            return;
        }
        A.ensure(rateTimeInterval > 0L, "rateTimeInterval should be positive");
        HitRateMetric m = this.find(name, HitRateMetric.class);
        if (m == null) {
            return;
        }
        m.reset(rateTimeInterval);
    }

    private void onHistogramConfigChanged(String name, @Nullable long[] bounds) {
        if (bounds == null) {
            return;
        }
        HistogramMetricImpl m = this.find(name, HistogramMetricImpl.class);
        if (m == null) {
            return;
        }
        m.reset(bounds);
    }

    private <T extends Metric> T find(String name, Class<T> type) {
        A.notNull(name, "name");
        T2<String, String> splitted = MetricUtils.fromFullName(name);
        MetricRegistry mreg = (MetricRegistry)this.registries.get(splitted.get1());
        if (mreg == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Metric registry not found[registry=" + (String)splitted.get1() + ']');
            }
            return null;
        }
        Object m = mreg.findMetric((String)splitted.get2());
        if (m == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Metric not found[registry=" + (String)splitted.get1() + ", metricName=" + (String)splitted.get2() + ']');
            }
            return null;
        }
        if (!m.getClass().isAssignableFrom(type)) {
            this.log.error("Metric '" + name + "' has wrong type[type=" + m.getClass().getSimpleName() + ']');
            return null;
        }
        return (T)m;
    }

    public MemoryUsage nonHeapMemoryUsage() {
        try {
            return mem.getNonHeapMemoryUsage();
        }
        catch (IllegalArgumentException ignored) {
            return new MemoryUsage(0L, 0L, 0L, 0L);
        }
    }

    public MemoryUsage heapMemoryUsage() {
        try {
            return mem.getHeapMemoryUsage();
        }
        catch (IllegalArgumentException ignored) {
            return new MemoryUsage(0L, 0L, 0L, 0L);
        }
    }

    private long totalSysMemory() {
        try {
            com.sun.management.OperatingSystemMXBean sunOs = (com.sun.management.OperatingSystemMXBean)os;
            return sunOs.getTotalPhysicalMemorySize();
        }
        catch (RuntimeException ignored) {
            return -1L;
        }
    }

    public class MemoryUsageMetrics {
        private final AtomicLongMetric init;
        private final AtomicLongMetric used;
        private final AtomicLongMetric committed;
        private final AtomicLongMetric max;

        public MemoryUsageMetrics(String group, String metricNamePrefix) {
            MetricRegistry mreg = GridMetricManager.this.registry(group);
            this.init = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "init"), null);
            this.used = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "used"), null);
            this.committed = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "committed"), null);
            this.max = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "max"), null);
        }

        public void update(MemoryUsage usage) {
            this.init.value(usage.getInit());
            this.used.value(usage.getUsed());
            this.committed.value(usage.getCommitted());
            this.max.value(usage.getMax());
        }
    }

    private class MetricsUpdater
    implements Runnable {
        private long prevGcTime = -1L;
        private long prevCpuTime = -1L;

        private MetricsUpdater() {
        }

        @Override
        public void run() {
            GridMetricManager.this.heap.update(GridMetricManager.this.heapMemoryUsage());
            GridMetricManager.this.nonHeap.update(GridMetricManager.this.nonHeapMemoryUsage());
            GridMetricManager.this.gcCpuLoad.value(this.getGcCpuLoad());
            GridMetricManager.this.cpuLoad.value(this.getCpuLoad());
        }

        private double getGcCpuLoad() {
            long gcTime = 0L;
            for (GarbageCollectorMXBean bean : gc) {
                long colTime = bean.getCollectionTime();
                if (colTime <= 0L) continue;
                gcTime += colTime;
            }
            gcTime /= (long)os.getAvailableProcessors();
            double gc = 0.0;
            if (this.prevGcTime > 0L) {
                long gcTimeDiff = gcTime - this.prevGcTime;
                gc = (double)gcTimeDiff / 3000.0;
            }
            this.prevGcTime = gcTime;
            return gc;
        }

        private double getCpuLoad() {
            long cpuTime;
            try {
                com.sun.management.OperatingSystemMXBean sunOs = (com.sun.management.OperatingSystemMXBean)os;
                cpuTime = sunOs.getProcessCpuTime();
            }
            catch (RuntimeException ignored) {
                return -1.0;
            }
            cpuTime /= (long)(1000000 * os.getAvailableProcessors());
            double cpu = 0.0;
            if (this.prevCpuTime > 0L) {
                long cpuTimeDiff = cpuTime - this.prevCpuTime;
                cpu = Math.min(1.0, (double)cpuTimeDiff / 3000.0);
            }
            this.prevCpuTime = cpuTime;
            return cpu;
        }

        public String toString() {
            return S.toString(MetricsUpdater.class, this, super.toString());
        }
    }
}

