/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpIgniteUpdatesChecker {
    private final String url;
    private final String charset;

    HttpIgniteUpdatesChecker(String url, String charset) {
        this.url = url;
        this.charset = charset;
    }

    public Map<String, String> getUpdates(String version, Map<String, Object> updateReq) throws IOException {
        StringBuilder bodyBuilder;
        HttpURLConnection conn = (HttpURLConnection)new URL(this.url).openConnection();
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        try (OutputStream os = conn.getOutputStream();){
            bodyBuilder = new StringBuilder("{");
            bodyBuilder.append("\"product\": \"gg\", \"version\": \"").append(version).append("\", \"instanceData\": {");
            for (Map.Entry<String, Object> entry : updateReq.entrySet()) {
                bodyBuilder.append("\"").append(entry.getKey()).append("\": ");
                if (entry.getValue() == null) {
                    bodyBuilder.append("null, ");
                    continue;
                }
                bodyBuilder.append("\"").append(HttpIgniteUpdatesChecker.escapeJson(entry.getValue().toString())).append("\", ");
            }
            bodyBuilder.delete(bodyBuilder.length() - 2, bodyBuilder.length());
            bodyBuilder.append("}}");
            os.write(bodyBuilder.toString().getBytes(this.charset));
            os.flush();
        }
        var5_5 = null;
        try (InputStream in = conn.getInputStream();){
            String line;
            if (in == null) {
                bodyBuilder = null;
                return bodyBuilder;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.charset));
            HashMap<String, String> res = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] parts = line.split("=", 2);
                if (parts.length == 2) {
                    res.put(parts[0].trim(), parts[1].trim());
                    continue;
                }
                res.put(line.trim(), null);
            }
            HashMap<String, String> hashMap = res;
            return hashMap;
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private static String escapeJson(String str) {
        return str.replaceAll("[\u0000-\u001f]", "").replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

